/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.model.api.IFileHistoryEdge;
import de.setsoftware.reviewtool.model.api.IFileHistoryNode;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryGraph;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryNode;
import de.setsoftware.reviewtool.model.changestructure.ProxyableFileHistoryEdge;
import de.setsoftware.reviewtool.model.changestructure.ProxyableFileHistoryNode;
import java.util.Set;

final class FileHistoryNodeProxy
extends ProxyableFileHistoryNode {
    private static final long serialVersionUID = -904039120792328999L;
    private final FileHistoryGraph graph;
    private final IRevisionedFile file;
    private final Set<ProxyableFileHistoryEdge> ancestors;
    private final Set<ProxyableFileHistoryEdge> descendants;
    private final IFileHistoryNode.Type type;
    private transient FileHistoryNode target;

    FileHistoryNodeProxy(FileHistoryGraph graph, IRevisionedFile file, Set<ProxyableFileHistoryEdge> ancestors, Set<ProxyableFileHistoryEdge> descendants, IFileHistoryNode.Type type) {
        this.graph = graph;
        this.file = file;
        this.ancestors = ancestors;
        this.descendants = descendants;
        this.type = type;
    }

    @Override
    public FileHistoryGraph getGraph() {
        return this.graph;
    }

    @Override
    public IRevisionedFile getFile() {
        return this.file;
    }

    @Override
    public boolean isRoot() {
        return this.getTarget().isRoot();
    }

    @Override
    public IFileHistoryNode.Type getType() {
        return this.type;
    }

    @Override
    public boolean isConfirmed() {
        return this.getTarget().isConfirmed();
    }

    @Override
    public boolean isCopyTarget() {
        return this.getTarget().isCopyTarget();
    }

    @Override
    public Set<? extends ProxyableFileHistoryEdge> getAncestors() {
        return this.getTarget().getAncestors();
    }

    @Override
    public Set<? extends ProxyableFileHistoryEdge> getDescendants() {
        return this.getTarget().getDescendants();
    }

    @Override
    void addAncestor(ProxyableFileHistoryEdge ancestor) {
        this.getTarget().addAncestor(ancestor);
    }

    @Override
    void removeAncestor(ProxyableFileHistoryEdge ancestor) {
        this.getTarget().removeAncestor(ancestor);
    }

    @Override
    void addDescendant(ProxyableFileHistoryNode descendant, IFileHistoryEdge.Type type) {
        this.getTarget().addDescendant(descendant, type);
    }

    @Override
    void makeDeleted() {
        this.getTarget().makeDeleted();
    }

    @Override
    void makeAdded() {
        this.getTarget().makeAdded();
    }

    @Override
    void makeReplaced() {
        this.getTarget().makeReplaced();
    }

    @Override
    void makeConfirmed() {
        this.getTarget().makeConfirmed();
    }

    private synchronized FileHistoryNode getTarget() {
        if (this.target == null) {
            this.target = new FileHistoryNode(this.graph, this.file, this.ancestors, this.descendants, this.type);
        }
        return this.target;
    }
}

