/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.WeakListeners;
import de.setsoftware.reviewtool.model.changestructure.Stop;
import de.setsoftware.reviewtool.model.changestructure.StopSelectionListener;
import java.lang.ref.WeakReference;

public class CurrentStop {
    private static WeakListeners<StopSelectionListener> listeners = new WeakListeners();
    private static WeakReference<Stop> currentStop;

    static void setCurrentStop(Stop fragment) {
        currentStop = new WeakReference<Stop>(fragment);
        listeners.notifyListeners(l -> l.notifyStopChange(fragment));
    }

    public static void unsetCurrentStop() {
        currentStop = null;
        listeners.notifyListeners(l -> l.notifyStopChange(null));
    }

    public static Stop getCurrentStop() {
        if (currentStop == null) {
            return null;
        }
        return (Stop)currentStop.get();
    }

    static void registerListener(StopSelectionListener listener) {
        listeners.add(listener);
        listener.notifyStopChange(CurrentStop.getCurrentStop());
    }

    static void unregisterListener(StopSelectionListener listener) {
        listeners.remove(listener);
    }
}

