/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.IPartiallyComparable;
import de.setsoftware.reviewtool.model.api.FileChangeType;
import de.setsoftware.reviewtool.model.api.IBinaryChange;
import de.setsoftware.reviewtool.model.api.IChange;
import de.setsoftware.reviewtool.model.api.IChangeData;
import de.setsoftware.reviewtool.model.api.ICommit;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.IHunk;
import de.setsoftware.reviewtool.model.api.ILocalRevision;
import de.setsoftware.reviewtool.model.api.IPositionInText;
import de.setsoftware.reviewtool.model.api.IRepoRevision;
import de.setsoftware.reviewtool.model.api.IRepository;
import de.setsoftware.reviewtool.model.api.IRevision;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.api.ITextualChange;
import de.setsoftware.reviewtool.model.api.IUnknownRevision;
import de.setsoftware.reviewtool.model.api.IWorkingCopy;
import de.setsoftware.reviewtool.model.changestructure.BinaryChange;
import de.setsoftware.reviewtool.model.changestructure.ChangeData;
import de.setsoftware.reviewtool.model.changestructure.Classification;
import de.setsoftware.reviewtool.model.changestructure.Commit;
import de.setsoftware.reviewtool.model.changestructure.FileInRevision;
import de.setsoftware.reviewtool.model.changestructure.Fragment;
import de.setsoftware.reviewtool.model.changestructure.Hunk;
import de.setsoftware.reviewtool.model.changestructure.LocalRevision;
import de.setsoftware.reviewtool.model.changestructure.PositionInText;
import de.setsoftware.reviewtool.model.changestructure.RepoRevision;
import de.setsoftware.reviewtool.model.changestructure.TextualChangeHunk;
import de.setsoftware.reviewtool.model.changestructure.UnknownRevision;
import java.util.Date;
import java.util.List;

public class ChangestructureFactory {
    public static Commit createCommit(IWorkingCopy wc, String message, List<? extends IChange> changes, IRevision revision, Date timestamp) {
        return new Commit(wc, message, changes, revision, timestamp);
    }

    public static IBinaryChange createBinaryChange(IWorkingCopy wc, FileChangeType fileChangeType, IRevisionedFile from, IRevisionedFile to) {
        return new BinaryChange(wc, fileChangeType, from, to, Classification.NONE);
    }

    public static ITextualChange createTextualChangeHunk(IWorkingCopy wc, FileChangeType fileChangeType, IFragment from, IFragment to) {
        return new TextualChangeHunk(wc, fileChangeType, from, to, Classification.NONE);
    }

    public static IRevisionedFile createFileInRevision(String path, IRevision revision) {
        return new FileInRevision(path, revision);
    }

    public static IFragment createFragment(IRevisionedFile file, IPositionInText from, IPositionInText to) {
        return new Fragment(file, from, to, new IFragment[0]);
    }

    public static IHunk createHunk(IFragment from, IFragment to) {
        return new Hunk(from, to);
    }

    public static ILocalRevision createLocalRevision(IWorkingCopy wc) {
        return new LocalRevision(wc);
    }

    public static <R extends IPartiallyComparable<R>> IRepoRevision<R> createRepoRevision(R id, IRepository repo) {
        return new RepoRevision<R>(id, repo);
    }

    public static IUnknownRevision createUnknownRevision(IRepository repo) {
        return new UnknownRevision(repo);
    }

    public static IPositionInText createPositionInText(int line, int column) {
        return new PositionInText(line, column);
    }

    public static IChangeData createChangeData(List<? extends ICommit> commits) {
        return new ChangeData(commits);
    }
}

