/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model;

import de.setsoftware.reviewtool.base.WeakListeners;
import de.setsoftware.reviewtool.model.EndTransition;
import de.setsoftware.reviewtool.model.IReviewDataCache;
import de.setsoftware.reviewtool.model.IReviewDataSaveListener;
import de.setsoftware.reviewtool.model.ITicketConnector;
import de.setsoftware.reviewtool.model.ITicketData;
import de.setsoftware.reviewtool.model.IUserInteraction;
import de.setsoftware.reviewtool.model.LocalReviewDataDecorator;
import de.setsoftware.reviewtool.model.TicketInfo;
import de.setsoftware.reviewtool.model.TicketLinkSettings;
import de.setsoftware.reviewtool.model.remarks.DummyMarker;
import de.setsoftware.reviewtool.model.remarks.ReviewData;
import de.setsoftware.reviewtool.model.remarks.ReviewRemark;
import de.setsoftware.reviewtool.model.remarks.ReviewRemarkException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ReviewStateManager {
    private final IReviewDataCache localReviewData;
    private ITicketConnector persistence;
    private final IUserInteraction userInteraction;
    private String ticketKey;
    private ITicketData cachedData;
    private final WeakListeners<IReviewDataSaveListener> saveListeners = new WeakListeners();

    public ReviewStateManager(IReviewDataCache localReviewData, ITicketConnector persistence, IUserInteraction userInteraction) {
        this.localReviewData = localReviewData;
        this.persistence = persistence;
        this.userInteraction = userInteraction;
    }

    public String getCurrentReviewData() {
        ITicketData ticket = this.loadTicketDataAndCheckExistence(true);
        if (ticket == null) {
            return null;
        }
        return ticket.getReviewData();
    }

    public void saveCurrentReviewData(String newData) {
        this.ensureTicketKeyIsSet();
        this.localReviewData.saveLocalReviewData(this.ticketKey, newData);
        this.cachedData = null;
        this.saveListeners.notifyListeners(l -> l.onSave(newData));
    }

    private void ensureTicketKeyIsSet() {
        if (this.ticketKey == null) {
            this.loadTicketDataAndCheckExistence(true);
        }
    }

    public void flushReviewData() {
        String cachedData = this.localReviewData.getLocalReviewData(this.ticketKey);
        if (cachedData != null) {
            this.persistence.saveReviewData(this.ticketKey, cachedData);
        }
        this.localReviewData.clearLocalReviewData(this.ticketKey);
    }

    public void clearLocalReviewData() {
        this.localReviewData.clearLocalReviewData(this.ticketKey);
    }

    public void addSaveListener(IReviewDataSaveListener l) {
        this.saveListeners.add(l);
    }

    public int getCurrentRound() {
        ITicketData ticket = this.getCurrentTicketData();
        return ticket.getCurrentRound();
    }

    public String getReviewerForRound(int number) {
        ITicketData ticket = this.getCurrentTicketData();
        return ticket.getReviewerForRound(number);
    }

    public String getReviewerForCurrentRound() {
        return this.getReviewerForRound(this.getCurrentRound());
    }

    public ITicketData getCurrentTicketData() {
        if (this.cachedData != null) {
            return this.cachedData;
        }
        return this.loadTicketDataAndCheckExistence(true);
    }

    private ITicketData loadTicketDataAndCheckExistence(boolean forReview) {
        if (this.ticketKey == null) {
            ITicketData data;
            do {
                this.ticketKey = this.userInteraction.getTicketChooser().choose(this.persistence, "", forReview);
                if (this.ticketKey != null) continue;
                return null;
            } while ((data = this.persistence.loadTicket(this.ticketKey)) == null);
            this.cachedData = this.decorateIfNeeded(data);
            return this.cachedData;
        }
        ITicketData data = this.persistence.loadTicket(this.ticketKey);
        while (data == null) {
            this.ticketKey = this.userInteraction.getTicketChooser().choose(this.persistence, this.ticketKey, forReview);
            if (this.ticketKey == null) {
                return null;
            }
            data = this.persistence.loadTicket(this.ticketKey);
        }
        this.cachedData = this.decorateIfNeeded(data);
        return this.cachedData;
    }

    private ITicketData decorateIfNeeded(ITicketData data) {
        String localData = this.localReviewData.getLocalReviewData(data.getTicketInfo().getId());
        return localData != null ? new LocalReviewDataDecorator(localData, data) : data;
    }

    public boolean selectTicket(boolean forReview) {
        return this.loadTicketDataAndCheckExistence(forReview) != null;
    }

    public void resetKey() {
        this.ticketKey = null;
        this.cachedData = null;
    }

    public String getTicketKey() {
        return this.ticketKey;
    }

    public void setPersistence(ITicketConnector newPersistence) {
        this.persistence = newPersistence;
    }

    public void changeStateToReadyForReview() {
        this.persistence.changeStateToReadyForReview(this.ticketKey);
    }

    public List<EndTransition> getPossibleTransitionsForReviewEnd() {
        return this.persistence.getPossibleTransitionsForReviewEnd(this.ticketKey);
    }

    public void changeStateAtReviewEnd(EndTransition transition) {
        this.persistence.changeStateAtReviewEnd(this.ticketKey, transition);
    }

    public IUserInteraction getUi() {
        return this.userInteraction;
    }

    public void startReviewing() {
        this.persistence.startReviewing(this.ticketKey);
    }

    public void startFixing() {
        this.persistence.startFixing(this.ticketKey);
    }

    public TicketLinkSettings getTicketLinkSettings() {
        return this.persistence.getLinkSettings();
    }

    public void deleteRemark(ReviewRemark remark) throws ReviewRemarkException {
        ReviewData data = this.getUi().getSyntaxFixer().getCurrentReviewDataParsed(this, DummyMarker.FACTORY);
        data.deleteRemark(remark);
        this.saveCurrentReviewData(data.serialize());
        remark.deleteMarker();
    }

    public void saveRemark(ReviewRemark remark) {
        ReviewData r = this.getUi().getSyntaxFixer().getCurrentReviewDataParsed(this, DummyMarker.FACTORY);
        r.merge(remark, this.getCurrentRound());
        this.saveCurrentReviewData(r.serialize());
    }

    public Map<Integer, String> getReviewersForRounds() {
        TreeMap<Integer, String> ret = new TreeMap<Integer, String>();
        int round = 1;
        while (round <= this.getCurrentRound()) {
            ret.put(round, this.getReviewerForRound(round));
            ++round;
        }
        return ret;
    }

    public List<TicketInfo> getTicketsForFilter(String filter, boolean review) {
        Set<String> allowedNames = review ? this.persistence.getFilterNamesForReview() : this.persistence.getFilterNamesForFixing();
        return this.persistence.getTicketsForFilter(allowedNames.contains(filter) ? filter : allowedNames.iterator().next());
    }
}

