/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.diffalgorithms;

import de.setsoftware.reviewtool.base.Pair;
import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.diffalgorithms.ContentView;
import de.setsoftware.reviewtool.diffalgorithms.FullFileView;
import de.setsoftware.reviewtool.diffalgorithms.OneFileView;
import de.setsoftware.reviewtool.model.api.IDiffAlgorithm;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.changestructure.ChangestructureFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

class SimpleSourceDiffAlgorithm
implements IDiffAlgorithm {
    private static final long serialVersionUID = -45643400400146359L;

    SimpleSourceDiffAlgorithm() {
    }

    @Override
    public List<Pair<IFragment, IFragment>> determineDiff(IRevisionedFile fileOldInfo, byte[] fileOld, IRevisionedFile fileNewInfo, byte[] fileNew, String charset) {
        FullFileView<String> lines1 = this.toLines(fileOld, charset);
        FullFileView<String> lines2 = this.toLines(fileNew, charset);
        FullFileView<LogicalChunk> chunks1 = this.chunk(lines1);
        FullFileView<LogicalChunk> chunks2 = this.chunk(lines2);
        List<ContentView<LogicalChunk>> logicalChunksWithDifferences = new ContentView<LogicalChunk>(chunks1, chunks2).lcsDiff();
        ArrayList<ContentView<String>> linesWithDifferences = new ArrayList<ContentView<String>>();
        for (ContentView<LogicalChunk> cur : logicalChunksWithDifferences) {
            linesWithDifferences.addAll(new ContentView<String>(LogicalChunk.resolveChunking(chunks1, cur.getFile1()), LogicalChunk.resolveChunking(chunks2, cur.getFile2())).lcsDiff());
        }
        return this.toFragments(fileOldInfo, fileNewInfo, linesWithDifferences);
    }

    private FullFileView<LogicalChunk> chunk(FullFileView<String> lines) {
        ArrayList<LogicalChunk> logicalChunks = new ArrayList<LogicalChunk>();
        int curChunkStart = 0;
        boolean endAtFirstNonEmptyLine = false;
        int i = 0;
        while (i < lines.getItemCount()) {
            if (endAtFirstNonEmptyLine && !lines.getItem(i).trim().isEmpty()) {
                logicalChunks.add(new LogicalChunk(lines, curChunkStart, i));
                endAtFirstNonEmptyLine = false;
                curChunkStart = i;
            }
            if (this.looksLikeChunkEnd(lines.getItem(i))) {
                endAtFirstNonEmptyLine = true;
            }
            ++i;
        }
        if (curChunkStart < lines.getItemCount() || logicalChunks.isEmpty()) {
            logicalChunks.add(new LogicalChunk(lines, curChunkStart, lines.getItemCount()));
        }
        return new FullFileView<LogicalChunk>(logicalChunks.toArray(new LogicalChunk[logicalChunks.size()]));
    }

    private boolean looksLikeChunkEnd(String line) {
        return line.contains("}") || line.contains("</");
    }

    private List<Pair<IFragment, IFragment>> toFragments(IRevisionedFile fileOldInfo, IRevisionedFile fileNewInfo, List<ContentView<String>> changedFragments) {
        ArrayList<Pair<IFragment, IFragment>> ret = new ArrayList<Pair<IFragment, IFragment>>();
        for (ContentView<String> v : changedFragments) {
            if (this.isSingleLineChange(v)) {
                ret.add(this.createInLineDiffFragment(fileOldInfo, fileNewInfo, v));
                continue;
            }
            ret.add(Pair.create(this.toFileFragment(fileOldInfo, v.getFile1()), this.toFileFragment(fileNewInfo, v.getFile2())));
        }
        return ret;
    }

    private boolean isSingleLineChange(ContentView<String> v) {
        return v.getFile1().getItemCount() == 1 && v.getFile2().getItemCount() == 1;
    }

    private Pair<IFragment, IFragment> createInLineDiffFragment(IRevisionedFile fileOldInfo, IRevisionedFile fileNewInfo, ContentView<String> v) {
        String content1 = v.getFile1().getItem(0);
        String content2 = v.getFile2().getItem(0);
        assert (!content1.equals(content2));
        int commonPrefixLength = this.determineCommonPrefixLength(content1, content2);
        int commonSuffixLength = this.determineCommonSuffixLength(content1.substring(commonPrefixLength), content2.substring(commonPrefixLength));
        return Pair.create(this.toInLineFileFragment(fileOldInfo, v.getFile1(), commonPrefixLength, commonSuffixLength), this.toInLineFileFragment(fileNewInfo, v.getFile2(), commonPrefixLength, commonSuffixLength));
    }

    private int determineCommonPrefixLength(String content1, String content2) {
        int max = Math.min(content1.length(), content2.length());
        int i = 0;
        while (i < max) {
            if (content1.charAt(i) != content2.charAt(i)) {
                return i;
            }
            ++i;
        }
        return max;
    }

    private int determineCommonSuffixLength(String content1, String content2) {
        int max = Math.min(content1.length(), content2.length());
        int i = 1;
        while (i <= max) {
            if (content1.charAt(content1.length() - i) != content2.charAt(content2.length() - i)) {
                return i - 1;
            }
            ++i;
        }
        return max;
    }

    private IFragment toInLineFileFragment(IRevisionedFile fileInfo, OneFileView<String> fragmentData, int prefixLength, int suffixLength) {
        String line = fragmentData.getItem(0);
        return ChangestructureFactory.createFragment(fileInfo, ChangestructureFactory.createPositionInText(fragmentData.toIndexInWholeFile(0) + 1, prefixLength + 1), ChangestructureFactory.createPositionInText(fragmentData.toIndexInWholeFile(0) + 1, line.length() - suffixLength + 1));
    }

    private IFragment toFileFragment(IRevisionedFile fileInfo, OneFileView<String> fragmentData) {
        return ChangestructureFactory.createFragment(fileInfo, ChangestructureFactory.createPositionInText(fragmentData.toIndexInWholeFile(0) + 1, 1), ChangestructureFactory.createPositionInText(fragmentData.toIndexInWholeFile(fragmentData.getItemCount() - 1) + 2, 1));
    }

    private FullFileView<String> toLines(byte[] contents, String charset) {
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(contents), charset));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = r.readLine()) != null) {
                lines.add(line);
            }
            return new FullFileView<String>(lines.toArray(new String[lines.size()]));
        }
        catch (IOException e) {
            throw new ReviewtoolException(e);
        }
    }

    private static final class LogicalChunk {
        private final FullFileView<String> lines;
        private final int startIndex;
        private final int endIndex;

        public LogicalChunk(FullFileView<String> lines, int start, int end) {
            this.lines = lines;
            this.startIndex = start;
            this.endIndex = end;
        }

        public static OneFileView<String> resolveChunking(FullFileView<LogicalChunk> allChunks, OneFileView<LogicalChunk> chunks) {
            FullFileView<String> allLines = allChunks.getItem((int)0).lines;
            int firstIndex = chunks.toIndexInWholeFile(0);
            if (firstIndex >= allChunks.getItemCount()) {
                return allLines.subrange(allLines.getItemCount(), allLines.getItemCount());
            }
            LogicalChunk first = allChunks.getItem(firstIndex);
            if (chunks.getItemCount() == 0) {
                return allLines.subrange(first.startIndex, first.startIndex);
            }
            LogicalChunk last = allChunks.getItem(chunks.toIndexInWholeFile(chunks.getItemCount() - 1));
            return allLines.subrange(first.startIndex, last.endIndex);
        }

        public int hashCode() {
            return this.endIndex - this.startIndex;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LogicalChunk)) {
                return false;
            }
            LogicalChunk c = (LogicalChunk)o;
            int cLength = c.endIndex - c.startIndex;
            int thisLength = this.endIndex - this.startIndex;
            if (cLength != thisLength) {
                return false;
            }
            int i = 0;
            while (i < thisLength) {
                if (!this.lines.getItem(this.startIndex + i).equals(c.lines.getItem(c.startIndex + i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public String toString() {
            return this.lines.subrange(this.startIndex, this.endIndex).toString();
        }
    }
}

