/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.base.tree;

import de.setsoftware.reviewtool.base.tree.TreeNode;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractTreeNode<K, V, SelfT extends TreeNode<K, V, SelfT>>
implements TreeNode<K, V, SelfT>,
Serializable {
    private static final long serialVersionUID = 3535612955038411471L;
    private final SelfT parent;
    private V value;

    protected AbstractTreeNode(SelfT parent, V value) {
        this.parent = parent;
        this.value = value;
    }

    @Override
    public final SelfT getParent() {
        return this.parent;
    }

    @Override
    public final V getValue() {
        return this.value;
    }

    @Override
    public final V getValue(K key) {
        Object result = this.getNode(key);
        return result == null ? null : (V)result.getValue();
    }

    @Override
    public final V getValue(List<K> path) {
        SelfT result = this.getNode(path);
        return result == null ? null : (V)result.getValue();
    }

    @Override
    public final void setValue(V value) {
        this.value = value;
    }

    @Override
    public final SelfT getNode(List<K> path) {
        SelfT current = this.getSelf();
        for (K key : path) {
            Object child = current.getNode(key);
            if (child == null) {
                return null;
            }
            current = child;
        }
        return current;
    }

    @Override
    public final SelfT putValue(List<K> path, V value) {
        SelfT current = this.getSelf();
        for (K key : path) {
            Object child = current.getNode(key);
            if (child == null) {
                child = current.putValue(key, null);
            }
            current = child;
        }
        current.setValue(value);
        return current;
    }

    @Override
    public final List<V> getValues(List<K> path) {
        LinkedList result = new LinkedList();
        SelfT current = this.getSelf();
        Iterator<K> it = path.iterator();
        while (it.hasNext()) {
            Object child = current.getNode(it.next());
            if (child == null) break;
            if (current.getValue() != null) {
                result.add(0, current.getValue());
            }
            current = child;
        }
        if (current.getValue() != null) {
            result.add(0, current.getValue());
        }
        return result;
    }

    @Override
    public final V getNearestValue(List<K> path) {
        V lastKnownValue = null;
        SelfT current = this.getSelf();
        for (K key : path) {
            Object child;
            if (current.getValue() != null) {
                lastKnownValue = current.getValue();
            }
            if ((child = current.getNode(key)) == null) break;
            current = child;
        }
        return current.getValue() != null ? (V)current.getValue() : lastKnownValue;
    }

    @Override
    public final int getHeight() {
        int maxChildHeight = 0;
        for (Map.Entry entry : this.getEntries()) {
            int childHeight = ((TreeNode)entry.getValue()).getHeight();
            if (childHeight <= maxChildHeight) continue;
            maxChildHeight = childHeight;
        }
        return 1 + maxChildHeight;
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractTreeNode) {
            AbstractTreeNode other = (AbstractTreeNode)o;
            return Objects.equals(this.value, other.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    protected abstract SelfT getSelf();
}

