/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.base;

import de.setsoftware.reviewtool.base.IMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Multimap<K, V>
implements Serializable,
IMultimap<K, V> {
    private static final long serialVersionUID = -2669248894482975071L;
    private final Map<K, List<V>> map = new LinkedHashMap<K, List<V>>();

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void put(K key, V value) {
        List<V> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.map.put(key, list);
        }
        list.add(value);
    }

    @Override
    public List<V> get(K key) {
        List<V> list = this.map.get(key);
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    @Override
    public void putAll(IMultimap<? extends K, ? extends V> other) {
        for (Map.Entry<K, List<V>> entry : other.entrySet()) {
            for (V value : entry.getValue()) {
                this.put(entry.getKey(), value);
            }
        }
    }

    public void putAll(K key, Collection<V> values) {
        if (values.isEmpty()) {
            return;
        }
        List<V> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.map.put(key, list);
        }
        list.addAll(values);
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    @Override
    public void removeKey(K key) {
        this.map.remove(key);
    }

    @Override
    public void removeValue(K key, V value) {
        List<V> list = this.map.get(key);
        if (list != null) {
            list.remove(value);
            if (list.isEmpty()) {
                this.removeKey(key);
            }
        }
    }

    public String toString() {
        return this.map.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Multimap)) {
            return false;
        }
        Multimap m = (Multimap)o;
        return this.map.equals(m.map);
    }

    @Override
    public K keyWithMaxNumberOfValues() {
        int maxSize = 0;
        K maxKey = null;
        for (Map.Entry<K, List<V>> e : this.map.entrySet()) {
            if (e.getValue().size() <= maxSize) continue;
            maxSize = e.getValue().size();
            maxKey = e.getKey();
        }
        return maxKey;
    }

    @Override
    public void sortValues() {
        for (Map.Entry<K, List<V>> e : this.map.entrySet()) {
            List<V> values = e.getValue();
            Collections.sort(values);
        }
    }

    public void sortValues(Comparator<? super V> comparator) {
        for (Map.Entry<K, List<V>> e : this.map.entrySet()) {
            List<V> values = e.getValue();
            Collections.sort(values, comparator);
        }
    }

    @Override
    public IMultimap<K, V> readOnlyView() {
        return new IMultimap<K, V>(){

            @Override
            public boolean isEmpty() {
                return Multimap.this.isEmpty();
            }

            @Override
            public void put(K key, V value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<V> get(K key) {
                return Multimap.this.get(key);
            }

            @Override
            public void putAll(IMultimap<? extends K, ? extends V> other) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<K> keySet() {
                return Multimap.this.keySet();
            }

            @Override
            public Set<Map.Entry<K, List<V>>> entrySet() {
                return Multimap.this.entrySet();
            }

            @Override
            public void removeKey(K key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeValue(K key, V value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public K keyWithMaxNumberOfValues() {
                return Multimap.this.keyWithMaxNumberOfValues();
            }

            @Override
            public void sortValues() {
                throw new UnsupportedOperationException();
            }

            @Override
            public IMultimap<K, V> readOnlyView() {
                return this;
            }
        };
    }
}

