/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering.efficientalgorithm;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CountingSet<T> {
    private final Map<T, Counter> items;

    public CountingSet() {
        this.items = new LinkedHashMap<T, Counter>();
    }

    public CountingSet(int initialCapacity) {
        this.items = new LinkedHashMap<T, Counter>(initialCapacity);
    }

    public void addAll(Set<T> items) {
        for (T item : items) {
            this.add(item);
        }
    }

    private void add(T item) {
        Counter c = this.items.get(item);
        if (c == null) {
            this.items.put(item, new Counter());
        } else {
            Counter counter = c;
            counter.count = counter.count + 1;
        }
    }

    public int get(T item) {
        Counter c = this.items.get(item);
        return c == null ? 0 : c.count;
    }

    public Set<T> keys() {
        return this.items.keySet();
    }

    private static final class Counter {
        private int count = 1;

        private Counter() {
        }
    }
}

