/*
 * Decompiled with CFR 0.152.
 */
package de.set.intellij.messages.foldings;

import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import de.set.intellij.messages.dialogs.LocalizeLiteralsDialogForJava;
import de.set.intellij.messages.domain.Language;
import de.set.intellij.messages.domain.MessagesConglomerate;
import de.set.intellij.messages.foldings.EditMessageValueTooltipManager;
import de.set.intellij.messages.util.psiNavigation.MessagesExtractionHelper;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u001d\u0010\u0006\u001a\u00020\u00052\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0014\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0011"}, d2={"Lde/set/intellij/messages/foldings/EditMessagesAction;", "Lcom/intellij/refactoring/actions/BaseRefactoringAction;", "<init>", "()V", "isAvailableInEditorOnly", "", "isEnabledOnElements", "elements", "", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/psi/PsiElement;)Z", "getHandler", "Lcom/intellij/refactoring/RefactoringActionHandler;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "EditMessagesHandler", "Companion", "Messages_Externalisieren"})
public final class EditMessagesAction
extends BaseRefactoringAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "EditMessagesAction";
    @NotNull
    private static final Key<Boolean> EDITABLE_MESSAGE_VALUE;

    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return false;
    }

    @NotNull
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return new EditMessagesHandler();
    }

    static {
        Key key = Key.create((String)"editable.message.value");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        EDITABLE_MESSAGE_VALUE = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/set/intellij/messages/foldings/EditMessagesAction$Companion;", "", "<init>", "()V", "ID", "", "EDITABLE_MESSAGE_VALUE", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "registerFoldedElement", "", "element", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "isEnabled", "editor", "Lcom/intellij/openapi/editor/Editor;", "getEditableElement", "region", "Lcom/intellij/openapi/editor/FoldRegion;", "Messages_Externalisieren"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerFoldedElement(@NotNull PsiElement element, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            element.putUserData(EDITABLE_MESSAGE_VALUE, (Object)true);
            EditMessageValueTooltipManager.Companion.initializeForDocument(document);
        }

        public final boolean isEnabled(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (!(editor instanceof EditorImpl) || ((EditorImpl)editor).getProject() == null) {
                return false;
            }
            FoldRegion foldRegion = ((EditorImpl)editor).getFoldingModel().getCollapsedRegionAtOffset(((EditorImpl)editor).getCaretModel().getOffset());
            if (foldRegion == null) {
                return false;
            }
            FoldRegion region = foldRegion;
            return this.getEditableElement(region) != null;
        }

        private final PsiElement getEditableElement(FoldRegion region) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = EditorFoldingInfo.get((Editor)region.getEditor()).getPsiElement(region);
            return (psiElement2 != null ? (Boolean)psiElement2.getUserData(EDITABLE_MESSAGE_VALUE) : null) == null ? null : psiElement;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lde/set/intellij/messages/foldings/EditMessagesAction$EditMessagesHandler;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "<init>", "()V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "Messages_Externalisieren"})
    private static final class EditMessagesHandler
    implements RefactoringActionHandler {
        public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file, @Nullable DataContext dataContext) {
            LocalizeLiteralsDialogForJava dialog;
            boolean shouldRefactor;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!(editor instanceof EditorImpl) || ((EditorImpl)editor).getProject() == null) {
                throw new Exception("unexpectedly got no project");
            }
            if (!(file instanceof PsiJavaFile)) {
                throw new Exception("file is unexpectedly no PsiJavaFile");
            }
            FoldRegion foldRegion = ((EditorImpl)editor).getFoldingModel().getCollapsedRegionAtOffset(((EditorImpl)editor).getCaretModel().getOffset());
            if (foldRegion == null) {
                throw new Exception("unexpectedly folded message call");
            }
            FoldRegion region = foldRegion;
            PsiElement psiElement = Companion.getEditableElement(region);
            PsiMethodCallExpression psiMethodCallExpression = psiElement instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)psiElement : null;
            if (psiMethodCallExpression == null) {
                throw new Exception("folded message was unexpectedly of wrong type");
            }
            PsiMethodCallExpression psiElement2 = psiMethodCallExpression;
            String string = MessagesExtractionHelper.INSTANCE.extractTextFromMessagesCall(psiElement2, Language.DE, false);
            if (string == null) {
                throw new Exception("could not extract german text");
            }
            String string2 = MessagesExtractionHelper.INSTANCE.extractTextFromMessagesCall(psiElement2, Language.EN, false);
            if (string2 == null) {
                throw new Exception("could not extract english text");
            }
            Map<PsiExpression, String> map = MessagesExtractionHelper.INSTANCE.getParametersFromMessagesCallWithNames(psiElement2);
            PsiExpression psiExpression = (PsiExpression)psiElement2;
            String string3 = psiElement2.getMethodExpression().getReferenceName();
            if (string3 == null) {
                string3 = "";
            }
            if (!(shouldRefactor = (dialog = new LocalizeLiteralsDialogForJava(project, string, string2, map, psiExpression, string3)).showAndGet())) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project, () -> EditMessagesHandler.invoke$lambda$0(file, project, dialog), "Externalisierte Message bearbeiten", null, (Document)((EditorImpl)editor).getDocument());
        }

        public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
            throw new NotImplementedError("EditMessagesHandler was called unexpectedly.");
        }

        private static final void invoke$lambda$0(PsiFile $file, Project $project, LocalizeLiteralsDialogForJava $dialog) {
            MessagesConglomerate.Companion.findOrGenerateMessagesForClass$default(MessagesConglomerate.Companion, (PsiJavaFile)$file, $project, null, 4, null).replaceExistingExternalization($dialog.getExternalization());
        }
    }
}

