/*
 * Decompiled with CFR 0.152.
 */
package de.set.intellij.messages.foldings;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.impl.FoldingPopupManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import de.set.intellij.messages.foldings.EditMessagesAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.util.Collection;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/set/intellij/messages/foldings/EditMessageValueTooltipManager;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "myAlarm", "Lcom/intellij/util/Alarm;", "mouseReleased", "", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "caretPositionChanged", "Lcom/intellij/openapi/editor/event/CaretEvent;", "Companion", "Messages_Externalisieren"})
public final class EditMessageValueTooltipManager
implements EditorMouseListener,
CaretListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Alarm myAlarm = new Alarm();
    @NotNull
    private static final Key<Boolean> INITIALIZED;
    private static final long TOOLTIP_DELAY_MS = 500L;

    private EditMessageValueTooltipManager(Editor editor) {
        editor.getCaretModel().addCaretListener((CaretListener)this);
        editor.addEditorMouseListener((EditorMouseListener)this);
    }

    public void mouseReleased(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        if (Intrinsics.areEqual((Object)event.getArea(), (Object)EditorMouseEventArea.EDITING_AREA) && EditMessageValueTooltipManager.Companion.shouldShowTooltip(editor2)) {
            event.consume();
            this.myAlarm.cancelAllRequests();
            EditMessageValueTooltipManager.Companion.showTooltip(editor2);
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.myAlarm.cancelAllRequests();
        Editor editor = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        if (EditMessageValueTooltipManager.Companion.shouldShowTooltip(editor2)) {
            this.myAlarm.addRequest(() -> EditMessageValueTooltipManager.caretPositionChanged$lambda$0(editor2), 500L);
        }
    }

    private static final void caretPositionChanged$lambda$0(Editor $editor) {
        EditMessageValueTooltipManager.Companion.showTooltip($editor);
    }

    public /* synthetic */ EditMessageValueTooltipManager(Editor editor, DefaultConstructorMarker $constructor_marker) {
        this(editor);
    }

    static {
        Key key = Key.create((String)"MessageEditTooltipManager");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        INITIALIZED = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/set/intellij/messages/foldings/EditMessageValueTooltipManager$Companion;", "", "<init>", "()V", "INITIALIZED", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "TOOLTIP_DELAY_MS", "", "initializeForDocument", "", "document", "Lcom/intellij/openapi/editor/Document;", "initializeForEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "shouldShowTooltip", "showTooltip", "createActionText", "", "actionId", "href", "Lcom/intellij/ui/LightweightHint;", "component", "Ljavax/swing/JComponent;", "tenacious", "Messages_Externalisieren"})
    public static final class Companion {
        private Companion() {
        }

        public final void initializeForDocument(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            EditorFactory.getInstance().editors(document).forEach(arg_0 -> Companion.initializeForDocument$lambda$1(Companion::initializeForDocument$lambda$0, arg_0));
        }

        private final void initializeForEditor(Editor editor) {
            if (editor.getUserData(INITIALIZED) != null) {
                return;
            }
            editor.putUserData(INITIALIZED, (Object)true);
            new EditMessageValueTooltipManager(editor, null);
        }

        private final boolean shouldShowTooltip(Editor editor) {
            return EditMessagesAction.Companion.isEnabled(editor);
        }

        private final void showTooltip(Editor editor) {
            Object[] objectArray = new String[]{this.createActionText("ExpandRegion", "expand"), this.createActionText("EditMessagesAction", "edit")};
            String string = StringUtil.join((Collection)CollectionsKt.listOf((Object[])objectArray), (String)"&nbsp;&nbsp;&nbsp;&nbsp;");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
            String hintText = string;
            if (((CharSequence)hintText).length() == 0) {
                return;
            }
            JComponent component = HintUtil.createInformationLabel((String)("<html>" + hintText), arg_0 -> Companion.showTooltip$lambda$2(editor, arg_0), null, null);
            Intrinsics.checkNotNull((Object)component);
            this.showTooltip(editor, component, false);
        }

        private final String createActionText(String actionId, String href) {
            AnAction anAction = ActionManager.getInstance().getAction(actionId);
            if (anAction == null) {
                return null;
            }
            AnAction action = anAction;
            String string = action.getTemplateText();
            if (string == null) {
                return null;
            }
            String text = string;
            HtmlChunk.Element element = HtmlChunk.span((String)("color:" + ColorUtil.toHtmlColor((Color)UIUtil.getContextHelpForeground()))).addText(KeymapUtil.getFirstKeyboardShortcutText((AnAction)action));
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"addText(...)");
            HtmlChunk.Element shortcut = element;
            return new HtmlBuilder().appendLink(href, text).append(" ").append((HtmlChunk)shortcut).toString();
        }

        private final LightweightHint showTooltip(Editor editor, JComponent component, boolean tenacious) {
            if (editor.isDisposed()) {
                return null;
            }
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(editor.getCaretModel().getOffset());
            if (foldRegion == null) {
                return null;
            }
            FoldRegion foldRegion2 = foldRegion;
            JComponent jComponent = editor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            JComponent editorComponent = jComponent;
            JRootPane jRootPane = editorComponent.getRootPane();
            if (jRootPane == null) {
                return null;
            }
            JRootPane rootPane = jRootPane;
            Point point = editor.offsetToXY(foldRegion2.getStartOffset(), true, false);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
            Point start = point;
            Point point2 = editor.offsetToXY(foldRegion2.getEndOffset(), false, true);
            Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"offsetToXY(...)");
            Point end = point2;
            Point relativePoint = new Point((start.x + end.x) / 2, start.y);
            Point point3 = SwingUtilities.convertPoint(editorComponent, relativePoint, rootPane.getLayeredPane());
            LightweightHint hint = new LightweightHint(component);
            HintHint hintHint = HintManagerImpl.createHintHint((Editor)editor, (Point)point3, (LightweightHint)hint, (short)1).setShowImmediately(true);
            int flags = 40;
            if (tenacious) {
                hintHint.setExplicitClose(true);
            } else {
                flags |= 2;
            }
            FoldingPopupManager.disableForEditor((Editor)editor);
            hint.addHintListener(arg_0 -> Companion.showTooltip$lambda$3(editor, arg_0));
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, point3, flags, 0, false, hintHint);
            return hint;
        }

        private static final Unit initializeForDocument$lambda$0(Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Companion.initializeForEditor(editor);
            return Unit.INSTANCE;
        }

        private static final void initializeForDocument$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final void showTooltip$lambda$2(Editor $editor, HyperlinkEvent event) {
            AnAction action;
            String actionId;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                return;
            }
            String string = event.getDescription();
            String string2 = Intrinsics.areEqual((Object)string, (Object)"expand") ? "ExpandRegion" : (actionId = Intrinsics.areEqual((Object)string, (Object)"edit") ? "EditMessagesAction" : null);
            if (actionId != null && (action = ActionManager.getInstance().getAction(actionId)) != null) {
                AnActionEvent anActionEvent = AnActionEvent.createEvent((AnAction)action, (DataContext)DataManager.getInstance().getDataContext((Component)$editor.getContentComponent()), null, (String)"EditorPopup", (ActionUiKind)((ActionUiKind)ActionUiKind.POPUP), (InputEvent)event.getInputEvent());
                Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
                AnActionEvent actionEvent = anActionEvent;
                ActionUtil.invokeAction((AnAction)action, (AnActionEvent)actionEvent, null);
            }
        }

        private static final void showTooltip$lambda$3(Editor $editor, EventObject it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            FoldingPopupManager.enableForEditor((Editor)$editor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

