/*
 * Decompiled with CFR 0.152.
 */
package de.set.intellij.messages.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import de.set.intellij.messages.dialogs.LocalizeLiteralsDialogForJava;
import de.set.intellij.messages.domain.Language;
import de.set.intellij.messages.domain.MessagesConglomerate;
import de.set.intellij.messages.util.psiNavigation.MessagesExtractionHelper;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0096\u0002\u00a8\u0006\u0014"}, d2={"Lde/set/intellij/messages/actions/EditMessagesIntentionAction;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "startInWriteAction", "", "getText", "", "getFamilyName", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "psiElement", "Messages_Externalisieren"})
public final class EditMessagesIntentionAction
extends PsiElementBaseIntentionAction
implements IntentionAction {
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        return "Externalisierte Message bearbeiten";
    }

    @NotNull
    public String getFamilyName() {
        return "Message externalisieren";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        if (!(psiElement instanceof PsiReferenceExpression)) return false;
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)psiElement;
        if (psiReferenceExpression == null) return false;
        PsiReferenceExpression expressionToCheck = psiReferenceExpression;
        boolean bl = false;
        String string = expressionToCheck.getQualifiedName();
        if (string != null ? StringsKt.startsWith$default((String)string, (String)"Messages", (boolean)false, (int)2, null) : false) return true;
        String string2 = expressionToCheck.getReferenceName();
        if (string2 == null) return false;
        boolean bl2 = StringsKt.startsWith$default((String)string2, (String)"Messages", (boolean)false, (int)2, null);
        if (!bl2) return false;
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement psiElement) {
        LocalizeLiteralsDialogForJava dialog;
        boolean shouldRefactor;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiElement psiElement2 = PsiTreeUtil.findFirstParent((PsiElement)psiElement, arg_0 -> EditMessagesIntentionAction.invoke$lambda$2(EditMessagesIntentionAction::invoke$lambda$1, arg_0));
        PsiMethodCallExpression psiMethodCallExpression = psiElement2 instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)psiElement2 : null;
        if (psiMethodCallExpression == null) {
            throw new Exception("element is unexpectedly not a MethodCallExpression");
        }
        PsiMethodCallExpression element = psiMethodCallExpression;
        String string = MessagesExtractionHelper.INSTANCE.extractTextFromMessagesCall(element, Language.DE, false);
        if (string == null) {
            throw new Exception("could not extract german text");
        }
        String string2 = MessagesExtractionHelper.INSTANCE.extractTextFromMessagesCall(element, Language.EN, false);
        if (string2 == null) {
            throw new Exception("could not extract english text");
        }
        Map<PsiExpression, String> map = MessagesExtractionHelper.INSTANCE.getParametersFromMessagesCallWithNames(element);
        PsiExpression psiExpression = (PsiExpression)element;
        String string3 = element.getMethodExpression().getReferenceName();
        if (string3 == null) {
            string3 = "";
        }
        if (!(shouldRefactor = (dialog = new LocalizeLiteralsDialogForJava(project, string, string2, map, psiExpression, string3)).showAndGet())) {
            return;
        }
        Editor editor2 = editor;
        CommandProcessor.getInstance().executeCommand(project, () -> EditMessagesIntentionAction.invoke$lambda$3(element, project, dialog), "Externalisierte Message bearbeiten", null, (Document)(editor2 != null ? editor2.getDocument() : null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean invoke$lambda$1(PsiElement it) {
        if (!(it instanceof PsiMethodCallExpression)) return false;
        String string = ((PsiMethodCallExpression)it).getMethodExpression().getQualifiedName();
        if (string == null) return false;
        boolean bl = StringsKt.startsWith$default((String)string, (String)"Messages", (boolean)false, (int)2, null);
        if (!bl) return false;
        return true;
    }

    private static final boolean invoke$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void invoke$lambda$3(PsiMethodCallExpression $element, Project $project, LocalizeLiteralsDialogForJava $dialog) {
        PsiFile psiFile = $element.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
        MessagesConglomerate.Companion.findOrGenerateMessagesForClass$default(MessagesConglomerate.Companion, (PsiJavaFile)psiFile, $project, null, 4, null).replaceExistingExternalization($dialog.getExternalization());
    }
}

