/*
 * Decompiled with CFR 0.152.
 */
package de.set.intellij.messages.util.translation;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import de.set.intellij.messages.util.extensions.PsiLiteralExpressionExtensionsKt;
import de.set.intellij.messages.util.extensions.StringExtensionsKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0002R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lde/set/intellij/messages/util/translation/ParameterExtractionVisitor;", "Lcom/intellij/psi/JavaRecursiveElementVisitor;", "<init>", "()V", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "params", "", "Lcom/intellij/psi/PsiExpression;", "", "externalizedString", "getExternalizedString", "()Ljava/lang/String;", "extractedParams", "getExtractedParams", "()Ljava/util/Map;", "visitLiteralExpression", "", "expression", "Lcom/intellij/psi/PsiLiteralExpression;", "visitReferenceExpression", "Lcom/intellij/psi/PsiReferenceExpression;", "visitMethodCallExpression", "Lcom/intellij/psi/PsiMethodCallExpression;", "visitArrayAccessExpression", "Lcom/intellij/psi/PsiArrayAccessExpression;", "visitNewExpression", "Lcom/intellij/psi/PsiNewExpression;", "visitThisExpression", "Lcom/intellij/psi/PsiThisExpression;", "handleExpression", "Messages_Externalisieren"})
final class ParameterExtractionVisitor
extends JavaRecursiveElementVisitor {
    @NotNull
    private final StringBuilder stringBuilder = new StringBuilder();
    @NotNull
    private final Map<PsiExpression, String> params = new LinkedHashMap();

    @NotNull
    public final String getExternalizedString() {
        String string = this.stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final Map<PsiExpression, String> getExtractedParams() {
        return this.params;
    }

    public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        String value = PsiLiteralExpressionExtensionsKt.getStringFromLiteral(expression);
        if (value != null) {
            this.stringBuilder.append(value);
        }
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.handleExpression((PsiExpression)expression);
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.handleExpression((PsiExpression)expression);
    }

    public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.handleExpression((PsiExpression)expression);
    }

    public void visitNewExpression(@NotNull PsiNewExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.handleExpression((PsiExpression)expression);
    }

    public void visitThisExpression(@NotNull PsiThisExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.handleExpression((PsiExpression)expression);
    }

    private final void handleExpression(PsiExpression expression) {
        String string;
        if (expression == null) {
            return;
        }
        Map<PsiExpression, String> map = this.params;
        if (expression instanceof PsiThisExpression) {
            string = "iThis";
        } else {
            String string2 = expression.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            string = StringExtensionsKt.toLegalJavaName(string2);
        }
        String string3 = string;
        map.put(expression, string3);
        this.stringBuilder.append("%s");
    }
}

