/*
 * Decompiled with CFR 0.152.
 */
package de.set.intellij.messages.foldings;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import de.set.intellij.messages.configuration.MessagesConfigurationState;
import de.set.intellij.messages.domain.Language;
import de.set.intellij.messages.foldings.EditMessagesAction;
import de.set.intellij.messages.util.extensions.StringExtensionsKt;
import de.set.intellij.messages.util.psiNavigation.MessagesExtractionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/set/intellij/messages/foldings/MessageVisualizationFoldingBuilder;", "Lcom/intellij/lang/folding/FoldingBuilderEx;", "<init>", "()V", "config", "Lde/set/intellij/messages/configuration/MessagesConfigurationState;", "buildFoldRegions", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Document;Z)[Lcom/intellij/lang/folding/FoldingDescriptor;", "getPlaceholderText", "", "node", "Lcom/intellij/lang/ASTNode;", "isCollapsedByDefault", "Messages_Externalisieren"})
@SourceDebugExtension(value={"SMAP\nMessageVisualizationFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageVisualizationFoldingBuilder.kt\nde/set/intellij/messages/foldings/MessageVisualizationFoldingBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,45:1\n774#2:46\n865#2,2:47\n1557#2:49\n1628#2,3:50\n37#3,2:53\n*S KotlinDebug\n*F\n+ 1 MessageVisualizationFoldingBuilder.kt\nde/set/intellij/messages/foldings/MessageVisualizationFoldingBuilder\n*L\n27#1:46\n27#1:47,2\n28#1:49\n28#1:50,3\n32#1:53,2\n*E\n"})
public final class MessageVisualizationFoldingBuilder
extends FoldingBuilderEx {
    @NotNull
    private final MessagesConfigurationState config = MessagesConfigurationState.Companion.getINSTANCE();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        PsiMethodCallExpression it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (quick) {
            return new FoldingDescriptor[0];
        }
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)root, PsiMethodCallExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PsiMethodCallExpression)element$iv$iv;
            boolean bl = false;
            String string = it.getMethodExpression().getQualifiedName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)"Messages.", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PsiMethodCallExpression)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            EditMessagesAction.Companion.registerFoldedElement((PsiElement)it, document);
            collection2.add(new FoldingDescriptor((PsiElement)it, it.getTextRange()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FoldingDescriptor[0]);
    }

    @NotNull
    public String getPlaceholderText(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiElement psiElement = node.getPsi();
        PsiMethodCallExpression psiMethodCallExpression = psiElement instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)psiElement : null;
        if (psiMethodCallExpression == null) {
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }
        PsiMethodCallExpression methodCall = psiMethodCallExpression;
        String germanText = MessagesExtractionHelper.extractTextFromMessagesCall$default(MessagesExtractionHelper.INSTANCE, methodCall, Language.DE, false, 4, null);
        String string = germanText;
        if (string == null || (string = StringExtensionsKt.truncate(string, this.config.getMaxCharsToShowFolded())) == null) {
            String string2 = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            return string2;
        }
        String truncatedText = string;
        return this.config.getPrefixEnabled() ? this.config.getPrefix() + truncatedText : truncatedText;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.config.getFoldByDefault();
    }
}

