/*
 * Decompiled with CFR 0.152.
 */
package de.set.intellij.messages.util.translation;

import com.intellij.util.containers.UtilKt;
import de.set.intellij.messages.domain.Language;
import de.set.intellij.messages.util.translation.DeeplApiAccess$Translation$;
import de.set.intellij.messages.util.translation.DeeplApiAccess$Translations$;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002$%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u001e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J$\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000fH\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\f\u0010 \u001a\u00020\u0005*\u00020\u0005H\u0002J\u001e\u0010!\u001a\u0004\u0018\u00010\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/set/intellij/messages/util/translation/DeeplApiAccess;", "", "<init>", "()V", "API_KEY", "", "LOWER_END_OK_HTTP_CODE", "", "UPPER_END_OK_HTTP_CODE", "httpOkCodes", "Lkotlin/ranges/IntRange;", "IGNORE_TAG", "IGNORED_WORDS", "Ljava/util/TreeSet;", "POSY_DE_EN_TRANSLATIONS", "", "translate", "toTranslate", "fromLang", "Lde/set/intellij/messages/domain/Language;", "toLang", "removeIgnoreTags", "text", "applyIgnore", "ignoredWords", "buildWordMatchRegex", "Lkotlin/text/Regex;", "ignoredWord", "applyTranslations", "dictionary", "buildTranslationMatchRegex", "word", "utf8", "formData", "Ljava/net/http/HttpRequest$BodyPublisher;", "data", "Translations", "Translation", "Messages_Externalisieren"})
@SourceDebugExtension(value={"SMAP\nDeeplApiAccess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeeplApiAccess.kt\nde/set/intellij/messages/util/translation/DeeplApiAccess\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,123:1\n222#2:124\n1803#3,3:125\n1563#3:128\n1634#3,3:129\n1803#3,3:132\n126#4:135\n153#4,3:136\n*S KotlinDebug\n*F\n+ 1 DeeplApiAccess.kt\nde/set/intellij/messages/util/translation/DeeplApiAccess\n*L\n72#1:124\n84#1:125,3\n91#1:128\n91#1:129,3\n98#1:132,3\n113#1:135\n113#1:136,3\n*E\n"})
public final class DeeplApiAccess {
    @NotNull
    public static final DeeplApiAccess INSTANCE = new DeeplApiAccess();
    @NotNull
    private static final String API_KEY = "e7403079-2e86-4fd8-9b22-a9ace543bd1a:fx";
    private static final int LOWER_END_OK_HTTP_CODE = 200;
    private static final int UPPER_END_OK_HTTP_CODE = 299;
    @NotNull
    private static final IntRange httpOkCodes = new IntRange(200, 299);
    @NotNull
    private static final String IGNORE_TAG = "ignore";
    @NotNull
    private static final TreeSet<String> IGNORED_WORDS;
    @NotNull
    private static final Map<String, String> POSY_DE_EN_TRANSLATIONS;

    private DeeplApiAccess() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String translate(@NotNull String toTranslate, @NotNull Language fromLang, @NotNull Language toLang) {
        Intrinsics.checkNotNullParameter((Object)toTranslate, (String)"toTranslate");
        Intrinsics.checkNotNullParameter((Object)((Object)fromLang), (String)"fromLang");
        Intrinsics.checkNotNullParameter((Object)((Object)toLang), (String)"toLang");
        String toTranslateWithIgnore = toTranslate;
        if (fromLang == Language.DE && toLang == Language.EN) {
            toTranslateWithIgnore = this.applyTranslations(toTranslateWithIgnore, POSY_DE_EN_TRANSLATIONS);
        } else if (fromLang == Language.EN && toLang == Language.DE) {
            toTranslateWithIgnore = this.applyTranslations(toTranslateWithIgnore, UtilKt.reverse(POSY_DE_EN_TRANSLATIONS));
        }
        toTranslateWithIgnore = this.applyIgnore(toTranslateWithIgnore, IGNORED_WORDS);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"text", (Object)toTranslateWithIgnore), TuplesKt.to((Object)"source_lang", (Object)fromLang.getShortcutAsLowercase()), TuplesKt.to((Object)"target_lang", (Object)toLang.getShortcutAsLowercase()), TuplesKt.to((Object)"split_sentences", (Object)"nonewlines"), TuplesKt.to((Object)"tag_handling", (Object)"xml"), TuplesKt.to((Object)"ignore_tags", (Object)IGNORE_TAG)};
        Map values = MapsKt.mapOf((Pair[])pairArray);
        HttpClient client = HttpClient.newBuilder().build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api-free.deepl.com/v2/translate")).POST(this.formData(values)).header("Content-Type", "application/x-www-form-urlencoded").header("Authorization", "DeepL-Auth-Key e7403079-2e86-4fd8-9b22-a9ace543bd1a:fx").build();
        try {
            void this_$iv;
            HttpResponse<String> httpResponse = client.send(request, HttpResponse.BodyHandlers.ofString());
            Intrinsics.checkNotNullExpressionValue(httpResponse, (String)"send(...)");
            HttpResponse<String> response = httpResponse;
            IntRange intRange = httpOkCodes;
            int n = intRange.getFirst();
            int n2 = intRange.getLast();
            int n3 = response.statusCode();
            if (!(n <= n3 ? n3 <= n2 : false)) {
                throw new RuntimeException("DeepL request failed (HTTP " + response.statusCode() + "):\n " + response.body());
            }
            Json json = (Json)Json.Default;
            String string = response.body();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body(...)");
            String string$iv = string;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            Translations translations = (Translations)this_$iv.decodeFromString((DeserializationStrategy)Translations.Companion.serializer(), string$iv);
            return this.removeIgnoreTags(translations.getTranslations().get(0).getText());
        }
        catch (Exception e) {
            throw new RuntimeException("DeepL translation failed: " + e.getMessage(), e);
        }
    }

    private final String removeIgnoreTags(String text) {
        CharSequence charSequence = text;
        Regex regex = new Regex("<ignore>(.+?)</ignore>");
        String string = "$1";
        return regex.replace(charSequence, string);
    }

    /*
     * WARNING - void declaration
     */
    private final String applyIgnore(String toTranslate, TreeSet<String> ignoredWords) {
        void $this$fold$iv;
        Iterable iterable = ignoredWords;
        String initial$iv = toTranslate;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void word;
            String string = (String)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            Regex regex = INSTANCE.buildWordMatchRegex((String)word);
            CharSequence charSequence = acc;
            Function1 function1 = DeeplApiAccess::applyIgnore$lambda$1$lambda$0;
            accumulator$iv = regex.replace(charSequence, function1);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Regex buildWordMatchRegex(String ignoredWord) {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{"*"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)ignoredWord, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void part;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Regex.Companion.escape((String)part));
        }
        List parts = (List)destination$iv$iv;
        String regexStr = CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)"[\u00f6\u00d6\u00e4\u00c4\u00fc\u00dc\u00dfa-zA-Z]+", null, null, (int)0, null, null, (int)62, null);
        return new Regex("(?<!<ignore>)(?<![\u00f6\u00d6\u00e4\u00c4\u00fc\u00dc\u00dfa-zA-Z])" + regexStr + "(?![\u00f6\u00d6\u00e4\u00c4\u00fc\u00dc\u00dfa-zA-Z])(?<!</ignore>)");
    }

    /*
     * WARNING - void declaration
     */
    private final String applyTranslations(String toTranslate, Map<String, String> dictionary) {
        void $this$fold$iv;
        Iterable iterable = dictionary.entrySet();
        String initial$iv = toTranslate;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            String word = (String)entry.getKey();
            String translation = (String)entry.getValue();
            Regex regex = INSTANCE.buildTranslationMatchRegex(word);
            CharSequence charSequence = acc;
            Function1 function1 = arg_0 -> DeeplApiAccess.applyTranslations$lambda$4$lambda$3(translation, arg_0);
            accumulator$iv = regex.replace(charSequence, function1);
        }
        return accumulator$iv;
    }

    private final Regex buildTranslationMatchRegex(String word) {
        String escapedWord = Regex.Companion.escape(word);
        return new Regex("(?<!<ignore>)(?<![\u00f6\u00d6\u00e4\u00c4\u00fc\u00dc\u00dfa-zA-Z])" + escapedWord + "(?![\u00f6\u00d6\u00e4\u00c4\u00fc\u00dc\u00dfa-zA-Z])(?<!</ignore>)");
    }

    private final String utf8(String $this$utf8) {
        String string = URLEncoder.encode($this$utf8, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final HttpRequest.BodyPublisher formData(Map<String, String> data) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = data;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            collection.add(INSTANCE.utf8(k) + "=" + INSTANCE.utf8(v));
        }
        return HttpRequest.BodyPublishers.ofString(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null));
    }

    private static final CharSequence applyIgnore$lambda$1$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "<ignore>" + it.getValue() + "</ignore>";
    }

    private static final CharSequence applyTranslations$lambda$4$lambda$3(String $translation, MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "<ignore>" + $translation + "</ignore>";
    }

    static {
        Object[] objectArray = new String[]{"POSY-*"};
        IGNORED_WORDS = SetsKt.sortedSetOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"POSY-Lauf", (Object)"POSY run"), TuplesKt.to((Object)"POSY-L\u00e4ufe", (Object)"POSY runs"), TuplesKt.to((Object)"Ist-Liste", (Object)"response file"), TuplesKt.to((Object)"Ist-Listen", (Object)"response files"), TuplesKt.to((Object)"Soll-Liste", (Object)"request file"), TuplesKt.to((Object)"Soll-Listen", (Object)"request files")};
        POSY_DE_EN_TRANSLATIONS = MapsKt.mapOf((Pair[])objectArray);
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B/\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\r\u00a8\u0006#"}, d2={"Lde/set/intellij/messages/util/translation/DeeplApiAccess$Translation;", "", "text", "", "detectedSourceLanguage", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getText", "()Ljava/lang/String;", "getDetectedSourceLanguage$annotations", "()V", "getDetectedSourceLanguage", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$Messages_Externalisieren", "$serializer", "Companion", "Messages_Externalisieren"})
    public static final class Translation {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String text;
        @NotNull
        private final String detectedSourceLanguage;

        public Translation(@NotNull String text, @NotNull String detectedSourceLanguage) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)detectedSourceLanguage, (String)"detectedSourceLanguage");
            this.text = text;
            this.detectedSourceLanguage = detectedSourceLanguage;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getDetectedSourceLanguage() {
            return this.detectedSourceLanguage;
        }

        @SerialName(value="detected_source_language")
        public static /* synthetic */ void getDetectedSourceLanguage$annotations() {
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final String component2() {
            return this.detectedSourceLanguage;
        }

        @NotNull
        public final Translation copy(@NotNull String text, @NotNull String detectedSourceLanguage) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)detectedSourceLanguage, (String)"detectedSourceLanguage");
            return new Translation(text, detectedSourceLanguage);
        }

        public static /* synthetic */ Translation copy$default(Translation translation, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = translation.text;
            }
            if ((n & 2) != 0) {
                string2 = translation.detectedSourceLanguage;
            }
            return translation.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Translation(text=" + this.text + ", detectedSourceLanguage=" + this.detectedSourceLanguage + ")";
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = result * 31 + this.detectedSourceLanguage.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Translation)) {
                return false;
            }
            Translation translation = (Translation)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)translation.text)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.detectedSourceLanguage, (Object)translation.detectedSourceLanguage);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$Messages_Externalisieren(Translation self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.text);
            output.encodeStringElement(serialDesc, 1, self.detectedSourceLanguage);
        }

        public /* synthetic */ Translation(int seen0, String text, String detectedSourceLanguage, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)Translation$$serializer.INSTANCE.getDescriptor());
            }
            this.text = text;
            this.detectedSourceLanguage = detectedSourceLanguage;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lde/set/intellij/messages/util/translation/DeeplApiAccess$Translation$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lde/set/intellij/messages/util/translation/DeeplApiAccess$Translation;", "Messages_Externalisieren"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Translation> serializer() {
                return (KSerializer)Translation$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\b\u001dR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lde/set/intellij/messages/util/translation/DeeplApiAccess$Translations;", "", "translations", "", "Lde/set/intellij/messages/util/translation/DeeplApiAccess$Translation;", "<init>", "(Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getTranslations", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$Messages_Externalisieren", "$serializer", "Companion", "Messages_Externalisieren"})
    public static final class Translations {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<Translation> translations;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public Translations(@NotNull List<Translation> translations) {
            Intrinsics.checkNotNullParameter(translations, (String)"translations");
            this.translations = translations;
        }

        @NotNull
        public final List<Translation> getTranslations() {
            return this.translations;
        }

        @NotNull
        public final List<Translation> component1() {
            return this.translations;
        }

        @NotNull
        public final Translations copy(@NotNull List<Translation> translations) {
            Intrinsics.checkNotNullParameter(translations, (String)"translations");
            return new Translations(translations);
        }

        public static /* synthetic */ Translations copy$default(Translations translations, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = translations.translations;
            }
            return translations.copy(list);
        }

        @NotNull
        public String toString() {
            return "Translations(translations=" + this.translations + ")";
        }

        public int hashCode() {
            return ((Object)this.translations).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Translations)) {
                return false;
            }
            Translations translations = (Translations)other;
            return Intrinsics.areEqual(this.translations, translations.translations);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$Messages_Externalisieren(Translations self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.translations);
        }

        public /* synthetic */ Translations(int seen0, List translations, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Translations$$serializer.INSTANCE.getDescriptor());
            }
            this.translations = translations;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)Translation$$serializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lde/set/intellij/messages/util/translation/DeeplApiAccess$Translations$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lde/set/intellij/messages/util/translation/DeeplApiAccess$Translations;", "Messages_Externalisieren"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Translations> serializer() {
                return (KSerializer)Translations$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

