/*
 * Decompiled with CFR 0.152.
 */
package de.set.intellij.messages.util.extensions;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import de.set.intellij.messages.domain.Language;
import de.set.intellij.messages.domain.xmlElement.XmlElementToBeTranslated;
import de.set.intellij.messages.domain.xmlElement.XmlElementToBeTranslatedDocumentation;
import de.set.intellij.messages.domain.xmlElement.XmlElementToBeTranslatedKt;
import de.set.intellij.messages.domain.xmlElement.XmlElementToBeTranslatedText;
import de.set.intellij.messages.util.exception.MessagesExternalizerException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0002\u00a8\u0006\u000b"}, d2={"getAllSiblingsWithSameTag", "", "Lcom/intellij/psi/xml/XmlTag;", "isTranslatable", "", "allElementsHaveContent", "tagsToCheck", "translate", "", "createXmlElementToBeTranslated", "Lde/set/intellij/messages/domain/xmlElement/XmlElementToBeTranslated;", "Messages_Externalisieren"})
@SourceDebugExtension(value={"SMAP\nXmlTagExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlTagExtensions.kt\nde/set/intellij/messages/util/extensions/XmlTagExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1740#2,3:68\n*S KotlinDebug\n*F\n+ 1 XmlTagExtensions.kt\nde/set/intellij/messages/util/extensions/XmlTagExtensionsKt\n*L\n45#1:68,3\n*E\n"})
public final class XmlTagExtensionsKt {
    @NotNull
    public static final Set<XmlTag> getAllSiblingsWithSameTag(@NotNull XmlTag $this$getAllSiblingsWithSameTag) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllSiblingsWithSameTag, (String)"<this>");
        Set previousOnes = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)PsiTreeUtilKt.siblings$default((PsiElement)((PsiElement)$this$getAllSiblingsWithSameTag), (boolean)false, (boolean)false, (int)2, null), arg_0 -> XmlTagExtensionsKt.getAllSiblingsWithSameTag$lambda$0($this$getAllSiblingsWithSameTag, arg_0)), XmlTagExtensionsKt::getAllSiblingsWithSameTag$lambda$1));
        Set nextOnes = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)PsiTreeUtilKt.siblings$default((PsiElement)((PsiElement)$this$getAllSiblingsWithSameTag), (boolean)true, (boolean)false, (int)2, null), arg_0 -> XmlTagExtensionsKt.getAllSiblingsWithSameTag$lambda$2($this$getAllSiblingsWithSameTag, arg_0)), XmlTagExtensionsKt::getAllSiblingsWithSameTag$lambda$3));
        return CollectionsKt.union((Iterable)previousOnes, (Iterable)nextOnes);
    }

    public static final boolean isTranslatable(@NotNull XmlTag $this$isTranslatable) {
        Intrinsics.checkNotNullParameter((Object)$this$isTranslatable, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isTranslatable.getLocalName(), (Object)"text") && !Intrinsics.areEqual((Object)$this$isTranslatable.getLocalName(), (Object)"documentation")) {
            return false;
        }
        XmlTagChild[] xmlTagChildArray = $this$isTranslatable.getValue().getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTagChildArray, (String)"getChildren(...)");
        if (((Object[])xmlTagChildArray).length == 0) {
            return false;
        }
        Set<XmlTag> allSiblingsWithSameTag = XmlTagExtensionsKt.getAllSiblingsWithSameTag($this$isTranslatable);
        if (allSiblingsWithSameTag.size() >= Language.Companion.getAmountOfLanguages() && XmlTagExtensionsKt.allElementsHaveContent(allSiblingsWithSameTag)) {
            return false;
        }
        return XmlElementToBeTranslatedKt.getLanguageAttribute($this$isTranslatable) != null;
    }

    private static final boolean allElementsHaveContent(Set<? extends XmlTag> tagsToCheck) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = tagsToCheck;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    XmlTag it = (XmlTag)element$iv;
                    boolean bl2 = false;
                    XmlTagChild[] xmlTagChildArray = it.getValue().getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)xmlTagChildArray, (String)"getChildren(...)");
                    if (!(((Object[])xmlTagChildArray).length == 0)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final void translate(@NotNull XmlTag $this$translate) {
        Intrinsics.checkNotNullParameter((Object)$this$translate, (String)"<this>");
        XmlElementToBeTranslated xmlElement = XmlTagExtensionsKt.createXmlElementToBeTranslated($this$translate);
        List translatedXmlTagsToBeAdded = (List)ReadAction.compute(() -> XmlTagExtensionsKt.translate$lambda$5(xmlElement));
        WriteCommandAction.runWriteCommandAction((Project)$this$translate.getProject(), () -> XmlTagExtensionsKt.translate$lambda$6(xmlElement, translatedXmlTagsToBeAdded));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final XmlElementToBeTranslated createXmlElementToBeTranslated(@NotNull XmlTag $this$createXmlElementToBeTranslated) {
        XmlElementToBeTranslated xmlElementToBeTranslated;
        Intrinsics.checkNotNullParameter((Object)$this$createXmlElementToBeTranslated, (String)"<this>");
        String string = $this$createXmlElementToBeTranslated.getLocalName();
        switch (string.hashCode()) {
            case 1587405498: {
                if (string.equals("documentation")) break;
                throw new MessagesExternalizerException("unknown tag type: " + $this$createXmlElementToBeTranslated.getLocalName());
            }
            case 3556653: {
                if (!string.equals("text")) throw new MessagesExternalizerException("unknown tag type: " + $this$createXmlElementToBeTranslated.getLocalName());
                xmlElementToBeTranslated = XmlElementToBeTranslatedText.Companion.create($this$createXmlElementToBeTranslated);
                return xmlElementToBeTranslated;
            }
        }
        xmlElementToBeTranslated = XmlElementToBeTranslatedDocumentation.Companion.create($this$createXmlElementToBeTranslated);
        return xmlElementToBeTranslated;
        throw new MessagesExternalizerException("unknown tag type: " + $this$createXmlElementToBeTranslated.getLocalName());
    }

    private static final boolean getAllSiblingsWithSameTag$lambda$0(XmlTag $this_getAllSiblingsWithSameTag, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof XmlTag && Intrinsics.areEqual((Object)((XmlTag)it).getName(), (Object)$this_getAllSiblingsWithSameTag.getName());
    }

    private static final XmlTag getAllSiblingsWithSameTag$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (XmlTag)it;
    }

    private static final boolean getAllSiblingsWithSameTag$lambda$2(XmlTag $this_getAllSiblingsWithSameTag, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof XmlTag && Intrinsics.areEqual((Object)((XmlTag)it).getName(), (Object)$this_getAllSiblingsWithSameTag.getName());
    }

    private static final XmlTag getAllSiblingsWithSameTag$lambda$3(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (XmlTag)it;
    }

    private static final List translate$lambda$5(XmlElementToBeTranslated $xmlElement) {
        return $xmlElement.createTranslatedXmlElementsInReadAction();
    }

    private static final void translate$lambda$6(XmlElementToBeTranslated $xmlElement, List $translatedXmlTagsToBeAdded) {
        Intrinsics.checkNotNull((Object)$translatedXmlTagsToBeAdded);
        $xmlElement.appendTranslatedXmlTagsInWriteAction($translatedXmlTagsToBeAdded);
    }
}

