/*
 * Decompiled with CFR 0.152.
 */
package de.set.intellij.messages.domain;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiExpression;
import de.set.intellij.messages.domain.StringWithOrWithoutParameters;
import de.set.intellij.messages.domain.StringWithParameters;
import de.set.intellij.messages.domain.exception.InvalidNumberOfParametersException;
import de.set.intellij.messages.util.extensions.StringExtensionsKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0003J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J)\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u001d"}, d2={"Lde/set/intellij/messages/domain/StringWithParameters;", "Lde/set/intellij/messages/domain/StringWithOrWithoutParameters;", "content", "", "parameters", "", "Lcom/intellij/psi/PsiExpression;", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "getContent", "()Ljava/lang/String;", "setContent", "(Ljava/lang/String;)V", "getParameters", "()Ljava/util/Map;", "resolvedRepresentation", "getResolvedRepresentation", "getParameterStringRepresentation", "toString", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "Companion", "Messages_Externalisieren"})
@SourceDebugExtension(value={"SMAP\nStringWithParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringWithParameters.kt\nde/set/intellij/messages/domain/StringWithParameters\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,65:1\n37#2:66\n36#2,3:67\n*S KotlinDebug\n*F\n+ 1 StringWithParameters.kt\nde/set/intellij/messages/domain/StringWithParameters\n*L\n62#1:66\n62#1:67,3\n*E\n"})
public final class StringWithParameters
extends StringWithOrWithoutParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String content;
    @NotNull
    private final Map<PsiExpression, String> parameters;
    @NotNull
    private static final Pattern PATTERN;
    @NotNull
    private static final Logger logger;

    public StringWithParameters(@NotNull String content, @NotNull Map<PsiExpression, String> parameters) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this.content = content;
        this.parameters = parameters;
        Matcher matcher = PATTERN.matcher(this.content);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        long resultCount = matcher2.results().count();
        if ((long)this.parameters.size() != resultCount) {
            logger.warn((Throwable)new InvalidNumberOfParametersException(resultCount, this.parameters.size(), this.content));
        }
    }

    public /* synthetic */ StringWithParameters(String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            map = new LinkedHashMap();
        }
        this(string, map);
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    public final void setContent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.content = string;
    }

    @NotNull
    public final Map<PsiExpression, String> getParameters() {
        return this.parameters;
    }

    @NotNull
    public final String getResolvedRepresentation() {
        if (this.parameters.isEmpty()) {
            return "\"" + this.content + "\"";
        }
        Collection<String> collection = this.parameters.values();
        String string = "format(\"" + this.content + "\", ";
        return CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", (CharSequence)string, (CharSequence)")", (int)0, null, StringWithParameters::_get_resolvedRepresentation_$lambda$0, (int)24, null);
    }

    @NotNull
    public final String getParameterStringRepresentation() {
        return CollectionsKt.joinToString$default((Iterable)this.parameters.keySet(), (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)((Function1)getParameterStringRepresentation.1.INSTANCE), (int)24, null);
    }

    @NotNull
    public String toString() {
        String string = this.content;
        Collection $this$toTypedArray$iv = this.parameters.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiExpression[] psiExpressionArray = thisCollection$iv.toArray(new PsiExpression[0]);
        psiExpressionArray = Arrays.copyOf(psiExpressionArray, psiExpressionArray.length);
        String string2 = String.format(string, Arrays.copyOf(psiExpressionArray, psiExpressionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public final String component1() {
        return this.content;
    }

    @NotNull
    public final Map<PsiExpression, String> component2() {
        return this.parameters;
    }

    @NotNull
    public final StringWithParameters copy(@NotNull String content, @NotNull Map<PsiExpression, String> parameters) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        return new StringWithParameters(content, parameters);
    }

    public static /* synthetic */ StringWithParameters copy$default(StringWithParameters stringWithParameters, String string, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = stringWithParameters.content;
        }
        if ((n & 2) != 0) {
            map = stringWithParameters.parameters;
        }
        return stringWithParameters.copy(string, map);
    }

    public int hashCode() {
        int result = this.content.hashCode();
        result = result * 31 + ((Object)this.parameters).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringWithParameters)) {
            return false;
        }
        StringWithParameters stringWithParameters = (StringWithParameters)other;
        if (!Intrinsics.areEqual((Object)this.content, (Object)stringWithParameters.content)) {
            return false;
        }
        return Intrinsics.areEqual(this.parameters, stringWithParameters.parameters);
    }

    private static final CharSequence _get_resolvedRepresentation_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringExtensionsKt.toLegalJavaName(it);
    }

    public StringWithParameters() {
        this(null, null, 3, null);
    }

    static {
        Pattern pattern = Pattern.compile("%");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        PATTERN = pattern;
        Logger logger = Logger.getInstance(StringWithParameters.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        StringWithParameters.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lde/set/intellij/messages/domain/StringWithParameters$Companion;", "", "<init>", "()V", "PATTERN", "Ljava/util/regex/Pattern;", "getPATTERN", "()Ljava/util/regex/Pattern;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "Messages_Externalisieren"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getPATTERN() {
            return PATTERN;
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

