/*
 * Decompiled with CFR 0.152.
 */
package de.set.intellij.messages.domain;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import de.set.intellij.messages.domain.ExternalizationForJava;
import de.set.intellij.messages.domain.Language;
import de.set.intellij.messages.domain.MessagesConglomerate;
import de.set.intellij.messages.domain.StringWithParameters;
import de.set.intellij.messages.domain.exception.WrongClassException;
import de.set.intellij.messages.util.extensions.PsiExpressionExtensionKt;
import de.set.intellij.messages.util.psiNavigation.MessagesExtractionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\u0018\u0000 72\u00020\u0001:\u00017B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J \u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J:\u0010$\u001a\u00020!2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020!0&2\b\b\u0002\u0010(\u001a\u00020\u00162\b\b\u0002\u0010)\u001a\u00020\u00162\b\b\u0002\u0010*\u001a\u00020\u0016H\u0002J\u0014\u0010+\u001a\u00060,j\u0002`-2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0018\u0010/\u001a\u00020'2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u00100\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\u00101\u001a\u0004\u0018\u00010\u001aH\u0002J\"\u00102\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\u00101\u001a\u0004\u0018\u00010\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00103\u001a\u000204*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u00068\u00b2\u0006\n\u00109\u001a\u00020:X\u008a\u0084\u0002"}, d2={"Lde/set/intellij/messages/domain/MessagesConglomerate;", "", "project", "Lcom/intellij/openapi/project/Project;", "abstractMessagesClass", "Lcom/intellij/psi/PsiJavaFile;", "concreteMessagesClasses", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiJavaFile;Ljava/util/Set;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "psiElementFactory", "Lcom/intellij/psi/PsiElementFactory;", "addExternalization", "", "externalization", "Lde/set/intellij/messages/domain/ExternalizationForJava;", "replaceExistingExternalization", "validateCompleteness", "createOperationsForAbstractClassAndReplaceLiteralWithReference", "replacePrevious", "", "addExternalizationsToConcreteMessageClasses", "addExternalizationToConcreteMessageClass", "classToAddTo", "Lcom/intellij/psi/PsiClass;", "newMethod", "Lcom/intellij/psi/PsiMethod;", "replaceExternalizationOfConcreteMessageClass", "methodToReplace", "createNewMethodForConcreteMessageClass", "operationName", "", "translation", "Lde/set/intellij/messages/domain/StringWithParameters;", "createParameterList", "parameters", "", "Lcom/intellij/psi/PsiExpression;", "withFinal", "withType", "forCall", "createMissingTranslationError", "Ljava/lang/Error;", "Lkotlin/Error;", "concreteLanguageClass", "createMethodCall", "createAbstractMethod", "aClass", "createStaticMethod", "languageFromExternalizationClass", "Lde/set/intellij/messages/domain/Language;", "getLanguageFromExternalizationClass", "(Lcom/intellij/psi/PsiJavaFile;)Lde/set/intellij/messages/domain/Language;", "Companion", "Messages_Externalisieren", "maybeLazyException", "Lde/set/intellij/messages/domain/exception/WrongClassException;"})
@SourceDebugExtension(value={"SMAP\nMessagesConglomerate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessagesConglomerate.kt\nde/set/intellij/messages/domain/MessagesConglomerate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,433:1\n1869#2,2:434\n1869#2,2:436\n*S KotlinDebug\n*F\n+ 1 MessagesConglomerate.kt\nde/set/intellij/messages/domain/MessagesConglomerate\n*L\n66#1:434,2\n153#1:436,2\n*E\n"})
public final class MessagesConglomerate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PsiJavaFile abstractMessagesClass;
    @NotNull
    private final Set<PsiJavaFile> concreteMessagesClasses;
    @NotNull
    private final PsiElementFactory psiElementFactory;
    @NotNull
    private static final Pattern shortcutPattern;

    public MessagesConglomerate(@NotNull Project project, @NotNull PsiJavaFile abstractMessagesClass, @NotNull Set<? extends PsiJavaFile> concreteMessagesClasses) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)abstractMessagesClass, (String)"abstractMessagesClass");
        Intrinsics.checkNotNullParameter(concreteMessagesClasses, (String)"concreteMessagesClasses");
        this.project = project;
        this.abstractMessagesClass = abstractMessagesClass;
        this.concreteMessagesClasses = concreteMessagesClasses;
        PsiElementFactory psiElementFactory = PsiElementFactory.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getInstance(...)");
        this.psiElementFactory = psiElementFactory;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void addExternalization(@NotNull ExternalizationForJava externalization) {
        Intrinsics.checkNotNullParameter((Object)externalization, (String)"externalization");
        this.validateCompleteness(externalization);
        this.addExternalizationsToConcreteMessageClasses(externalization, false);
        this.createOperationsForAbstractClassAndReplaceLiteralWithReference(externalization, false);
    }

    public final void replaceExistingExternalization(@NotNull ExternalizationForJava externalization) {
        Intrinsics.checkNotNullParameter((Object)externalization, (String)"externalization");
        PsiExpression methodCall = externalization.getExpressionToBeExternalized();
        if (!(methodCall instanceof PsiMethodCallExpression)) {
            throw new Exception("Expected expressionToBeExternalized to be a method call");
        }
        this.validateCompleteness(externalization);
        this.addExternalizationsToConcreteMessageClasses(externalization, true);
        this.createOperationsForAbstractClassAndReplaceLiteralWithReference(externalization, true);
    }

    private final void validateCompleteness(ExternalizationForJava externalization) {
        Iterable $this$forEach$iv = this.concreteMessagesClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiJavaFile concreteMessageClass = (PsiJavaFile)element$iv;
            boolean bl = false;
            if (externalization.getTranslations().get((Object)this.getLanguageFromExternalizationClass(concreteMessageClass)) != null) continue;
            throw this.createMissingTranslationError(concreteMessageClass);
        }
    }

    private final void createOperationsForAbstractClassAndReplaceLiteralWithReference(ExternalizationForJava externalization, boolean replacePrevious) {
        this.abstractMessagesClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(this, externalization, replacePrevious){
            final /* synthetic */ MessagesConglomerate this$0;
            final /* synthetic */ ExternalizationForJava $externalization;
            final /* synthetic */ boolean $replacePrevious;
            {
                this.this$0 = $receiver;
                this.$externalization = $externalization;
                this.$replacePrevious = $replacePrevious;
            }

            public void visitClass(PsiClass aClass) {
                Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
                PsiMethod staticMethod = MessagesConglomerate.access$createStaticMethod(this.this$0, MessagesConglomerate.access$getPsiElementFactory$p(this.this$0), this.$externalization, aClass);
                PsiMethod abstractMethod = MessagesConglomerate.access$createAbstractMethod(this.this$0, MessagesConglomerate.access$getPsiElementFactory$p(this.this$0), this.$externalization, aClass);
                PsiExpression referenceToExternalizedMethod = MessagesConglomerate.access$createMethodCall(this.this$0, MessagesConglomerate.access$getPsiElementFactory$p(this.this$0), this.$externalization);
                if (this.$replacePrevious) {
                    this.replaceOperationsOfClassAndRenewMethodCall(staticMethod, abstractMethod, referenceToExternalizedMethod);
                } else {
                    this.addOperationsToClassAndReplaceLiteralWithReference(aClass, staticMethod, abstractMethod, referenceToExternalizedMethod);
                }
            }

            private final void replaceOperationsOfClassAndRenewMethodCall(PsiMethod staticMethod, PsiMethod abstractMethod, PsiExpression referenceToExternalizedMethod) {
                PsiMethod psiMethod;
                Object[] objectArray;
                if (!(this.$externalization.getExpressionToBeExternalized() instanceof PsiMethodCallExpression)) {
                    throw new Exception("Expected expressionToBeExternalized to be a method call");
                }
                PsiMethod psiMethod2 = ((PsiMethodCallExpression)this.$externalization.getExpressionToBeExternalized()).resolveMethod();
                if (psiMethod2 == null) {
                    throw new Exception("PsiMethod could not be resolved");
                }
                PsiMethod previousStaticMethod = psiMethod2;
                PsiClass psiClass = previousStaticMethod.getContainingClass();
                if (psiClass == null || (objectArray = psiClass.findMethodsByName(previousStaticMethod.getName() + "A", false)) == null || (psiMethod = (PsiMethod)ArraysKt.firstOrNull((Object[])objectArray)) == null) {
                    throw new Exception("Abstract PsiMethod could not be found");
                }
                PsiMethod previousAbstractMethod = psiMethod;
                WriteCommandAction.runWriteCommandAction((Project)this.this$0.getProject(), () -> createOperationsForAbstractClassAndReplaceLiteralWithReference.1.replaceOperationsOfClassAndRenewMethodCall$lambda$0(previousStaticMethod, staticMethod, previousAbstractMethod, abstractMethod, this.$externalization, referenceToExternalizedMethod));
            }

            private final void addOperationsToClassAndReplaceLiteralWithReference(PsiClass aClass, PsiMethod staticMethod, PsiMethod abstractMethod, PsiExpression referenceToExternalizedMethod) {
                WriteCommandAction.runWriteCommandAction((Project)this.this$0.getProject(), () -> createOperationsForAbstractClassAndReplaceLiteralWithReference.1.addOperationsToClassAndReplaceLiteralWithReference$lambda$1(aClass, staticMethod, abstractMethod, this.$externalization, referenceToExternalizedMethod));
            }

            private static final void replaceOperationsOfClassAndRenewMethodCall$lambda$0(PsiMethod $previousStaticMethod, PsiMethod $staticMethod, PsiMethod $previousAbstractMethod, PsiMethod $abstractMethod, ExternalizationForJava $externalization, PsiExpression $referenceToExternalizedMethod) {
                $previousStaticMethod.replace((PsiElement)$staticMethod);
                $previousAbstractMethod.replace((PsiElement)$abstractMethod);
                $externalization.getExpressionToBeExternalized().replace((PsiElement)$referenceToExternalizedMethod);
            }

            private static final void addOperationsToClassAndReplaceLiteralWithReference$lambda$1(PsiClass $aClass, PsiMethod $staticMethod, PsiMethod $abstractMethod, ExternalizationForJava $externalization, PsiExpression $referenceToExternalizedMethod) {
                PsiElement psiElement = $aClass.addBefore((PsiElement)$staticMethod, $aClass.getLastChild());
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"addBefore(...)");
                PsiElement addedStatic = psiElement;
                $aClass.addAfter((PsiElement)$abstractMethod, addedStatic);
                $externalization.getExpressionToBeExternalized().replace((PsiElement)$referenceToExternalizedMethod);
            }
        });
    }

    private final void addExternalizationsToConcreteMessageClasses(ExternalizationForJava externalization, boolean replacePrevious) {
        Iterable $this$forEach$iv = this.concreteMessagesClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiJavaFile concreteMessageClass = (PsiJavaFile)element$iv;
            boolean bl = false;
            concreteMessageClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(this, concreteMessageClass, externalization, replacePrevious){
                final /* synthetic */ MessagesConglomerate this$0;
                final /* synthetic */ PsiJavaFile $concreteMessageClass;
                final /* synthetic */ ExternalizationForJava $externalization;
                final /* synthetic */ boolean $replacePrevious;
                {
                    this.this$0 = $receiver;
                    this.$concreteMessageClass = $concreteMessageClass;
                    this.$externalization = $externalization;
                    this.$replacePrevious = $replacePrevious;
                }

                public void visitClass(PsiClass aClass) {
                    Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
                    Language currentLanguage = MessagesConglomerate.access$getLanguageFromExternalizationClass(this.this$0, this.$concreteMessageClass);
                    StringWithParameters stringWithParameters = this.$externalization.getTranslations().get((Object)((Object)currentLanguage));
                    if (stringWithParameters == null) {
                        throw MessagesConglomerate.access$createMissingTranslationError(this.this$0, this.$concreteMessageClass);
                    }
                    StringWithParameters translation = stringWithParameters;
                    PsiMethod newMethod = MessagesConglomerate.access$createNewMethodForConcreteMessageClass(this.this$0, this.$externalization.getName(), translation, aClass);
                    if (this.$replacePrevious) {
                        MessagesConglomerate.access$replaceExternalizationOfConcreteMessageClass(this.this$0, newMethod, this.retrieveMethodToReplace(currentLanguage));
                    } else {
                        MessagesConglomerate.access$addExternalizationToConcreteMessageClass(this.this$0, aClass, newMethod);
                    }
                }

                private final PsiMethod retrieveMethodToReplace(Language currentLanguage) {
                    if (!(this.$externalization.getExpressionToBeExternalized() instanceof PsiMethodCallExpression)) {
                        throw new Exception("Expected expressionToBeExternalized to be a method call");
                    }
                    PsiMethod psiMethod = MessagesExtractionHelper.INSTANCE.getConcreteMethodCallForLanguage((PsiMethodCallExpression)this.$externalization.getExpressionToBeExternalized(), currentLanguage);
                    if (psiMethod == null) {
                        throw new Exception("PsiMethod for language " + currentLanguage + " could not be found");
                    }
                    return psiMethod;
                }
            });
        }
    }

    private final void addExternalizationToConcreteMessageClass(PsiClass classToAddTo, PsiMethod newMethod) {
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> MessagesConglomerate.addExternalizationToConcreteMessageClass$lambda$2(classToAddTo, newMethod));
    }

    private final void replaceExternalizationOfConcreteMessageClass(PsiMethod newMethod, PsiMethod methodToReplace) {
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> MessagesConglomerate.replaceExternalizationOfConcreteMessageClass$lambda$3(methodToReplace, newMethod));
    }

    private final PsiMethod createNewMethodForConcreteMessageClass(String operationName, StringWithParameters translation, PsiClass classToAddTo) {
        PsiMethod psiMethod = this.psiElementFactory.createMethodFromText(StringsKt.trimIndent((String)("\n            @Override\n            protected String " + operationName + "A(" + MessagesConglomerate.createParameterList$default(this, translation.getParameters(), true, true, false, 8, null) + ") {\n                return " + translation.getResolvedRepresentation() + ";\n            }\n        ")), (PsiElement)classToAddTo);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"createMethodFromText(...)");
        return psiMethod;
    }

    private final String createParameterList(Map<PsiExpression, String> parameters, boolean withFinal, boolean withType, boolean forCall) {
        return CollectionsKt.joinToString$default((Iterable)parameters.entrySet(), (CharSequence)", ", null, null, (int)0, null, arg_0 -> MessagesConglomerate.createParameterList$lambda$4(withFinal, withType, forCall, arg_0), (int)30, null);
    }

    static /* synthetic */ String createParameterList$default(MessagesConglomerate messagesConglomerate, Map map, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return messagesConglomerate.createParameterList(map, bl, bl2, bl3);
    }

    private final Error createMissingTranslationError(PsiJavaFile concreteLanguageClass) {
        return new Error("Es fehlt eine \u00dcbersetzung in der Sprache " + this.getLanguageFromExternalizationClass(concreteLanguageClass) + " f\u00fcr die Datei " + concreteLanguageClass.getName() + ".");
    }

    private final PsiExpression createMethodCall(PsiElementFactory psiElementFactory, ExternalizationForJava externalization) {
        PsiExpression psiExpression = psiElementFactory.createExpressionFromText(StringsKt.trimIndent((String)("\n                            Messages." + externalization.getName() + "(" + MessagesConglomerate.createParameterList$default(this, externalization.getParameters(), false, false, true, 6, null) + ")\n                        ")), (PsiElement)externalization.getExpressionToBeExternalized());
        Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"createExpressionFromText(...)");
        return psiExpression;
    }

    private final PsiMethod createAbstractMethod(PsiElementFactory psiElementFactory, ExternalizationForJava externalization, PsiClass aClass) {
        PsiMethod psiMethod = psiElementFactory.createMethodFromText("protected abstract String " + externalization.getName() + "A(" + MessagesConglomerate.createParameterList$default(this, externalization.getParameters(), true, true, false, 8, null) + ");", (PsiElement)aClass);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"createMethodFromText(...)");
        return psiMethod;
    }

    private final PsiMethod createStaticMethod(PsiElementFactory psiElementFactory, ExternalizationForJava externalization, PsiClass aClass) {
        PsiMethod psiMethod = psiElementFactory.createMethodFromText(StringsKt.trimIndent((String)("\n                            static String " + externalization.getName() + "(" + MessagesConglomerate.createParameterList$default(this, externalization.getParameters(), true, true, false, 8, null) + ") {\n                                return MANAGER.getInstance()." + externalization.getName() + "A(" + MessagesConglomerate.createParameterList$default(this, externalization.getParameters(), false, false, false, 14, null) + ");\n                            }\n                        ")), (PsiElement)aClass);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"createMethodFromText(...)");
        return psiMethod;
    }

    private final Language getLanguageFromExternalizationClass(PsiJavaFile $this$languageFromExternalizationClass) {
        Matcher matcher = shortcutPattern.matcher($this$languageFromExternalizationClass.getName());
        Lazy maybeLazyException$delegate = LazyKt.lazy(() -> MessagesConglomerate._get_languageFromExternalizationClass_$lambda$5($this$languageFromExternalizationClass));
        if (!matcher.matches()) {
            throw MessagesConglomerate._get_languageFromExternalizationClass_$lambda$6((Lazy<WrongClassException>)maybeLazyException$delegate);
        }
        String string = matcher.group(1);
        if (string == null) {
            throw MessagesConglomerate._get_languageFromExternalizationClass_$lambda$6((Lazy<WrongClassException>)maybeLazyException$delegate);
        }
        String shortcut = string;
        Language language = Language.Companion.fromShortcut(shortcut);
        if (language == null) {
            throw new WrongClassException("Messages Externalisieren Tool does not support the language with shortcut " + shortcut + " yet. Due to this the file " + $this$languageFromExternalizationClass.getName() + " cannot be read.");
        }
        return language;
    }

    private static final void addExternalizationToConcreteMessageClass$lambda$2(PsiClass $classToAddTo, PsiMethod $newMethod) {
        $classToAddTo.add((PsiElement)$newMethod);
    }

    private static final void replaceExternalizationOfConcreteMessageClass$lambda$3(PsiMethod $methodToReplace, PsiMethod $newMethod) {
        $methodToReplace.replace((PsiElement)$newMethod);
    }

    private static final CharSequence createParameterList$lambda$4(boolean $withFinal, boolean $withType, boolean $forCall, Map.Entry expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return ($withFinal ? "final " : "") + ($withType ? PsiExpressionExtensionKt.getResolvedJavaType((PsiExpression)expression.getKey()) : "") + " " + ($forCall ? ((PsiExpression)expression.getKey()).getText() : (String)expression.getValue());
    }

    private static final WrongClassException _get_languageFromExternalizationClass_$lambda$5(PsiJavaFile $this_languageFromExternalizationClass) {
        return new WrongClassException("Could not derive language from class " + $this_languageFromExternalizationClass.getName() + " using pattern " + shortcutPattern + ".");
    }

    private static final WrongClassException _get_languageFromExternalizationClass_$lambda$6(Lazy<WrongClassException> $maybeLazyException$delegate) {
        Lazy<WrongClassException> lazy = $maybeLazyException$delegate;
        return (WrongClassException)lazy.getValue();
    }

    public static final /* synthetic */ PsiMethod access$createStaticMethod(MessagesConglomerate $this, PsiElementFactory psiElementFactory, ExternalizationForJava externalization, PsiClass aClass) {
        return $this.createStaticMethod(psiElementFactory, externalization, aClass);
    }

    public static final /* synthetic */ PsiElementFactory access$getPsiElementFactory$p(MessagesConglomerate $this) {
        return $this.psiElementFactory;
    }

    public static final /* synthetic */ PsiMethod access$createAbstractMethod(MessagesConglomerate $this, PsiElementFactory psiElementFactory, ExternalizationForJava externalization, PsiClass aClass) {
        return $this.createAbstractMethod(psiElementFactory, externalization, aClass);
    }

    public static final /* synthetic */ PsiExpression access$createMethodCall(MessagesConglomerate $this, PsiElementFactory psiElementFactory, ExternalizationForJava externalization) {
        return $this.createMethodCall(psiElementFactory, externalization);
    }

    public static final /* synthetic */ Language access$getLanguageFromExternalizationClass(MessagesConglomerate $this, PsiJavaFile $receiver) {
        return $this.getLanguageFromExternalizationClass($receiver);
    }

    public static final /* synthetic */ Error access$createMissingTranslationError(MessagesConglomerate $this, PsiJavaFile concreteLanguageClass) {
        return $this.createMissingTranslationError(concreteLanguageClass);
    }

    public static final /* synthetic */ PsiMethod access$createNewMethodForConcreteMessageClass(MessagesConglomerate $this, String operationName, StringWithParameters translation, PsiClass classToAddTo) {
        return $this.createNewMethodForConcreteMessageClass(operationName, translation, classToAddTo);
    }

    public static final /* synthetic */ void access$replaceExternalizationOfConcreteMessageClass(MessagesConglomerate $this, PsiMethod newMethod, PsiMethod methodToReplace) {
        $this.replaceExternalizationOfConcreteMessageClass(newMethod, methodToReplace);
    }

    public static final /* synthetic */ void access$addExternalizationToConcreteMessageClass(MessagesConglomerate $this, PsiClass classToAddTo, PsiMethod newMethod) {
        $this.addExternalizationToConcreteMessageClass(classToAddTo, newMethod);
    }

    static {
        Pattern pattern = Pattern.compile("Messages_(.+).java");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        shortcutPattern = pattern;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u0013\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/set/intellij/messages/domain/MessagesConglomerate$Companion;", "", "<init>", "()V", "shortcutPattern", "Ljava/util/regex/Pattern;", "findOrGenerateMessagesForClass", "Lde/set/intellij/messages/domain/MessagesConglomerate;", "javaFile", "Lcom/intellij/psi/PsiJavaFile;", "project", "Lcom/intellij/openapi/project/Project;", "languages", "", "Lde/set/intellij/messages/domain/Language;", "findMessagesForClass", "findMessagesForDirectory", "dir", "Lcom/intellij/psi/PsiDirectory;", "generateMessagesInitially", "containingDirectory", "Messages_Externalisieren"})
    @SourceDebugExtension(value={"SMAP\nMessagesConglomerate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessagesConglomerate.kt\nde/set/intellij/messages/domain/MessagesConglomerate$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,433:1\n4135#2,11:434\n3829#2:446\n4344#2,2:447\n1#3:445\n808#4,11:449\n1563#4:460\n1634#4,3:461\n1869#4,2:468\n37#5:464\n36#5,3:465\n*S KotlinDebug\n*F\n+ 1 MessagesConglomerate.kt\nde/set/intellij/messages/domain/MessagesConglomerate$Companion\n*L\n338#1:434,11\n342#1:446\n342#1:447,2\n343#1:449,11\n386#1:460\n386#1:461,3\n402#1:468,2\n403#1:464\n403#1:465,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MessagesConglomerate findOrGenerateMessagesForClass(@NotNull PsiJavaFile javaFile, @NotNull Project project, @NotNull Set<? extends Language> languages) {
            Intrinsics.checkNotNullParameter((Object)javaFile, (String)"javaFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(languages, (String)"languages");
            MessagesConglomerate messagesConglomerate = this.findMessagesForClass(javaFile, project);
            if (messagesConglomerate == null) {
                PsiDirectory psiDirectory = javaFile.getContainingDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"getContainingDirectory(...)");
                messagesConglomerate = this.generateMessagesInitially(project, psiDirectory, languages);
            }
            return messagesConglomerate;
        }

        public static /* synthetic */ MessagesConglomerate findOrGenerateMessagesForClass$default(Companion companion, PsiJavaFile psiJavaFile, Project project, Set set, int n, Object object) {
            if ((n & 4) != 0) {
                Language[] languageArray = new Language[]{Language.DE, Language.EN};
                set = SetsKt.setOf((Object[])languageArray);
            }
            return companion.findOrGenerateMessagesForClass(psiJavaFile, project, set);
        }

        private final MessagesConglomerate findMessagesForClass(PsiJavaFile javaFile, Project project) {
            PsiDirectory psiDirectory = javaFile.getContainingDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"getContainingDirectory(...)");
            return this.findMessagesForDirectory(psiDirectory, project);
        }

        /*
         * WARNING - void declaration
         */
        private final MessagesConglomerate findMessagesForDirectory(PsiDirectory dir, Project project) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Collection<Object> collection;
            Object[] $i$f$filterIsInstance22;
            Collection<Object> destination$iv$iv2;
            block4: {
                Iterator $this$filterIsInstanceTo$iv$iv2;
                void $this$filterIsInstance$iv2;
                PsiFile[] psiFileArray = dir.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFiles(...)");
                Object[] objectArray = psiFileArray;
                boolean $i$f$filterIsInstance22 = false;
                void var6_6 = $this$filterIsInstance$iv2;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv instanceof PsiJavaFile)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $i$f$filterIsInstance22 = (Object[])((List)destination$iv$iv2);
                for (Collection<Object> destination$iv$iv2 : $i$f$filterIsInstance22) {
                    PsiJavaFile it = (PsiJavaFile)destination$iv$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Messages.java")) continue;
                    collection = destination$iv$iv2;
                    break block4;
                }
                collection = null;
            }
            PsiJavaFile abstractMessagesFile = (PsiJavaFile)collection;
            PsiFile[] psiFileArray = dir.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFiles(...)");
            $i$f$filterIsInstance22 = psiFileArray;
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                PsiFile it = (PsiFile)element$iv$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)"Messages_", (boolean)false, (int)2, null)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$filterIsInstance = false;
            $this$filterTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PsiJavaFile)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            Set concreteMessageFiles = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv3));
            return abstractMessagesFile != null ? new MessagesConglomerate(project, abstractMessagesFile, concreteMessageFiles) : null;
        }

        /*
         * WARNING - void declaration
         */
        private final MessagesConglomerate generateMessagesInitially(Project project, PsiDirectory containingDirectory, Set<? extends Language> languages) {
            void $this$mapTo$iv$iv;
            PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
            PsiFile psiFile = psiFileFactory.createFileFromText("Messages.java", (com.intellij.lang.Language)JavaLanguage.INSTANCE, (CharSequence)(StringsKt.trimMargin$default((String)("\n                    |import de.setsoftware.stdlib.messages.AbstractMessages;\n                    |import de.setsoftware.stdlib.messages.MessageManager;\n                    |import de.setsoftware.stdlib.messages.MessageManager.MessageFactory;\n                    |\n                    |abstract class Messages extends AbstractMessages {\n                    |\n                    |    private static final MessageManager<Messages> MANAGER = new MessageManager<>(new MessageFactory<Messages>() {\n                    " + CollectionsKt.joinToString$default((Iterable)languages, (CharSequence)"\n", null, null, (int)0, null, Companion::generateMessagesInitially$lambda$2, (int)30, null) + "\n                    |    });\n                    |}\n                "), null, (int)1, null) + "\n"));
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
            PsiJavaFile abstractMessages = (PsiJavaFile)psiFile;
            Iterable $this$map$iv = languages;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void lang;
                Language language = (Language)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PsiFile psiFile2 = psiFileFactory.createFileFromText("Messages_" + lang.getShortcut() + ".java", (com.intellij.lang.Language)JavaLanguage.INSTANCE, (CharSequence)(StringsKt.trimIndent((String)("\n                    @SuppressWarnings(\"nls\")\n                    class Messages_" + lang.getShortcut() + " extends Messages {\n                    \n                    }\n                ")) + "\n"));
                Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
                collection.add((PsiJavaFile)psiFile2);
            }
            Set concreteLanguageClasses = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            Runnable runnable = () -> Companion.generateMessagesInitially$lambda$5(containingDirectory, abstractMessages, concreteLanguageClasses);
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)abstractMessages);
            Collection $this$toTypedArray$iv = concreteLanguageClasses;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new PsiJavaFile[0]));
            WriteCommandAction.runWriteCommandAction((Project)project, (String)"generateClassesInitially", (String)"groupId", (Runnable)runnable, (PsiFile[])((PsiFile[])spreadBuilder.toArray((Object[])new PsiFile[spreadBuilder.size()])));
            MessagesConglomerate messagesConglomerate = this.findMessagesForDirectory(containingDirectory, project);
            if (messagesConglomerate == null) {
                throw new Exception("Die erstellte Klasse konnte nicht gefunden werden.");
            }
            return messagesConglomerate;
        }

        private static final CharSequence generateMessagesInitially$lambda$2(Language lang) {
            Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
            return "\n                    |        @Override\n                    |        protected Messages create" + lang.getShortcut() + "() {\n                    |            return new Messages_" + lang.getShortcut() + "();\n                    |        }\n                        ";
        }

        private static final void generateMessagesInitially$lambda$5(PsiDirectory $containingDirectory, PsiJavaFile $abstractMessages, Set $concreteLanguageClasses) {
            $containingDirectory.add((PsiElement)$abstractMessages);
            Iterable $this$forEach$iv = $concreteLanguageClasses;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiJavaFile it = (PsiJavaFile)element$iv;
                boolean bl = false;
                $containingDirectory.add((PsiElement)it);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

