/*
 * Decompiled with CFR 0.152.
 */
package de.set.intellij.messages.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import de.set.intellij.messages.dialogs.LocalizeLiteralsDialogForJava;
import de.set.intellij.messages.dialogs.SelectLiteralsToBeExternalizedDialog;
import de.set.intellij.messages.domain.ExternalizationForJava;
import de.set.intellij.messages.domain.MessagesConglomerate;
import de.set.intellij.messages.domain.StringWithParameters;
import de.set.intellij.messages.util.extensions.PsiLiteralExpressionExtensionsKt;
import de.set.intellij.messages.util.translation.ExtractionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lde/set/intellij/messages/actions/ExternalizeFromProjectView;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getStringLiteralsFromPsiFile", "", "Lcom/intellij/psi/PsiLiteralExpression;", "javaClass", "Lcom/intellij/psi/PsiFile;", "Companion", "Messages_Externalisieren"})
@SourceDebugExtension(value={"SMAP\nExternalizeFromProjectView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalizeFromProjectView.kt\nde/set/intellij/messages/actions/ExternalizeFromProjectView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1563#2:113\n1634#2,3:114\n1669#2,8:117\n1563#2:125\n1634#2,3:126\n1563#2:129\n1634#2,3:130\n1869#2,2:133\n*S KotlinDebug\n*F\n+ 1 ExternalizeFromProjectView.kt\nde/set/intellij/messages/actions/ExternalizeFromProjectView\n*L\n54#1:113\n54#1:114,3\n58#1:117,8\n76#1:125\n76#1:126,3\n81#1:129\n81#1:130,3\n92#1:133,2\n*E\n"})
public final class ExternalizeFromProjectView
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String allowedFiletype = "JAVA";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        VirtualFile data = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (data == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        presentation2.setVisible(true);
        boolean isFileOfCorrectType = data.getFileType().getName() == allowedFiletype;
        presentation2.setEnabled(isFileOfCorrectType);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$mapTo$iv$iv2;
        Object key$iv;
        void $this$distinctBy$iv;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Iterable $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getData(CommonDataKeys.PSI_FILE);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
        PsiJavaFile javaClass = (PsiJavaFile)object;
        Iterable iterable = this.getStringLiteralsFromPsiFile((PsiFile)javaClass);
        ExtractionHelper extractionHelper = ExtractionHelper.INSTANCE;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void p0;
            PsiLiteralExpression psiLiteralExpression = (PsiLiteralExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(extractionHelper.getExtractableFromLiteralExpression((PsiLiteralExpression)p0));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<PsiExpression> set$iv = new HashSet<PsiExpression>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Pair it = (Pair)e$iv;
            boolean bl = false;
            key$iv = (PsiExpression)it.getSecond();
            if (!set$iv.add((PsiExpression)key$iv)) continue;
            list$iv.add(e$iv);
        }
        Map stringLiterals = MapsKt.toMap((Iterable)list$iv);
        Project project = e.getProject();
        if (project == null) {
            throw new RuntimeException("cannot load project out of event " + e);
        }
        Project project2 = project;
        SelectLiteralsToBeExternalizedDialog literalsToBeExternalizedDialog = new SelectLiteralsToBeExternalizedDialog(project2, stringLiterals);
        boolean shouldExtractStrings = literalsToBeExternalizedDialog.showAndGet();
        if (!shouldExtractStrings) {
            return;
        }
        List<Pair<StringWithParameters, PsiExpression>> toBeExternalized = literalsToBeExternalizedDialog.getLiteralsToBeExternalized();
        Iterable $this$map$iv3 = toBeExternalized;
        boolean $i$f$map22 = false;
        key$iv = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(((StringWithParameters)it.getFirst()).getContent());
        }
        $this$map$iv3 = (List)destination$iv$iv2;
        System.out.println($this$map$iv3);
        MessagesConglomerate messagesConglomerate = MessagesConglomerate.Companion.findOrGenerateMessagesForClass$default(MessagesConglomerate.Companion, javaClass, project2, null, 4, null);
        Iterable $i$f$map22 = toBeExternalized;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PsiExpression second;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            StringWithParameters first = (StringWithParameters)pair.component1();
            LocalizeLiteralsDialogForJava localizeLiteralsDialogForJava = new LocalizeLiteralsDialogForJava(project2, first, second = (PsiExpression)pair.component2());
            boolean shouldExternalize = localizeLiteralsDialogForJava.showAndGet();
            collection.add(shouldExternalize ? localizeLiteralsDialogForJava.getExternalization() : null);
        }
        $this$map$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv3));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExternalizationForJava p0 = (ExternalizationForJava)element$iv;
            boolean bl = false;
            messagesConglomerate.addExternalization(p0);
        }
    }

    private final List<PsiLiteralExpression> getStringLiteralsFromPsiFile(PsiFile javaClass) {
        List stringLiterals = new ArrayList();
        javaClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(stringLiterals){
            final /* synthetic */ List<PsiLiteralExpression> $stringLiterals;
            {
                this.$stringLiterals = $stringLiterals;
            }

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (PsiLiteralExpressionExtensionsKt.isStringExpression(expression)) {
                    this.$stringLiterals.add(expression);
                }
            }
        });
        return stringLiterals;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/set/intellij/messages/actions/ExternalizeFromProjectView$Companion;", "", "<init>", "()V", "allowedFiletype", "", "Messages_Externalisieren"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

