/*
 * Decompiled with CFR 0.152.
 */
package de.set.intellij.messages.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.util.PsiTreeUtil;
import de.set.intellij.messages.dialogs.LocalizeLiteralsDialogForJava;
import de.set.intellij.messages.domain.ExternalizationForJava;
import de.set.intellij.messages.domain.MessagesConglomerate;
import de.set.intellij.messages.domain.StringWithParameters;
import de.set.intellij.messages.util.translation.ExtractionHelper;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002\u00a8\u0006\u0013"}, d2={"Lde/set/intellij/messages/actions/ExternalizeStringLiteralIntentionAction;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "startInWriteAction", "", "getText", "", "getFamilyName", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "Messages_Externalisieren"})
public final class ExternalizeStringLiteralIntentionAction
extends PsiElementBaseIntentionAction
implements IntentionAction {
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        return "Message externalisieren";
    }

    @NotNull
    public String getFamilyName() {
        return "Message externalisieren";
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PsiJavaToken && (Intrinsics.areEqual((Object)((PsiJavaToken)element).getTokenType(), (Object)JavaTokenType.STRING_LITERAL) || Intrinsics.areEqual((Object)((PsiJavaToken)element).getTokenType(), (Object)JavaTokenType.TEXT_BLOCK_LITERAL));
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        PsiExpression toBeExternalized;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiLiteralExpression psiLiteralExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLiteralExpression.class);
        if (psiLiteralExpression == null) {
            throw new RuntimeException("could not find parent of type " + PsiLiteralExpression.class + " in " + element + "!");
        }
        PsiLiteralExpression parentOfType = psiLiteralExpression;
        Pair<StringWithParameters, PsiExpression> pair = ExtractionHelper.INSTANCE.getExtractableFromLiteralExpression(parentOfType);
        StringWithParameters expressionContent = (StringWithParameters)pair.component1();
        LocalizeLiteralsDialogForJava dialog = new LocalizeLiteralsDialogForJava(project, expressionContent, toBeExternalized = (PsiExpression)pair.component2());
        boolean shouldExternalize = dialog.showAndGet();
        if (shouldExternalize) {
            PsiFile psiFile = element.getContainingFile();
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
            MessagesConglomerate messagesConglomerate = MessagesConglomerate.Companion.findOrGenerateMessagesForClass$default(MessagesConglomerate.Companion, (PsiJavaFile)psiFile, project, null, 4, null);
            ExternalizationForJava externalization = dialog.getExternalization();
            messagesConglomerate.addExternalization(externalization);
        }
    }
}

