/*
 * Decompiled with CFR 0.152.
 */
package de.set.intellij.messages.util.translation;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiTreeUtil;
import de.set.intellij.messages.domain.StringWithParameters;
import de.set.intellij.messages.util.extensions.PsiLiteralExpressionExtensionsKt;
import de.set.intellij.messages.util.extensions.StringExtensionsKt;
import de.set.intellij.messages.util.translation.ParameterExtractionVisitor;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/set/intellij/messages/util/translation/ExtractionHelper;", "", "<init>", "()V", "stringFormatVariants", "", "", "getExtractableFromLiteralExpression", "Lkotlin/Pair;", "Lde/set/intellij/messages/domain/StringWithParameters;", "Lcom/intellij/psi/PsiExpression;", "expr", "Lcom/intellij/psi/PsiLiteralExpression;", "extractPolyadicExpression", "polyExpression", "Lcom/intellij/psi/PsiPolyadicExpression;", "extractMethodCallExpression", "methodCallExpression", "Lcom/intellij/psi/PsiMethodCallExpression;", "isStringFormatVariant", "", "methodName", "isCorrectExtractableExpression", "Messages_Externalisieren"})
@SourceDebugExtension(value={"SMAP\nExtractionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractionHelper.kt\nde/set/intellij/messages/util/translation/ExtractionHelper\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n66#2,2:138\n66#2,2:140\n1863#3,2:142\n*S KotlinDebug\n*F\n+ 1 ExtractionHelper.kt\nde/set/intellij/messages/util/translation/ExtractionHelper\n*L\n36#1:138,2\n44#1:140,2\n83#1:142,2\n*E\n"})
public final class ExtractionHelper {
    @NotNull
    public static final ExtractionHelper INSTANCE = new ExtractionHelper();
    @NotNull
    private static final Set<String> stringFormatVariants;

    private ExtractionHelper() {
    }

    @NotNull
    public final Pair<StringWithParameters, PsiExpression> getExtractableFromLiteralExpression(@NotNull PsiLiteralExpression expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)expr;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PsiPolyadicExpression polyExpression = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiPolyadicExpression.class, (boolean)true);
        if (polyExpression != null && this.isCorrectExtractableExpression(polyExpression)) {
            return this.extractPolyadicExpression(polyExpression);
        }
        PsiElement $this$parentOfType_u24default$iv2 = (PsiElement)expr;
        boolean withSelf$iv2 = false;
        boolean $i$f$parentOfType2 = false;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, PsiMethodCallExpression.class, (boolean)true);
        if (methodCallExpression != null && this.isStringFormatVariant(methodCallExpression.getMethodExpression().getQualifiedName())) {
            return this.extractMethodCallExpression(methodCallExpression);
        }
        Object object = PsiLiteralExpressionExtensionsKt.getStringFromLiteral(expr);
        if (object == null || (object = StringExtensionsKt.toStringWithParameters((String)object)) == null) {
            throw new RuntimeException("Given Literalexpression is not a Stringexpression");
        }
        Object stringWithParameters = object;
        return TuplesKt.to((Object)stringWithParameters, (Object)expr);
    }

    private final Pair<StringWithParameters, PsiExpression> extractPolyadicExpression(PsiPolyadicExpression polyExpression) {
        ParameterExtractionVisitor visitor = new ParameterExtractionVisitor();
        polyExpression.accept((PsiElementVisitor)visitor);
        return TuplesKt.to((Object)new StringWithParameters(visitor.getExternalizedString(), visitor.getExtractedParams()), (Object)polyExpression);
    }

    private final Pair<StringWithParameters, PsiExpression> extractMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
        Object[] objectArray = methodCallExpression.getArgumentList().getExpressions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getExpressions(...)");
        Object[] argumentList = objectArray;
        Object object = ArraysKt.first((Object[])argumentList);
        Object object2 = object instanceof PsiLiteralExpression ? (PsiLiteralExpression)object : null;
        if (object2 == null || (object2 = PsiLiteralExpressionExtensionsKt.getStringFromLiteral(object2)) == null) {
            throw new Exception("String.format besitzt keinen Stringliteral an erster Stelle und kann nicht externalisiert werden.");
        }
        Object literalText = object2;
        ParameterExtractionVisitor visitor = new ParameterExtractionVisitor();
        Iterable $this$forEach$iv = ArraysKt.drop((Object[])argumentList, (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiExpression it = (PsiExpression)element$iv;
            boolean bl = false;
            it.accept((PsiElementVisitor)visitor);
        }
        return TuplesKt.to((Object)new StringWithParameters((String)literalText, visitor.getExtractedParams()), (Object)methodCallExpression);
    }

    private final boolean isStringFormatVariant(String methodName) {
        return CollectionsKt.contains((Iterable)stringFormatVariants, (Object)methodName);
    }

    private final boolean isCorrectExtractableExpression(PsiPolyadicExpression polyExpression) {
        return Intrinsics.areEqual((Object)polyExpression.getOperationTokenType(), (Object)JavaTokenType.PLUS);
    }

    static {
        Object[] objectArray = new String[]{"System.out.printf", "String.format", "SystemInitializer.format"};
        stringFormatVariants = SetsKt.setOf((Object[])objectArray);
    }
}

