/*
 * Decompiled with CFR 0.152.
 */
package de.set.intellij.messages.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002\u00a8\u0006\u001f"}, d2={"Lde/set/intellij/messages/actions/MissingNonNlsIntentionAction;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "startInWriteAction", "", "getText", "", "getFamilyName", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "removeExistingNonNlsCommentsIfPresent", "psiFile", "Lcom/intellij/psi/PsiFile;", "doc", "Lcom/intellij/openapi/editor/Document;", "line", "", "countAllStringLiteralsInLine", "lineStartOffset", "lineEndOffset", "nonNlsString", "i", "Messages_Externalisieren"})
public final class MissingNonNlsIntentionAction
extends PsiElementBaseIntentionAction
implements IntentionAction {
    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getText() {
        return "NON-NLS-Kommentar(e) aktualisieren";
    }

    @NotNull
    public String getFamilyName() {
        return "NON-NLS-Kommentar(e) aktualisieren";
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PsiJavaToken && Intrinsics.areEqual((Object)((PsiJavaToken)element).getTokenType(), (Object)JavaTokenType.STRING_LITERAL);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Editor editor2 = editor;
        if (editor2 == null || (editor2 = editor2.getDocument()) == null) {
            throw new Exception("Unerwarteterweise ist kein Editor vorhanden. Bitte mit Schritten zum Nachstellen an Jeremy wenden.");
        }
        Editor doc = editor2;
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile psiFile2 = psiFile;
        int line = doc.getLineNumber(element.getTextRange().getEndOffset());
        this.removeExistingNonNlsCommentsIfPresent(psiFile2, (Document)doc, line);
        int lineStartOffset = doc.getLineStartOffset(line);
        int lineEndOffset = doc.getLineEndOffset(line);
        int stringLiteralCountInLine = this.countAllStringLiteralsInLine(lineStartOffset, lineEndOffset, psiFile2);
        String string = IntStream.rangeClosed(1, stringLiteralCountInLine).mapToObj(arg_0 -> MissingNonNlsIntentionAction.invoke$lambda$0(this, arg_0)).collect(Collectors.joining());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collect(...)");
        String commentsToAdd = string;
        doc.insertString(lineEndOffset, (CharSequence)commentsToAdd);
    }

    private final void removeExistingNonNlsCommentsIfPresent(PsiFile psiFile, Document doc, int line) {
        PsiElement possibleComment = psiFile.findElementAt(doc.getLineEndOffset(line) - 1);
        if (possibleComment instanceof PsiComment) {
            ((PsiComment)possibleComment).delete();
        }
    }

    private final int countAllStringLiteralsInLine(int lineStartOffset, int lineEndOffset, PsiFile psiFile) {
        Set elements = new LinkedHashSet();
        int i = lineStartOffset;
        if (i <= lineEndOffset) {
            while (true) {
                PsiElement findElementAt;
                if ((findElementAt = psiFile.findElementAt(i)) instanceof PsiJavaToken && Intrinsics.areEqual((Object)((PsiJavaToken)findElementAt).getTokenType(), (Object)JavaTokenType.STRING_LITERAL)) {
                    elements.add(findElementAt);
                }
                if (i == lineEndOffset) break;
                ++i;
            }
        }
        return elements.size();
    }

    private final String nonNlsString(int i) {
        return " //$NON-NLS-" + i + "$";
    }

    private static final String invoke$lambda$0(MissingNonNlsIntentionAction this$0, int it) {
        return this$0.nonNlsString(it);
    }
}

