/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.core.ui.intellij.views.toolWindowPanels;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import de.setsoftware.reviewtool.core.ui.intellij.TicketComponent;
import de.setsoftware.reviewtool.core.ui.intellij.TicketDetailAndActionsView;
import de.setsoftware.reviewtool.core.ui.intellij.config.PluginConfigurationManager;
import de.setsoftware.reviewtool.core.ui.intellij.config.ProjectSettings;
import de.setsoftware.reviewtool.core.ui.intellij.model.CortEvent;
import de.setsoftware.reviewtool.core.ui.intellij.plugin.ReviewPlugin;
import de.setsoftware.reviewtool.core.ui.intellij.util.observer.Observer;
import de.setsoftware.reviewtool.core.ui.intellij.views.toolWindowPanels.CortToolWindowPanel;
import de.setsoftware.reviewtool.model.ITicketConnector;
import de.setsoftware.reviewtool.model.TicketInfo;
import de.setsoftware.reviewtool.model.reflectionExtensions.ReviewStateManagerExtension;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdesktop.swingx.VerticalLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001.B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u001fH\u0002J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u001dH\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110*H\u0002J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u0004H\u0016J\b\u0010-\u001a\u00020\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00160\u00160\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/views/toolWindowPanels/CortToolWindowPanel;", "Lcom/intellij/ui/components/JBPanel;", "", "Lde/setsoftware/reviewtool/core/ui/intellij/util/observer/Observer;", "Lde/setsoftware/reviewtool/core/ui/intellij/model/CortEvent;", "project", "Lcom/intellij/openapi/project/Project;", "forReview", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "reviewPlugin", "Lde/setsoftware/reviewtool/core/ui/intellij/plugin/ReviewPlugin;", "pluginConfigManager", "Lde/setsoftware/reviewtool/core/ui/intellij/config/PluginConfigurationManager;", "ticketListModel", "Ljavax/swing/DefaultListModel;", "Lde/setsoftware/reviewtool/model/TicketInfo;", "ticketList", "Lcom/intellij/ui/components/JBList;", "reviewFiltersModel", "Ljavax/swing/DefaultComboBoxModel;", "", "reviewFilters", "Lcom/intellij/openapi/ui/ComboBox;", "kotlin.jvm.PlatformType", "ticketDetailAndActionsView", "Lde/setsoftware/reviewtool/core/ui/intellij/TicketDetailAndActionsView;", "refreshTicketList", "", "createTicketList", "Ljavax/swing/JPanel;", "speedSearch", "Lcom/intellij/ui/speedSearch/SpeedSearchSupply;", "createTicketFilterCombobox", "Ljava/awt/Component;", "createToolbar", "initializeComboboxWithValues", "ticketConnector", "Lde/setsoftware/reviewtool/model/ITicketConnector;", "selectFirstFilterValue", "retrieveTickets", "", "handleEvent", "event", "reinitGuiAfterConfigChanged", "Companion", "IntelliJ-CoRT"})
@SourceDebugExtension(value={"SMAP\nCortToolWindowPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CortToolWindowPanel.kt\nde/setsoftware/reviewtool/core/ui/intellij/views/toolWindowPanels/CortToolWindowPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n1#2:221\n295#3,2:222\n*S KotlinDebug\n*F\n+ 1 CortToolWindowPanel.kt\nde/setsoftware/reviewtool/core/ui/intellij/views/toolWindowPanels/CortToolWindowPanel\n*L\n177#1:222,2\n*E\n"})
public final class CortToolWindowPanel
extends JBPanel
implements Observer<CortEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final boolean forReview;
    @NotNull
    private final ReviewPlugin reviewPlugin;
    @NotNull
    private final PluginConfigurationManager pluginConfigManager;
    @NotNull
    private final DefaultListModel<TicketInfo> ticketListModel;
    @NotNull
    private final JBList<TicketInfo> ticketList;
    @NotNull
    private final DefaultComboBoxModel<String> reviewFiltersModel;
    @NotNull
    private final ComboBox<String> reviewFilters;
    @NotNull
    private final TicketDetailAndActionsView ticketDetailAndActionsView;
    @NotNull
    private static final Logger LOG;

    public CortToolWindowPanel(@NotNull Project project, boolean forReview) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((LayoutManager)new BorderLayout());
        this.project = project;
        this.forReview = forReview;
        DefaultListModel<TicketInfo> defaultListModel = this.ticketListModel = new DefaultListModel();
        this.ticketList = (JBList)new JBList<TicketInfo>(defaultListModel){

            protected void doCopyToClipboardAction() {
                block0: {
                    Object object = (TicketInfo)this.getSelectedValue();
                    if (object == null || (object = object.getId()) == null) break block0;
                    Object it = object;
                    boolean bl = false;
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection((String)it));
                }
            }
        };
        this.reviewFiltersModel = new DefaultComboBoxModel();
        this.reviewFilters = new ComboBox((ComboBoxModel)this.reviewFiltersModel);
        this.reviewPlugin = ReviewPlugin.Companion.getInstance(this.project);
        this.pluginConfigManager = PluginConfigurationManager.Companion.getInstance(this.project);
        this.reviewPlugin.register(this);
        this.ticketDetailAndActionsView = new TicketDetailAndActionsView(this.project, this.forReview);
        ListSpeedSearch listSpeedSearch = ListSpeedSearch.installOn((JList)((JList)this.ticketList), arg_0 -> CortToolWindowPanel._init_$lambda$1(CortToolWindowPanel::_init_$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)listSpeedSearch, (String)"installOn(...)");
        ListSpeedSearch speedSearch = listSpeedSearch;
        this.add(this.createTicketList(this.ticketDetailAndActionsView, (SpeedSearchSupply)speedSearch), "Center");
        this.add((Component)((Object)this.ticketDetailAndActionsView), "South");
    }

    private final void refreshTicketList() {
        Project project = this.project;
        Task.Backgroundable task2 = new Task.Backgroundable(this, project){
            final /* synthetic */ CortToolWindowPanel this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, "Ticketliste erfrischen");
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                List tickets = CortToolWindowPanel.access$retrieveTickets(this.this$0);
                ApplicationManager.getApplication().invokeLater(() -> refreshTicketList.task.1.run$lambda$0(this.this$0, tickets));
            }

            private static final void run$lambda$0(CortToolWindowPanel this$0, List $tickets) {
                CortToolWindowPanel.access$getTicketListModel$p(this$0).clear();
                CortToolWindowPanel.access$getTicketListModel$p(this$0).addAll($tickets);
            }
        };
        BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(task2);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)indicator);
    }

    private final JPanel createTicketList(TicketDetailAndActionsView ticketDetailAndActionsView, SpeedSearchSupply speedSearch) {
        JPanel ret = new JPanel(new BorderLayout());
        this.ticketList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(speedSearch){
            final /* synthetic */ SpeedSearchSupply $speedSearch;
            {
                this.$speedSearch = $speedSearch;
            }

            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value instanceof TicketInfo ? (Component)((Object)new TicketComponent((TicketInfo)value, this.$speedSearch, isSelected)) : null;
            }
        });
        this.ticketList.setSelectionMode(0);
        this.ticketList.addListSelectionListener(arg_0 -> CortToolWindowPanel.createTicketList$lambda$2(ticketDetailAndActionsView, this, arg_0));
        this.ticketList.addMouseListener((MouseListener)new MouseAdapter(ticketDetailAndActionsView){
            final /* synthetic */ TicketDetailAndActionsView $ticketDetailAndActionsView;
            {
                this.$ticketDetailAndActionsView = $ticketDetailAndActionsView;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getClickCount() == 2) {
                    this.$ticketDetailAndActionsView.startReviewOrFixing();
                }
            }
        });
        KeyStroke[] keyStrokeArray = new KeyStroke[]{KeyStroke.getKeyStroke(10, 0)};
        UiUtils.addKeyboardAction((JComponent)((JComponent)this.ticketList), (KeyStroke[])keyStrokeArray, arg_0 -> CortToolWindowPanel.createTicketList$lambda$3(ticketDetailAndActionsView, arg_0));
        JPanel toolBarWithCombobox = new JPanel((LayoutManager)new VerticalLayout());
        toolBarWithCombobox.add(this.createToolbar());
        toolBarWithCombobox.add(this.createTicketFilterCombobox());
        ret.add((Component)toolBarWithCombobox, "North");
        ret.add((Component)new JBScrollPane((Component)this.ticketList), "Center");
        this.refreshTicketList();
        return ret;
    }

    private final Component createTicketFilterCombobox() {
        JPanel ret = new JPanel(new BorderLayout());
        this.initializeComboboxWithValues(this.reviewPlugin.getTicketConnector());
        this.reviewFilters.addActionListener(arg_0 -> CortToolWindowPanel.createTicketFilterCombobox$lambda$4(this, arg_0));
        ret.add((Component)new JBLabel("Review-Filter: "), "West");
        ret.add((Component)this.reviewFilters, "Center");
        return ret;
    }

    private final JPanel createToolbar() {
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JList)((JList)this.ticketList));
        Intrinsics.checkNotNullExpressionValue((Object)toolbarDecorator, (String)"createDecorator(...)");
        ToolbarDecorator decorator = toolbarDecorator;
        decorator.disableUpDownActions();
        decorator.disableRemoveAction();
        Icon icon = AllIcons.Actions.Refresh;
        AnAction refreshTicketsAction2 = (AnAction)new DumbAwareAction(this, icon){
            final /* synthetic */ CortToolWindowPanel this$0;
            {
                this.this$0 = $receiver;
                super("Ticketliste Erfrischen", "Aktualisiert die Liste der geladenen Tickets", $super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CortToolWindowPanel.access$refreshTicketList(this.this$0);
            }
        };
        decorator.addExtraAction(refreshTicketsAction2);
        JPanel jPanel = decorator.createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        return jPanel;
    }

    private final void initializeComboboxWithValues(ITicketConnector ticketConnector) {
        String toCheck;
        Object object;
        Object $this$initializeComboboxWithValues_u24lambda_u245;
        this.reviewFiltersModel.removeAllElements();
        Object object2 = this;
        try {
            $this$initializeComboboxWithValues_u24lambda_u245 = object2;
            boolean bl = false;
            $this$initializeComboboxWithValues_u24lambda_u245 = Result.constructor-impl((Object)(((CortToolWindowPanel)$this$initializeComboboxWithValues_u24lambda_u245).forReview ? ticketConnector.getFilterNamesForReview() : ticketConnector.getFilterNamesForFixing()));
        }
        catch (Throwable bl) {
            $this$initializeComboboxWithValues_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$initializeComboboxWithValues_u24lambda_u245;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrElse(...)");
        Collection possibleFilterValues = (Collection)object;
        this.reviewFiltersModel.addAll(possibleFilterValues);
        ProjectSettings currentConfig = this.pluginConfigManager.getCurrent();
        String string = toCheck = this.forReview ? currentConfig.getLastUsedReviewFilter() : currentConfig.getLastUsedFixingFilter();
        if (toCheck != null) {
            String filterValue;
            Object v3;
            block9: {
                Iterable $this$firstOrNull$iv = possibleFilterValues;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)toCheck, (Object)it)) continue;
                    v3 = element$iv;
                    break block9;
                }
                v3 = null;
            }
            String string2 = filterValue = (String)v3;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                this.reviewFiltersModel.setSelectedItem(it);
            } else {
                this.selectFirstFilterValue();
            }
        } else {
            this.selectFirstFilterValue();
        }
    }

    private final void selectFirstFilterValue() {
        if (this.reviewFiltersModel.getSize() < 1) {
            return;
        }
        this.reviewFiltersModel.setSelectedItem(this.reviewFiltersModel.getElementAt(0));
    }

    private final List<TicketInfo> retrieveTickets() {
        if (!this.reviewPlugin.isConfigured()) {
            LOG.debug("can't refresh tickets because CoRT is not configured.");
            return CollectionsKt.emptyList();
        }
        LOG.debug("refreshing tickets...");
        ReviewStateManagerExtension reviewStateManagerExtension = this.reviewPlugin.getPersistence();
        Object object = this.reviewFiltersModel.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        List list = reviewStateManagerExtension.getTicketsForFilter((String)object, this.forReview);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTicketsForFilter(...)");
        return list;
    }

    @Override
    public void handleEvent(@NotNull CortEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        switch (WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
            case 1: {
                this.reinitGuiAfterConfigChanged();
                break;
            }
            case 2: 
            case 3: {
                this.refreshTicketList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void reinitGuiAfterConfigChanged() {
        this.ticketDetailAndActionsView.configChanged();
        this.initializeComboboxWithValues(this.reviewPlugin.getTicketConnector());
    }

    private static final String _init_$lambda$0(TicketInfo ticketInfo) {
        return ticketInfo.getId() + ticketInfo.getComponent() + ticketInfo.getSummaryIncludingParent();
    }

    private static final String _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void createTicketList$lambda$2(TicketDetailAndActionsView $ticketDetailAndActionsView, CortToolWindowPanel this$0, ListSelectionEvent it) {
        $ticketDetailAndActionsView.update((TicketInfo)this$0.ticketList.getSelectedValue());
    }

    private static final Unit createTicketList$lambda$3(TicketDetailAndActionsView $ticketDetailAndActionsView, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $ticketDetailAndActionsView.startReviewOrFixing();
        return Unit.INSTANCE;
    }

    private static final void createTicketFilterCombobox$lambda$4(CortToolWindowPanel this$0, ActionEvent it) {
        ProjectSettings current = this$0.pluginConfigManager.getCurrent();
        Object selectedItem = this$0.reviewFiltersModel.getSelectedItem();
        if (selectedItem instanceof String) {
            this$0.refreshTicketList();
            if (this$0.forReview) {
                current.setLastUsedReviewFilter((String)selectedItem);
            } else {
                current.setLastUsedFixingFilter((String)selectedItem);
            }
        }
        this$0.pluginConfigManager.setCurrent(current);
    }

    public static final /* synthetic */ List access$retrieveTickets(CortToolWindowPanel $this) {
        return $this.retrieveTickets();
    }

    public static final /* synthetic */ DefaultListModel access$getTicketListModel$p(CortToolWindowPanel $this) {
        return $this.ticketListModel;
    }

    public static final /* synthetic */ void access$refreshTicketList(CortToolWindowPanel $this) {
        $this.refreshTicketList();
    }

    static {
        Logger logger = Logger.getInstance(CortToolWindowPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/views/toolWindowPanels/CortToolWindowPanel$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "IntelliJ-CoRT"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CortEvent.values().length];
            try {
                nArray[CortEvent.CONFIG_REFRESHED_EVENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CortEvent.REVIEW_ENDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CortEvent.FIXING_ENDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

