/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.core.ui.intellij.plugin;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import de.setsoftware.reviewtool.base.Multiset;
import de.setsoftware.reviewtool.base.Pair;
import de.setsoftware.reviewtool.changesources.git.GitChangesourceConfigurator;
import de.setsoftware.reviewtool.config.ConfigurationInterpreter;
import de.setsoftware.reviewtool.config.IConfigurator;
import de.setsoftware.reviewtool.config.IReviewConfigurable;
import de.setsoftware.reviewtool.core.ui.intellij.IntelliJChangeManager;
import de.setsoftware.reviewtool.core.ui.intellij.config.CortCredentialManager;
import de.setsoftware.reviewtool.core.ui.intellij.config.PluginConfigurationManager;
import de.setsoftware.reviewtool.core.ui.intellij.model.CortEvent;
import de.setsoftware.reviewtool.core.ui.intellij.plugin.IntelliJBackgroundJobExecutor;
import de.setsoftware.reviewtool.core.ui.intellij.util.observer.Observee;
import de.setsoftware.reviewtool.core.ui.intellij.views.dialogs.CorrectSyntaxDialog;
import de.setsoftware.reviewtool.core.ui.intellij.views.dialogs.EndReviewDialog;
import de.setsoftware.reviewtool.core.ui.intellij.views.dialogs.RemarkMarkers;
import de.setsoftware.reviewtool.irrelevancestrategies.basicfilters.BasicIrrelevanceFilterConfigurator;
import de.setsoftware.reviewtool.irrelevancestrategies.basicfilters.BinaryFileFilterConfigurator;
import de.setsoftware.reviewtool.irrelevancestrategies.basicfilters.FileDeletionFilterConfigurator;
import de.setsoftware.reviewtool.irrelevancestrategies.pathfilters.FileCountInCommitAndPathFilterConfigurator;
import de.setsoftware.reviewtool.irrelevancestrategies.pathfilters.FileCountInCommitFilterConfigurator;
import de.setsoftware.reviewtool.irrelevancestrategies.pathfilters.PathIrrelevanceFilterConfigurator;
import de.setsoftware.reviewtool.lifecycle.IPostInitTask;
import de.setsoftware.reviewtool.model.DummyPersistence;
import de.setsoftware.reviewtool.model.EndTransition;
import de.setsoftware.reviewtool.model.FileReviewDataCache;
import de.setsoftware.reviewtool.model.IReviewDataCache;
import de.setsoftware.reviewtool.model.ISyntaxFixer;
import de.setsoftware.reviewtool.model.ITicketChooser;
import de.setsoftware.reviewtool.model.ITicketConnector;
import de.setsoftware.reviewtool.model.ITicketData;
import de.setsoftware.reviewtool.model.IUserInteraction;
import de.setsoftware.reviewtool.model.PositionTransformer;
import de.setsoftware.reviewtool.model.ReviewModeListener;
import de.setsoftware.reviewtool.model.ReviewStateManager;
import de.setsoftware.reviewtool.model.api.BackgroundJobExecutor;
import de.setsoftware.reviewtool.model.api.ChangeSourceException;
import de.setsoftware.reviewtool.model.api.IChangeData;
import de.setsoftware.reviewtool.model.api.IChangeSource;
import de.setsoftware.reviewtool.model.api.IChangeSourceUi;
import de.setsoftware.reviewtool.model.api.IClassification;
import de.setsoftware.reviewtool.model.api.ICommit;
import de.setsoftware.reviewtool.model.api.Mode;
import de.setsoftware.reviewtool.model.changestructure.ChangestructureFactory;
import de.setsoftware.reviewtool.model.changestructure.CurrentStop;
import de.setsoftware.reviewtool.model.changestructure.IChangeClassifier;
import de.setsoftware.reviewtool.model.changestructure.IStopOrdering;
import de.setsoftware.reviewtool.model.changestructure.Tour;
import de.setsoftware.reviewtool.model.changestructure.ToursInReview;
import de.setsoftware.reviewtool.model.reflectionExtensions.ReviewStateManagerExtension;
import de.setsoftware.reviewtool.model.remarks.DummyMarker;
import de.setsoftware.reviewtool.model.remarks.IMarkerFactory;
import de.setsoftware.reviewtool.model.remarks.ReviewData;
import de.setsoftware.reviewtool.ordering.StopOrdering;
import de.setsoftware.reviewtool.preferredtransitions.api.IPreferredTransitionStrategy;
import de.setsoftware.reviewtool.preferredtransitions.basicstrategies.PathRegexStrategyConfigurator;
import de.setsoftware.reviewtool.telemetry.Telemetry;
import de.setsoftware.reviewtool.ticketconnectors.file.FileTicketConnectorConfigurator;
import de.setsoftware.reviewtool.ticketconnectors.jira.JiraConnectorConfigurator;
import de.setsoftware.reviewtool.tourrestructuring.onestop.OneStopPerPartOfFileRestructuring;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 b2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002abB\u0011\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u0002002\u0006\u00107\u001a\u00020)H\u0002J\u0010\u00108\u001a\u0002002\u0006\u00104\u001a\u00020'H\u0002J\u0010\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020+H\u0002J\n\u0010;\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010<\u001a\u000200H\u0002J\u0010\u0010=\u001a\u0002002\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010>\u001a\u000200H\u0002J\u0010\u0010?\u001a\u0002002\u0006\u0010@\u001a\u00020\u001dH\u0002J\u000e\u0010A\u001a\u00020\u001f2\u0006\u0010B\u001a\u00020\u001dJ\u000e\u0010C\u001a\u0002002\u0006\u0010B\u001a\u00020\u001dJ\u000e\u0010D\u001a\u0002002\u0006\u0010E\u001a\u00020\u001aJ\u0018\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u0002022\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u0002002\u0006\u0010L\u001a\u00020\u0014H\u0002J\u0010\u0010M\u001a\u0002002\u0006\u00104\u001a\u00020\u0012H\u0002J\u0018\u0010N\u001a\u0002002\b\u0010H\u001a\u0004\u0018\u0001022\u0006\u0010O\u001a\u00020\u001fJ\u0006\u0010P\u001a\u000200J\b\u0010Q\u001a\u000200H\u0002J\u0016\u0010R\u001a\b\u0012\u0004\u0012\u0002020S2\u0006\u0010T\u001a\u00020UH\u0002J\b\u0010V\u001a\u000200H\u0002J\b\u0010W\u001a\u000200H\u0002J\u0010\u0010X\u001a\u00020\u001f2\u0006\u0010Y\u001a\u00020\u001aH\u0002J\b\u0010Z\u001a\u00020\u001fH\u0002J\b\u0010[\u001a\u000200H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010,\u001a\u00020+2\u0006\u0010*\u001a\u00020+@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0016\u0010\\\u001a\u0004\u0018\u00010]8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b^\u0010_R\u0011\u0010`\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b`\u0010!\u00a8\u0006c"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/plugin/ReviewPlugin;", "Lde/setsoftware/reviewtool/core/ui/intellij/util/observer/Observee;", "Lde/setsoftware/reviewtool/core/ui/intellij/model/CortEvent;", "Lde/setsoftware/reviewtool/config/IReviewConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "persistence", "Lde/setsoftware/reviewtool/model/reflectionExtensions/ReviewStateManagerExtension;", "getPersistence", "()Lde/setsoftware/reviewtool/model/reflectionExtensions/ReviewStateManagerExtension;", "configInterpreter", "Lde/setsoftware/reviewtool/config/ConfigurationInterpreter;", "relevanceFilters", "", "Lde/setsoftware/reviewtool/model/changestructure/IChangeClassifier;", "changeSources", "Lde/setsoftware/reviewtool/model/api/IChangeSource;", "changeManager", "Lde/setsoftware/reviewtool/core/ui/intellij/IntelliJChangeManager;", "stateDirectory", "Ljava/io/File;", "mode", "Lde/setsoftware/reviewtool/model/api/Mode;", "modeListeners", "", "Lde/setsoftware/reviewtool/model/ReviewModeListener;", "configured", "", "isConfigured", "()Z", "setConfigured", "(Z)V", "toursInReview", "Lde/setsoftware/reviewtool/model/changestructure/ToursInReview;", "preferredTransitionStrategies", "Lde/setsoftware/reviewtool/preferredtransitions/api/IPreferredTransitionStrategy;", "postInitTasks", "Ljava/lang/Runnable;", "value", "Lde/setsoftware/reviewtool/model/ITicketConnector;", "ticketConnector", "getTicketConnector", "()Lde/setsoftware/reviewtool/model/ITicketConnector;", "reconfigure", "", "getUserId", "", "configureWith", "strategy", "", "addPostInitTask", "r", "addPreferredTransitionStrategy", "setPersistence", "newPersistence", "getStateDirectory", "clearMarkers", "setMode", "notifyModeListeners", "notifyModeListener", "s", "registerModeListener", "reviewPluginModeService", "registerAndNotifyModeListener", "loadReviewData", "targetMode", "getChanges", "Lde/setsoftware/reviewtool/model/api/IChangeData;", "ticketKey", "sourceUi", "Lde/setsoftware/reviewtool/model/api/IChangeSourceUi;", "addChangeSource", "changeSource", "addClassificationStrategy", "startReviewOrFixingWithTicket", "forReview", "endReviewOrFixing", "endReview", "determinePreferredEndTransitions", "", "type", "Lde/setsoftware/reviewtool/model/EndTransition$Type;", "leaveActiveMode", "endFixing", "invalidMode", "expectedMode", "hasUnresolvedRemarks", "showPluginSettingsNotification", "currentReviewDataParsed", "Lde/setsoftware/reviewtool/model/remarks/ReviewData;", "getCurrentReviewDataParsed", "()Lde/setsoftware/reviewtool/model/remarks/ReviewData;", "isCurrentlyReviewing", "RealUi", "Companion", "IntelliJ-CoRT"})
@SourceDebugExtension(value={"SMAP\nReviewPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReviewPlugin.kt\nde/setsoftware/reviewtool/core/ui/intellij/plugin/ReviewPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,571:1\n1863#2,2:572\n1368#2:576\n1454#2,5:577\n37#3,2:574\n1#4:582\n*S KotlinDebug\n*F\n+ 1 ReviewPlugin.kt\nde/setsoftware/reviewtool/core/ui/intellij/plugin/ReviewPlugin\n*L\n224#1:572,2\n434#1:576\n434#1:577,5\n321#1:574,2\n*E\n"})
public final class ReviewPlugin
extends Observee<CortEvent>
implements IReviewConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ReviewStateManagerExtension persistence;
    @NotNull
    private final ConfigurationInterpreter configInterpreter;
    @NotNull
    private final List<IChangeClassifier> relevanceFilters;
    @NotNull
    private final List<IChangeSource> changeSources;
    @NotNull
    private final IntelliJChangeManager changeManager;
    @Nullable
    private final File stateDirectory;
    @NotNull
    private Mode mode;
    @NotNull
    private final Set<ReviewModeListener> modeListeners;
    private boolean isConfigured;
    @Nullable
    private ToursInReview toursInReview;
    @NotNull
    private final List<IPreferredTransitionStrategy> preferredTransitionStrategies;
    @NotNull
    private final List<Runnable> postInitTasks;
    @NotNull
    private ITicketConnector ticketConnector;
    @NotNull
    private static final Logger LOG;

    private ReviewPlugin(Project project) {
        this.project = project;
        this.configInterpreter = new ConfigurationInterpreter();
        this.relevanceFilters = new ArrayList();
        this.changeSources = new ArrayList();
        this.mode = Mode.IDLE;
        this.modeListeners = new LinkedHashSet();
        this.preferredTransitionStrategies = new ArrayList();
        this.postInitTasks = new ArrayList();
        this.ticketConnector = (ITicketConnector)new DummyPersistence();
        this.stateDirectory = ReviewPlugin.Companion.createStateDirectory(this.project);
        this.persistence = new ReviewStateManagerExtension((IReviewDataCache)new FileReviewDataCache(this.stateDirectory), this.ticketConnector, new RealUi());
        this.changeManager = new IntelliJChangeManager(this);
        this.configInterpreter.addConfigurator((IConfigurator)new JiraConnectorConfigurator());
        this.configInterpreter.addConfigurator((IConfigurator)new FileTicketConnectorConfigurator());
        this.configInterpreter.addConfigurator((IConfigurator)new PathRegexStrategyConfigurator());
        this.configInterpreter.addConfigurator((IConfigurator)new BasicIrrelevanceFilterConfigurator());
        this.configInterpreter.addConfigurator((IConfigurator)new PathIrrelevanceFilterConfigurator());
        this.configInterpreter.addConfigurator((IConfigurator)new FileDeletionFilterConfigurator());
        this.configInterpreter.addConfigurator((IConfigurator)new BinaryFileFilterConfigurator());
        this.configInterpreter.addConfigurator((IConfigurator)new FileCountInCommitFilterConfigurator());
        this.configInterpreter.addConfigurator((IConfigurator)new FileCountInCommitAndPathFilterConfigurator());
        this.configInterpreter.addConfigurator((IConfigurator)new GitChangesourceConfigurator());
        BackgroundJobExecutor.setInstance((BackgroundJobExecutor)new IntelliJBackgroundJobExecutor(this.project));
        PositionTransformer.setProjectSource(() -> ReviewPlugin._init_$lambda$1(this));
        this.reconfigure();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ReviewStateManagerExtension getPersistence() {
        return this.persistence;
    }

    public final boolean isConfigured() {
        return this.isConfigured;
    }

    public final void setConfigured(boolean configured) {
        this.isConfigured = configured;
        this.notifyObservers(CortEvent.CONFIG_REFRESHED_EVENT);
    }

    @NotNull
    public final ITicketConnector getTicketConnector() {
        return this.ticketConnector;
    }

    /*
     * WARNING - void declaration
     */
    public final void reconfigure() {
        Object object;
        Object $this$reconfigure_u24lambda_u242;
        Object object2 = this;
        ReviewPlugin reviewPlugin = this;
        try {
            boolean bl;
            $this$reconfigure_u24lambda_u242 = object2;
            boolean bl2 = false;
            String configFileLocation = PluginConfigurationManager.Companion.getInstance(((ReviewPlugin)$this$reconfigure_u24lambda_u242).project).getCurrent().getConfigFileLocation();
            CharSequence charSequence = configFileLocation;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                LOG.info("config file has not been set.");
                bl = false;
            } else {
                Document config = ConfigurationInterpreter.load((String)configFileLocation);
                Set set = ((ReviewPlugin)$this$reconfigure_u24lambda_u242).configInterpreter.getUserSpecificParamNames(config);
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getUserSpecificParamNames(...)");
                Set paramNames = set;
                ((ReviewPlugin)$this$reconfigure_u24lambda_u242).configInterpreter.configure(config, CortCredentialManager.Companion.getInstance(((ReviewPlugin)$this$reconfigure_u24lambda_u242).project).retrieveCredentials(paramNames), (IReviewConfigurable)$this$reconfigure_u24lambda_u242);
                bl = true;
            }
            $this$reconfigure_u24lambda_u242 = Result.constructor-impl((Object)bl);
        }
        catch (Throwable bl2) {
            $this$reconfigure_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        ReviewPlugin reviewPlugin2 = reviewPlugin;
        object2 = $this$reconfigure_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            void it;
            $this$reconfigure_u24lambda_u242 = throwable;
            reviewPlugin = reviewPlugin2;
            boolean bl = false;
            LOG.error("error while loading config", (Throwable)it);
            object = false;
            reviewPlugin2 = reviewPlugin;
        }
        reviewPlugin2.setConfigured((Boolean)object);
        if (!this.isConfigured) {
            this.showPluginSettingsNotification();
        }
    }

    @NotNull
    public final String getUserId() {
        String string = CortCredentialManager.Companion.getInstance(this.project).retrieveCredential("User-ID");
        if (string == null) {
            string = "UNKNOWN";
        }
        return string;
    }

    public void configureWith(@NotNull Object strategy) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        boolean handled = false;
        if (strategy instanceof ITicketConnector) {
            this.setPersistence((ITicketConnector)strategy);
            handled = true;
        }
        if (strategy instanceof IChangeSource) {
            this.addChangeSource((IChangeSource)strategy);
            handled = true;
        }
        if (strategy instanceof IPostInitTask) {
            this.addPostInitTask((Runnable)strategy);
            handled = true;
        }
        if (strategy instanceof IPreferredTransitionStrategy) {
            this.addPreferredTransitionStrategy((IPreferredTransitionStrategy)strategy);
            handled = true;
        }
        if (strategy instanceof IChangeClassifier) {
            this.addClassificationStrategy((IChangeClassifier)strategy);
            handled = true;
        }
        if (!handled) {
            throw new AssertionError((Object)("unhandled configuration result: " + strategy));
        }
    }

    private final void addPostInitTask(Runnable r) {
        this.postInitTasks.add(r);
    }

    private final void addPreferredTransitionStrategy(IPreferredTransitionStrategy strategy) {
        this.preferredTransitionStrategies.add(strategy);
    }

    private final void setPersistence(ITicketConnector newPersistence) {
        this.ticketConnector = newPersistence;
        this.persistence.setPersistence(newPersistence);
    }

    @Nullable
    public File getStateDirectory() {
        return this.stateDirectory;
    }

    private final void clearMarkers() {
        RemarkMarkers.INSTANCE.clearMarkers(this.project);
    }

    private final void setMode(Mode mode) {
        if (mode != this.mode) {
            this.mode = mode;
            this.notifyModeListeners();
        }
        if (mode == Mode.IDLE) {
            this.toursInReview = null;
        }
    }

    private final void notifyModeListeners() {
        Iterable $this$forEach$iv = this.modeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReviewModeListener p0 = (ReviewModeListener)element$iv;
            boolean bl = false;
            this.notifyModeListener(p0);
        }
    }

    private final void notifyModeListener(ReviewModeListener s) {
        s.notifyForMode(this.mode, (ReviewStateManager)this.persistence, this.toursInReview);
    }

    public final boolean registerModeListener(@NotNull ReviewModeListener reviewPluginModeService) {
        Intrinsics.checkNotNullParameter((Object)reviewPluginModeService, (String)"reviewPluginModeService");
        return this.modeListeners.add(reviewPluginModeService);
    }

    public final void registerAndNotifyModeListener(@NotNull ReviewModeListener reviewPluginModeService) {
        Intrinsics.checkNotNullParameter((Object)reviewPluginModeService, (String)"reviewPluginModeService");
        this.modeListeners.add(reviewPluginModeService);
        this.notifyModeListener(reviewPluginModeService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void loadReviewData(@NotNull Mode targetMode) throws ChangeSourceException {
        Intrinsics.checkNotNullParameter((Object)targetMode, (String)"targetMode");
        if (targetMode == Mode.REVIEWING) {
            String string = this.persistence.overrideTicketKeyGet();
            if (string == null) {
                return;
            }
            String ticketKey = string;
            IChangeSourceUi sourceUi2 = new IChangeSourceUi(){

                public Boolean handleLocalWorkingIncomplete(String s) {
                    Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                    return null;
                }

                public void increaseTaskNestingLevel() {
                }

                public void decreaseTaskNestingLevel() {
                }

                public boolean isCanceled() {
                    return false;
                }

                public void beginTask(String s, int i) {
                    Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                }

                public void subTask(String s) {
                    Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                }

                public void done() {
                }
            };
            ToursInReview.ICreateToursUi createUi2 = new ToursInReview.ICreateToursUi(){

                public List<Tour> selectInitialTours(List<? extends Pair<String, List<Tour>>> choices) {
                    Intrinsics.checkNotNullParameter(choices, (String)"choices");
                    if (choices.size() == 1) {
                        Object object = choices.get(0).getSecond();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSecond(...)");
                        return (List)object;
                    }
                    List tours = (List)choices.get(0).getSecond();
                    Intrinsics.checkNotNull((Object)tours);
                    Collection $this$toTypedArray$iv = tours;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String string = Arrays.toString(thisCollection$iv.toArray(new Tour[0]));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String string2 = string;
                    System.out.println((Object)string2);
                    return tours;
                }

                public ToursInReview.UserSelectedReductions selectIrrelevant(List<? extends ICommit> changes, Multiset<IClassification> strategyResults, List<ToursInReview.ReviewRoundInfo> reviewRounds) {
                    Intrinsics.checkNotNullParameter(changes, (String)"changes");
                    Intrinsics.checkNotNullParameter(strategyResults, (String)"strategyResults");
                    Intrinsics.checkNotNullParameter(reviewRounds, (String)"reviewRounds");
                    return new ToursInReview.UserSelectedReductions(changes, SetsKt.emptySet());
                }
            };
            try {
                Object object;
                sourceUi2.subTask("Determining relevant changes...");
                IChangeData changes = null;
                try {
                    changes = this.getChanges(ticketKey, sourceUi2);
                    if (changes.getMatchedCommits().isEmpty()) {
                        // empty if block
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                sourceUi2.subTask("Creating tours...");
                Object object2 = this;
                ReviewPlugin reviewPlugin = this;
                try {
                    ReviewPlugin $this$loadReviewData_u24lambda_u244 = object2;
                    boolean bl = false;
                    List<IChangeClassifier> list = $this$loadReviewData_u24lambda_u244.relevanceFilters;
                    List list2 = CollectionsKt.listOf((Object)new OneStopPerPartOfFileRestructuring());
                    IStopOrdering iStopOrdering = (IStopOrdering)new StopOrdering(CollectionsKt.emptyList());
                    ITicketData iTicketData = $this$loadReviewData_u24lambda_u244.persistence.getCurrentTicketData();
                    Intrinsics.checkNotNullExpressionValue((Object)iTicketData, (String)"getCurrentTicketData(...)");
                    object = Result.constructor-impl((Object)ToursInReview.create((IChangeSourceUi)sourceUi2, list, (List)list2, (IStopOrdering)iStopOrdering, (ToursInReview.ICreateToursUi)createUi2, (IChangeData)changes, (List)ReviewPlugin.Companion.getReviewRounds(iTicketData)));
                }
                catch (Throwable bl) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                ReviewPlugin reviewPlugin2 = reviewPlugin;
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    void e;
                    Object bl = object = throwable;
                    reviewPlugin = reviewPlugin2;
                    boolean bl2 = false;
                    StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                    Collection $this$toTypedArray$iv = ArraysKt.distinct((Object[])stackTraceElementArray);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    e.setStackTrace(thisCollection$iv.toArray(new StackTraceElement[0]));
                    LOG.error("Exception occured while calculating tours in review. Continuing without review tours.", (Throwable)new Exception((Throwable)e));
                    reviewPlugin2 = reviewPlugin;
                }
                reviewPlugin2.toursInReview = (ToursInReview)(Result.isFailure-impl((Object)object2) ? null : object2);
                sourceUi2.subTask("Creating stop markers...");
            }
            finally {
                sourceUi2.done();
            }
        }
        RemarkMarkers.INSTANCE.clearMarkers(this.project);
        RemarkMarkers.INSTANCE.loadRemarks(this.persistence, this.project);
    }

    private final IChangeData getChanges(String ticketKey, IChangeSourceUi sourceUi2) throws ChangeSourceException {
        List commits = new ArrayList();
        for (IChangeSource src : this.changeManager.getChangeSources()) {
            List list = src.getRepositoryChanges(ticketKey, sourceUi2).getMatchedCommits();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMatchedCommits(...)");
            commits.addAll(list);
        }
        IChangeData iChangeData = ChangestructureFactory.createChangeData((List)commits);
        Intrinsics.checkNotNullExpressionValue((Object)iChangeData, (String)"createChangeData(...)");
        return iChangeData;
    }

    private final void addChangeSource(IChangeSource changeSource) {
        this.changeSources.add(changeSource);
        this.changeManager.setChangeSources(this.changeSources);
        PositionTransformer.setChangeSources(this.changeSources);
    }

    private final void addClassificationStrategy(IChangeClassifier strategy) {
        this.relevanceFilters.add(strategy);
    }

    public final void startReviewOrFixingWithTicket(@Nullable String ticketKey, boolean forReview) {
        ReviewStateManagerExtension persistence = this.persistence;
        persistence.setTicketKey(ticketKey);
        Mode newMode = forReview ? Mode.REVIEWING : Mode.FIXING;
        try {
            Companion.openGitTab(this.project);
            this.loadReviewData(newMode);
        }
        catch (ChangeSourceException e) {
            throw new RuntimeException(e);
        }
        this.setMode(newMode);
        if (forReview) {
            persistence.startReviewing();
        } else {
            persistence.startFixing();
        }
    }

    public final void endReviewOrFixing() {
        if (this.mode == Mode.FIXING) {
            this.endFixing();
        } else {
            this.endReview();
        }
    }

    private final void endReview() {
        int dialogResult;
        if (this.invalidMode(Mode.REVIEWING)) {
            return;
        }
        ReviewData reviewData = this.getCurrentReviewDataParsed();
        if (reviewData == null) {
            throw new Exception("Reviewdata does not exist or cannot be parsed.");
        }
        ReviewData reviewData2 = reviewData;
        EndTransition.Type preferredEndTransitionType = reviewData2.hasTemporaryMarkers() ? EndTransition.Type.PAUSE : (reviewData2.hasUnresolvedRemarks() ? EndTransition.Type.REJECTION : EndTransition.Type.OK);
        EndTransition endTransition = EndReviewDialog.Companion.selectTypeOfEnd(this.persistence, reviewData2, preferredEndTransitionType, this.determinePreferredEndTransitions(preferredEndTransitionType));
        if (endTransition == null) {
            return;
        }
        EndTransition typeOfEnd = endTransition;
        if (typeOfEnd.getType() != EndTransition.Type.PAUSE && reviewData2.hasTemporaryMarkers() && (dialogResult = Messages.showYesNoDialog((String)"There are still temporary markers. Finish anyway?", (String)"Open Markers", (Icon)Messages.getQuestionIcon())) != 0) {
            return;
        }
        Telemetry.event((String)"reviewEnded").param("round", (long)this.persistence.getCurrentRound()).param("endTransition", (Object)typeOfEnd.getNameForUser()).log();
        if (typeOfEnd.getType() != EndTransition.Type.PAUSE) {
            this.persistence.changeStateAtReviewEnd(typeOfEnd);
        }
        this.leaveActiveMode();
        this.notifyObservers(CortEvent.REVIEW_ENDED);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> determinePreferredEndTransitions(EndTransition.Type type) {
        void $this$flatMapTo$iv$iv;
        if (this.toursInReview == null) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = this.preferredTransitionStrategies;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IPreferredTransitionStrategy strategy = (IPreferredTransitionStrategy)element$iv$iv;
            boolean bl = false;
            List list = strategy.determinePreferredTransitions(type == EndTransition.Type.OK, this.persistence.getCurrentTicketData(), this.toursInReview);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"determinePreferredTransitions(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void leaveActiveMode() {
        this.persistence.flushReviewData();
        this.clearMarkers();
        this.setMode(Mode.IDLE);
        CurrentStop.unsetCurrentStop();
    }

    private final void endFixing() {
        int dialogResult;
        if (this.invalidMode(Mode.FIXING)) {
            return;
        }
        if (this.hasUnresolvedRemarks() && (dialogResult = Messages.showYesNoDialog((Project)this.project, (String)"Some remarks have not been marked as processed. You can mark them with a quick fix on the marker. Finish anyway?", (String)"Open Remarks", (Icon)Messages.getQuestionIcon())) != 0) {
            return;
        }
        int changeTicketStateResult = Messages.showYesNoDialog((Project)this.project, (String)"Soll der Ticket-Status angepasst werden? Ein Ticket darf erst nach 'Bereit f\u00fcr Review', \n sobald die \u00c4nderungen durch den Preflight in Develop angekommen sind.", (String)"Ticket-Status nach 'Bereit f\u00fcr Review' \u00e4ndern?", (Icon)Messages.getQuestionIcon());
        Telemetry.event((String)"fixingEnded").param("round", (long)this.persistence.getCurrentRound()).log();
        if (changeTicketStateResult == 0) {
            this.persistence.changeStateToReadyForReview();
        }
        this.leaveActiveMode();
        this.notifyObservers(CortEvent.FIXING_ENDED);
    }

    private final boolean invalidMode(Mode expectedMode) {
        boolean bl;
        if (this.mode == expectedMode) {
            bl = false;
        } else {
            Messages.showErrorDialog((String)("The chosen action is not possible in CoRT's current mode. The current mode is " + this.mode + ", the needed mode is " + expectedMode + "."), (String)"Action Not Possible in Current Mode");
            bl = true;
        }
        return bl;
    }

    private final boolean hasUnresolvedRemarks() {
        ReviewData reviewData = this.getCurrentReviewDataParsed();
        return reviewData != null ? reviewData.hasUnresolvedRemarks() : true;
    }

    private final void showPluginSettingsNotification() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("CoRT Notification Group");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        NotificationGroup notificationGroup2 = notificationGroup;
        Notification notification = notificationGroup2.createNotification("CoRT configuration broken", "CoRT is not properly configured. Please configure CoRT correctly.", NotificationType.WARNING);
        notification.addAction((AnAction)new NotificationAction(this){
            final /* synthetic */ ReviewPlugin this$0;
            {
                this.this$0 = $receiver;
                super("Open CoRT Settings");
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                ShowSettingsUtil.getInstance().showSettingsDialog(this.this$0.getProject(), "CoRT");
            }
        });
        notification.notify(this.project);
    }

    private final ReviewData getCurrentReviewDataParsed() {
        ReviewStateManager reviewStateManager = this.persistence;
        IMarkerFactory iMarkerFactory = DummyMarker.FACTORY;
        Intrinsics.checkNotNullExpressionValue((Object)iMarkerFactory, (String)"FACTORY");
        return CorrectSyntaxDialog.Companion.getCurrentReviewDataParsed(reviewStateManager, iMarkerFactory);
    }

    public final boolean isCurrentlyReviewing() {
        return this.mode == Mode.REVIEWING;
    }

    private static final Set _init_$lambda$1(ReviewPlugin this$0) {
        File file;
        String string = this$0.project.getBasePath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = null;
        }
        return SetsKt.setOf(file);
    }

    static {
        Logger logger = Logger.getInstance(ReviewPlugin.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/plugin/ReviewPlugin$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createStateDirectory", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "getInstance", "Lde/setsoftware/reviewtool/core/ui/intellij/plugin/ReviewPlugin;", "getReviewRounds", "", "Lde/setsoftware/reviewtool/model/changestructure/ToursInReview$ReviewRoundInfo;", "ticket", "Lde/setsoftware/reviewtool/model/ITicketData;", "openGitTab", "", "IntelliJ-CoRT"})
    @SourceDebugExtension(value={"SMAP\nReviewPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReviewPlugin.kt\nde/setsoftware/reviewtool/core/ui/intellij/plugin/ReviewPlugin$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,571:1\n3829#2:572\n4344#2,2:573\n*S KotlinDebug\n*F\n+ 1 ReviewPlugin.kt\nde/setsoftware/reviewtool/core/ui/intellij/plugin/ReviewPlugin$Companion\n*L\n565#1:572\n565#1:573,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final File createStateDirectory(Project project) {
            VirtualFile workspaceFile = project.getWorkspaceFile();
            if (workspaceFile == null) {
                LOG.warn("workspaceFile is unexpectedly null.");
                return null;
            }
            VirtualFile workspaceDir = workspaceFile.getParent();
            File stateDir = workspaceDir.toNioPath().resolve("CoRT_state").toFile();
            stateDir.mkdirs();
            return stateDir;
        }

        @NotNull
        public final ReviewPlugin getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ReviewPlugin.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ReviewPlugin)object;
        }

        private final List<ToursInReview.ReviewRoundInfo> getReviewRounds(ITicketData ticket) {
            List ret = new ArrayList();
            int round = 1;
            int n = ticket.getCurrentRound();
            if (round <= n) {
                while (true) {
                    ret.add(new ToursInReview.ReviewRoundInfo(round, ticket.getEndTimeForRound(round), ticket.getReviewerForRound(round)));
                    if (round == n) break;
                    ++round;
                }
            }
            return ret;
        }

        public final void openGitTab(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ApplicationManager.getApplication().invokeLater(() -> Companion.openGitTab$lambda$1(project));
        }

        /*
         * WARNING - void declaration
         */
        private static final void openGitTab$lambda$1(Project $project) {
            Content content;
            Object contentManager;
            block6: {
                block5: {
                    void $this$filterTo$iv$iv;
                    ToolWindow toolWindow;
                    ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance($project).getToolWindow("Version Control");
                    if (toolWindow2 != null) {
                        toolWindow2.activate(null);
                    }
                    ToolWindow toolWindow3 = toolWindow;
                    contentManager = toolWindow3 != null ? toolWindow3.getContentManager() : null;
                    content = contentManager;
                    if (content == null || (content = content.getContents()) == null) break block5;
                    Content $this$filter$iv = content;
                    boolean $i$f$filter = false;
                    Content content2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    int n = ((void)$this$filterTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv;
                        void it = element$iv$iv = $this$filterTo$iv$iv[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)"Log")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    content = (Content)CollectionsKt.getOrNull((List)((List)destination$iv$iv), (int)0);
                    if (content != null) break block6;
                }
                return;
            }
            Content logTab = content;
            contentManager.setSelectedContent(logTab);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0002H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/plugin/ReviewPlugin$RealUi;", "Lde/setsoftware/reviewtool/model/IUserInteraction;", "Lde/setsoftware/reviewtool/model/ITicketChooser;", "Lde/setsoftware/reviewtool/model/ISyntaxFixer;", "<init>", "()V", "getTicketChooser", "choose", "", "persistence", "Lde/setsoftware/reviewtool/model/ITicketConnector;", "ticketKeyDefault", "forReview", "", "getSyntaxFixer", "getCurrentReviewDataParsed", "Lde/setsoftware/reviewtool/model/remarks/ReviewData;", "Lde/setsoftware/reviewtool/model/ReviewStateManager;", "factory", "Lde/setsoftware/reviewtool/model/remarks/IMarkerFactory;", "IntelliJ-CoRT"})
    private static final class RealUi
    implements IUserInteraction,
    ITicketChooser,
    ISyntaxFixer {
        @NotNull
        public ITicketChooser getTicketChooser() {
            return this;
        }

        @NotNull
        public String choose(@NotNull ITicketConnector persistence, @NotNull String ticketKeyDefault, boolean forReview) {
            Intrinsics.checkNotNullParameter((Object)persistence, (String)"persistence");
            Intrinsics.checkNotNullParameter((Object)ticketKeyDefault, (String)"ticketKeyDefault");
            return ticketKeyDefault;
        }

        @NotNull
        public ISyntaxFixer getSyntaxFixer() {
            return this;
        }

        @Nullable
        public ReviewData getCurrentReviewDataParsed(@NotNull ReviewStateManager persistence, @NotNull IMarkerFactory factory) {
            Intrinsics.checkNotNullParameter((Object)persistence, (String)"persistence");
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            return CorrectSyntaxDialog.Companion.getCurrentReviewDataParsed(persistence, factory);
        }
    }
}

