/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.svn;

import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.base.Pair;
import de.setsoftware.reviewtool.changesources.svn.CachedLogEntry;
import de.setsoftware.reviewtool.changesources.svn.CachedLogLookupHandler;
import de.setsoftware.reviewtool.changesources.svn.ISvnRepo;
import de.setsoftware.reviewtool.changesources.svn.SvnRepo;
import de.setsoftware.reviewtool.changesources.svn.SvnRepoRevision;
import de.setsoftware.reviewtool.model.api.BackgroundJobExecutor;
import de.setsoftware.reviewtool.model.api.IChangeSourceUi;
import de.setsoftware.reviewtool.model.api.IMutableFileHistoryGraph;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNClientManager;

final class SvnRepositoryManager {
    private static final SvnRepositoryManager INSTANCE = new SvnRepositoryManager();
    private static final long REVISION_BLOCK_SIZE = 500L;
    private final Map<SVNURL, SvnRepo> repoPerRemoteUrl = new LinkedHashMap<SVNURL, SvnRepo>();
    private SVNClientManager mgr;
    private int minCount = 1000;
    private File cacheDir;

    private SvnRepositoryManager() {
    }

    static SvnRepositoryManager getInstance() {
        return INSTANCE;
    }

    void init(SVNClientManager mgr, int minCount, File cacheDir) {
        this.mgr = mgr;
        this.minCount = minCount;
        this.cacheDir = cacheDir;
    }

    synchronized Collection<SvnRepo> getRepositories() {
        return Collections.unmodifiableCollection(this.repoPerRemoteUrl.values());
    }

    synchronized SvnRepo getRepo(SVNURL remoteUrl) {
        SvnRepo c = this.repoPerRemoteUrl.get(remoteUrl);
        if (c == null) {
            try {
                SVNRepository svnRepo = this.mgr.createRepository(remoteUrl, false);
                c = new SvnRepo(svnRepo, remoteUrl, this.cacheDir);
            }
            catch (SVNException e) {
                Logger.error((String)("Could not access repository " + remoteUrl), (Throwable)e);
                return null;
            }
            this.repoPerRemoteUrl.put(remoteUrl, c);
            this.tryToReadCacheFromFile(c);
        }
        return c;
    }

    synchronized SVNRepository getTemporaryRepo(SVNURL remoteRootUrl, String path) throws SVNException {
        return this.mgr.createRepository(remoteRootUrl.appendPath(path, false), true);
    }

    Pair<Boolean, List<SvnRepoRevision>> traverseRecentEntries(ISvnRepo repo, CachedLogLookupHandler handler, IChangeSourceUi ui) throws SVNException {
        ArrayList<SvnRepoRevision> result = new ArrayList<SvnRepoRevision>();
        Pair<Boolean, List<CachedLogEntry>> entries = this.getEntries(repo, ui);
        for (CachedLogEntry entry : (List)entries.getSecond()) {
            if (ui.isCanceled()) {
                throw BackgroundJobExecutor.createOperationCanceledException();
            }
            if (!handler.handleLogEntry(entry)) continue;
            result.add(new SvnRepoRevision(repo, entry));
        }
        return Pair.create((Object)((Boolean)entries.getFirst()), result);
    }

    private synchronized Pair<Boolean, List<CachedLogEntry>> getEntries(ISvnRepo repo, IChangeSourceUi ui) throws SVNException {
        boolean gotNewEntries = this.loadNewEntries(repo, ui);
        return Pair.create((Object)gotNewEntries, repo.getEntries());
    }

    private boolean loadNewEntries(ISvnRepo repo, IChangeSourceUi ui) throws SVNException {
        long latestRevision;
        List<CachedLogEntry> entries = repo.getEntries();
        long lastKnownRevision = entries.isEmpty() ? 0L : entries.get(entries.size() - 1).getRevision();
        if (lastKnownRevision < (latestRevision = repo.getLatestRevision())) {
            long startRevision = lastKnownRevision == 0L ? Math.max(0L, latestRevision - (long)this.minCount + 1L) : lastKnownRevision + 1L;
            this.loadNewEntries(repo, startRevision, latestRevision, ui);
            return true;
        }
        return false;
    }

    private void loadNewEntries(final ISvnRepo repo, long firstRevision, long lastRevision, final IChangeSourceUi ui) throws SVNException {
        if (lastRevision < firstRevision) {
            return;
        }
        final ArrayList<CachedLogEntry> newEntries = new ArrayList<CachedLogEntry>();
        final long numRevisionsTotal = lastRevision - firstRevision + 1L;
        Logger.info((String)("Processing revisions " + firstRevision + ".." + lastRevision + " from " + repo));
        ui.increaseTaskNestingLevel();
        try {
            ISVNLogEntryHandler handler = new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                    CachedLogEntry entry = new CachedLogEntry(logEntry);
                    SvnRepositoryManager.this.processLogEntry(entry, repo, newEntries.size(), numRevisionsTotal, ui);
                    newEntries.add(entry);
                }
            };
            repo.getLog(firstRevision, handler);
        }
        catch (Throwable throwable) {
            ui.decreaseTaskNestingLevel();
            repo.appendNewEntries(newEntries);
            if (!newEntries.isEmpty()) {
                BackgroundJobExecutor.executeWithMutex((String)("Storing SVN review cache for " + repo), (Object)repo.getCacheFilePath(), monitor -> this.tryToStoreCacheToFile(repo));
            }
            throw throwable;
        }
        ui.decreaseTaskNestingLevel();
        repo.appendNewEntries(newEntries);
        if (!newEntries.isEmpty()) {
            BackgroundJobExecutor.executeWithMutex((String)("Storing SVN review cache for " + repo), (Object)repo.getCacheFilePath(), monitor -> this.tryToStoreCacheToFile(repo));
        }
    }

    private void tryToReadCacheFromFile(ISvnRepo repo) {
        try {
            this.readCacheFromFile(repo);
        }
        catch (IOException | ClassCastException | ClassNotFoundException e) {
            Logger.error((String)("Problem while loading SVN history data for " + repo), (Throwable)e);
        }
    }

    private synchronized void readCacheFromFile(ISvnRepo repo) throws IOException, ClassNotFoundException {
        File cache = repo.getCacheFilePath();
        if (!cache.exists()) {
            Logger.info((String)("SVN cache " + cache + " is missing for " + repo + ", nothing to load"));
            return;
        }
        Logger.info((String)("Loading SVN history data for " + repo + " from " + cache));
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(cache)));){
            List value = (List)ois.readObject();
            IMutableFileHistoryGraph historyGraph = (IMutableFileHistoryGraph)ois.readObject();
            repo.appendNewEntries(value);
            repo.setFileHistoryGraph(historyGraph);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Logger.info((String)("Loaded SVN history data for " + repo + " from " + cache));
    }

    private void tryToStoreCacheToFile(ISvnRepo repo) {
        try {
            this.storeCacheToFile(repo);
        }
        catch (IOException e) {
            Logger.error((String)("Problem while storing SVN history data for " + repo), (Throwable)e);
        }
    }

    private synchronized void storeCacheToFile(ISvnRepo repo) throws IOException {
        File cache = repo.getCacheFilePath();
        Logger.info((String)("Storing SVN history data for " + repo + " to " + cache));
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(cache)));){
            oos.writeObject(repo.getEntries());
            oos.writeObject(repo.getFileHistoryGraph());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Logger.info((String)("Stored SVN history data for " + repo + " to " + cache));
    }

    private void processLogEntry(CachedLogEntry entry, ISvnRepo repo, long numEntriesProcessed, long numRevisionsTotal, IChangeSourceUi ui) {
        if (ui.isCanceled()) {
            throw BackgroundJobExecutor.createOperationCanceledException();
        }
        SvnRepoRevision revision = new SvnRepoRevision(repo, entry);
        long numEntriesProcessedNow = numEntriesProcessed + 1L;
        ui.subTask("Processing revision " + revision.getRevisionNumber() + " (" + numEntriesProcessedNow + "/" + numRevisionsTotal + ")...");
        revision.integrateInto(repo.getFileHistoryGraph());
        if (numEntriesProcessedNow % 500L == 0L) {
            Logger.debug((String)(String.valueOf(numEntriesProcessedNow) + " revisions processed"));
        }
    }
}

