/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.svn;

import de.setsoftware.reviewtool.base.ComparableWrapper;
import de.setsoftware.reviewtool.base.IPartiallyComparable;
import de.setsoftware.reviewtool.changesources.svn.AbstractSvnRevision;
import de.setsoftware.reviewtool.changesources.svn.CachedLogEntry;
import de.setsoftware.reviewtool.changesources.svn.CachedLogEntryPath;
import de.setsoftware.reviewtool.changesources.svn.ISvnRepo;
import de.setsoftware.reviewtool.model.api.IRepoRevision;
import de.setsoftware.reviewtool.model.api.IRepository;
import de.setsoftware.reviewtool.model.changestructure.ChangestructureFactory;
import java.util.Date;
import java.util.Map;

final class SvnRepoRevision
extends AbstractSvnRevision {
    private final ISvnRepo repository;
    private final CachedLogEntry logEntry;

    SvnRepoRevision(ISvnRepo repository, CachedLogEntry logEntry) {
        this.repository = repository;
        this.logEntry = logEntry;
    }

    @Override
    public ISvnRepo getRepository() {
        return this.repository;
    }

    @Override
    public long getRevisionNumber() {
        return this.logEntry.getRevision();
    }

    @Override
    public String getRevisionString() {
        return Long.toString(this.logEntry.getRevision());
    }

    public IRepoRevision<ComparableWrapper<Long>> toRevision() {
        return ChangestructureFactory.createRepoRevision((IPartiallyComparable)ComparableWrapper.wrap((Comparable)Long.valueOf(this.getRevisionNumber())), (IRepository)this.repository);
    }

    @Override
    public Date getDate() {
        return this.logEntry.getDate();
    }

    @Override
    public String getAuthor() {
        return this.logEntry.getAuthor();
    }

    @Override
    public String getMessage() {
        return this.logEntry.getMessage();
    }

    @Override
    public Map<String, CachedLogEntryPath> getChangedPaths() {
        return this.logEntry.getChangedPaths();
    }

    @Override
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        String message = this.getMessage();
        if (!message.isEmpty()) {
            sb.append(message);
            sb.append(" ");
        }
        sb.append(String.format("(Rev. %s, %tF %<tR, %s)", this.getRevisionString(), this.getDate(), this.getAuthor()));
        return sb.toString();
    }

    public String toString() {
        return String.valueOf(this.repository.toString()) + "@" + this.logEntry.toString();
    }
}

