/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.svn;

import de.setsoftware.reviewtool.base.ComparableWrapper;
import de.setsoftware.reviewtool.base.IPartiallyComparable;
import de.setsoftware.reviewtool.base.Pair;
import de.setsoftware.reviewtool.base.tree.DepthFirstTraversalTreeNodeIterator;
import de.setsoftware.reviewtool.base.tree.OrderPreservingTreeNode;
import de.setsoftware.reviewtool.base.tree.TreeChildOrderStrategy;
import de.setsoftware.reviewtool.base.tree.TreeLeftToRightChildOrderStrategy;
import de.setsoftware.reviewtool.base.tree.TreeNode;
import de.setsoftware.reviewtool.base.tree.TreePreOrderRootNodeStrategy;
import de.setsoftware.reviewtool.base.tree.TreeRootNodeStrategy;
import de.setsoftware.reviewtool.changesources.svn.CachedLogEntryPath;
import de.setsoftware.reviewtool.changesources.svn.ISvnRepo;
import de.setsoftware.reviewtool.changesources.svn.SvnRevision;
import de.setsoftware.reviewtool.changesources.svn.SvnWorkingCopy;
import de.setsoftware.reviewtool.model.api.IMutableFileHistoryGraph;
import de.setsoftware.reviewtool.model.api.IRepoRevision;
import de.setsoftware.reviewtool.model.api.IRepository;
import de.setsoftware.reviewtool.model.api.IRevision;
import de.setsoftware.reviewtool.model.changestructure.ChangestructureFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

abstract class AbstractSvnRevision
implements SvnRevision {
    AbstractSvnRevision() {
    }

    void integrateInto(IMutableFileHistoryGraph graph) {
        OrderPreservingTreeNode addedPaths = OrderPreservingTreeNode.createRoot(null);
        OrderPreservingTreeNode addedLeafs = OrderPreservingTreeNode.createRoot(null);
        for (Map.Entry<String, CachedLogEntryPath> e : this.getChangedPaths().entrySet()) {
            String path = e.getKey();
            CachedLogEntryPath pathInfo = e.getValue();
            IRevision revision = this.toRevision();
            if (pathInfo.isDeleted() || pathInfo.isReplaced()) {
                List<String> pathKey = AbstractSvnRevision.makePathKey(path);
                if (Optional.ofNullable((Boolean)addedPaths.getNearestValue(pathKey)).orElse(false).booleanValue()) {
                    OrderPreservingTreeNode orderPreservingTreeNode = (OrderPreservingTreeNode)addedLeafs.getNode(pathKey);
                    if (orderPreservingTreeNode != null) {
                        DepthFirstTraversalTreeNodeIterator it = new DepthFirstTraversalTreeNodeIterator((TreeNode)orderPreservingTreeNode, (TreeRootNodeStrategy)new TreePreOrderRootNodeStrategy(), (TreeChildOrderStrategy)new TreeLeftToRightChildOrderStrategy());
                        while (it.hasNext()) {
                            Pair entry = (Pair)it.next();
                            OrderPreservingTreeNode node = (OrderPreservingTreeNode)entry.getSecond();
                            if (!Optional.ofNullable((Boolean)node.getValue()).orElse(false).booleanValue()) continue;
                            String string = String.join((CharSequence)"/", (Iterable)entry.getFirst());
                            graph.addDeletion(string.isEmpty() ? path : String.valueOf(path) + "/" + string, revision);
                        }
                        ((OrderPreservingTreeNode)orderPreservingTreeNode.getParent()).removeNode(orderPreservingTreeNode);
                    }
                } else {
                    for (ISvnRepo.File file : this.getRelevantFilePaths(pathInfo, path, pathInfo.getAncestorRevision())) {
                        graph.addDeletion(file.getName(), revision);
                    }
                }
            }
            if (pathInfo.isNew() || pathInfo.isReplaced()) {
                String copyPath = pathInfo.getCopyPath();
                if (copyPath != null) {
                    long l = pathInfo.getCopyRevision();
                    IRepoRevision copyRevision = ChangestructureFactory.createRepoRevision((IPartiallyComparable)ComparableWrapper.wrap((Comparable)Long.valueOf(l)), (IRepository)this.getRepository());
                    if (pathInfo.isDir()) {
                        int copyPathLen = copyPath.length();
                        for (ISvnRepo.File file : this.getRelevantFilePaths(pathInfo, copyPath, l)) {
                            String copySourcePath = file.getName();
                            String copyTargetPath = String.valueOf(path) + copySourcePath.substring(copyPathLen);
                            graph.addCopy(copySourcePath, (IRevision)copyRevision, copyTargetPath, revision);
                            addedLeafs.putValue(AbstractSvnRevision.makePathKey(copyTargetPath), (Object)true);
                        }
                        addedPaths.putValue(AbstractSvnRevision.makePathKey(path), (Object)true);
                    } else if (pathInfo.isFile()) {
                        graph.addCopy(copyPath, (IRevision)copyRevision, path, revision);
                    }
                } else if (pathInfo.isFile()) {
                    graph.addAddition(path, revision);
                }
            }
            if (pathInfo.isDeleted() || pathInfo.isNew() || pathInfo.isReplaced() || !pathInfo.isFile()) continue;
            graph.addChange(path, revision, Collections.singleton(ChangestructureFactory.createRepoRevision((IPartiallyComparable)ComparableWrapper.wrap((Comparable)Long.valueOf(e.getValue().getAncestorRevision())), (IRepository)this.getRepository())));
        }
    }

    protected final SortedMap<String, CachedLogEntryPath> filterPaths(SvnWorkingCopy wc) {
        TreeMap<String, CachedLogEntryPath> result = new TreeMap<String, CachedLogEntryPath>();
        for (Map.Entry<String, CachedLogEntryPath> entry : this.getChangedPaths().entrySet()) {
            if (wc.toAbsolutePathInWc(entry.getKey()) == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private Set<? extends ISvnRepo.File> getRelevantFilePaths(CachedLogEntryPath pathInfo, final String path, long revisionNumber) {
        if (pathInfo.isFile()) {
            return new LinkedHashSet<1>(Arrays.asList(new ISvnRepo.File(){

                @Override
                public String getName() {
                    return path;
                }
            }));
        }
        if (pathInfo.isDir()) {
            IRepoRevision revision = ChangestructureFactory.createRepoRevision((IPartiallyComparable)ComparableWrapper.wrap((Comparable)Long.valueOf(revisionNumber)), (IRepository)this.getRepository());
            return this.getRepository().getFiles(path, revision);
        }
        return Collections.emptySet();
    }

    private static List<String> makePathKey(String path) {
        if (path.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> pathComponents = Arrays.asList(path.split("/"));
        return pathComponents.subList(1, pathComponents.size());
    }
}

