/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering.efficientalgorithm;

import de.setsoftware.reviewtool.ordering.efficientalgorithm.BundleCombinationTreeElement;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.ReverseImpossibleException;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.SimpleSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;

public class BundleCombinationTreeNode<T>
extends BundleCombinationTreeElement<T> {
    private final BundleCombinationTreeElement<T>[] children;
    private final boolean reorderingAllowed;
    private final boolean reverseAllowed;

    BundleCombinationTreeNode(BundleCombinationTreeElement<T>[] children, boolean reorderingAllowed, boolean reverseAllowed) {
        assert (children.length >= 2);
        this.children = children;
        this.reorderingAllowed = reorderingAllowed;
        this.reverseAllowed = reverseAllowed;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected BundleCombinationTreeElement.BundleResult<T> addBundle(SimpleSet<T> bundle) {
        BundleCombinationTreeElement.ResultType resultType;
        void var8_29;
        boolean startsWithMatches;
        if (this.reorderingAllowed) {
            void var8_25;
            boolean needsNoSplit;
            int partialBottomCount;
            EnumMap parts = new EnumMap(BundleCombinationTreeElement.ResultType.class);
            ArrayList<BundleCombinationTreeElement<T>> newChildren = new ArrayList<BundleCombinationTreeElement<T>>();
            Object[] objectArray = BundleCombinationTreeElement.ResultType.values();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleCombinationTreeElement.ResultType r = objectArray[n2];
                parts.put(r, new ArrayList());
                ++n2;
            }
            objectArray = this.children;
            n = this.children.length;
            n2 = 0;
            while (n2 < n) {
                BundleCombinationTreeElement.ResultType child = objectArray[n2];
                BundleCombinationTreeElement.BundleResult<T> bundleResult = ((BundleCombinationTreeElement)((Object)child)).addBundle(bundle);
                if (bundleResult.getType() == BundleCombinationTreeElement.ResultType.CONFLICT) {
                    return BundleCombinationTreeNode.result(BundleCombinationTreeElement.ResultType.CONFLICT, this);
                }
                ((List)parts.get((Object)bundleResult.getType())).add(bundleResult.getTree());
                newChildren.add(bundleResult.getTree());
                ++n2;
            }
            int atLeastPartialMatchCount = this.children.length - ((List)parts.get((Object)BundleCombinationTreeElement.ResultType.NONE)).size();
            if (atLeastPartialMatchCount == 0) {
                return BundleCombinationTreeNode.result(BundleCombinationTreeElement.ResultType.NONE, this);
            }
            if (((List)parts.get((Object)BundleCombinationTreeElement.ResultType.FULL)).size() == this.children.length) {
                return BundleCombinationTreeNode.result(BundleCombinationTreeElement.ResultType.FULL, this);
            }
            int partialMiddleCount = ((List)parts.get((Object)BundleCombinationTreeElement.ResultType.PARTIAL_MIDDLE)).size();
            if (partialMiddleCount > 1) {
                return BundleCombinationTreeNode.result(BundleCombinationTreeElement.ResultType.CONFLICT, this);
            }
            if (partialMiddleCount == 1) {
                if (atLeastPartialMatchCount > 1) {
                    return BundleCombinationTreeNode.result(BundleCombinationTreeElement.ResultType.CONFLICT, this);
                }
                return BundleCombinationTreeNode.result(BundleCombinationTreeElement.ResultType.PARTIAL_MIDDLE, BundleCombinationTreeNode.ta(newChildren));
            }
            assert (partialMiddleCount == 0);
            int partialTopCount = ((List)parts.get((Object)BundleCombinationTreeElement.ResultType.PARTIAL_TOP)).size();
            if (partialTopCount + (partialBottomCount = ((List)parts.get((Object)BundleCombinationTreeElement.ResultType.PARTIAL_BOTTOM)).size()) == 2) {
                if (partialTopCount == 0) {
                    ++partialTopCount;
                    --partialBottomCount;
                    ((List)parts.get((Object)BundleCombinationTreeElement.ResultType.PARTIAL_TOP)).add(((BundleCombinationTreeElement)((List)parts.get((Object)BundleCombinationTreeElement.ResultType.PARTIAL_BOTTOM)).remove(0)).reverse());
                } else if (partialBottomCount == 0) {
                    --partialTopCount;
                    ++partialBottomCount;
                    ((List)parts.get((Object)BundleCombinationTreeElement.ResultType.PARTIAL_BOTTOM)).add(((BundleCombinationTreeElement)((List)parts.get((Object)BundleCombinationTreeElement.ResultType.PARTIAL_TOP)).remove(1)).reverse());
                }
            }
            if (partialTopCount > 1) {
                return BundleCombinationTreeNode.result(BundleCombinationTreeElement.ResultType.CONFLICT, this);
            }
            if (partialBottomCount > 1) {
                return BundleCombinationTreeNode.result(BundleCombinationTreeElement.ResultType.CONFLICT, this);
            }
            if (partialBottomCount > 0) {
                if (partialTopCount > 0) {
                    BundleCombinationTreeElement.ResultType resultType2 = BundleCombinationTreeElement.ResultType.PARTIAL_MIDDLE;
                } else {
                    BundleCombinationTreeElement.ResultType resultType3 = BundleCombinationTreeElement.ResultType.PARTIAL_BOTTOM;
                }
            } else if (partialTopCount > 0) {
                BundleCombinationTreeElement.ResultType resultType4 = BundleCombinationTreeElement.ResultType.PARTIAL_TOP;
            } else {
                BundleCombinationTreeElement.ResultType resultType5 = this.children[0].checkContainment(bundle) != BundleCombinationTreeElement.ResultType.NONE ? BundleCombinationTreeElement.ResultType.PARTIAL_TOP : BundleCombinationTreeElement.ResultType.PARTIAL_BOTTOM;
            }
            boolean hasOnlyPartialBottom = partialBottomCount == atLeastPartialMatchCount;
            boolean hasOnlyPartialTop = partialTopCount == atLeastPartialMatchCount;
            boolean bl = needsNoSplit = hasOnlyPartialBottom || hasOnlyPartialTop;
            BundleCombinationTreeElement matchSubtree = needsNoSplit ? BundleCombinationTreeNode.tf(this.reverseAllowed, (List)parts.get((Object)BundleCombinationTreeElement.ResultType.PARTIAL_BOTTOM), ((List)parts.get((Object)BundleCombinationTreeElement.ResultType.FULL)).isEmpty() ? this.empty() : BundleCombinationTreeNode.li(BundleCombinationTreeNode.ta((List)parts.get((Object)BundleCombinationTreeElement.ResultType.FULL))), (List)parts.get((Object)BundleCombinationTreeElement.ResultType.PARTIAL_TOP)) : BundleCombinationTreeNode.tf(this.reverseAllowed, BundleCombinationTreeNode.split((List)parts.get((Object)BundleCombinationTreeElement.ResultType.PARTIAL_BOTTOM), bundle), ((List)parts.get((Object)BundleCombinationTreeElement.ResultType.FULL)).isEmpty() ? this.empty() : BundleCombinationTreeNode.li(BundleCombinationTreeNode.ta((List)parts.get((Object)BundleCombinationTreeElement.ResultType.FULL))), BundleCombinationTreeNode.split((List)parts.get((Object)BundleCombinationTreeElement.ResultType.PARTIAL_TOP), bundle));
            return BundleCombinationTreeNode.result((BundleCombinationTreeElement.ResultType)var8_25, BundleCombinationTreeNode.ta(var8_25 == BundleCombinationTreeElement.ResultType.PARTIAL_BOTTOM ? (List)parts.get((Object)BundleCombinationTreeElement.ResultType.NONE) : this.empty(), BundleCombinationTreeNode.li(matchSubtree), var8_25 != BundleCombinationTreeElement.ResultType.PARTIAL_BOTTOM ? (List)parts.get((Object)BundleCombinationTreeElement.ResultType.NONE) : this.empty()));
        }
        ArrayList<BundleCombinationTreeElement.BundleResult<T>> childResultsInOrder = new ArrayList<BundleCombinationTreeElement.BundleResult<T>>();
        BundleCombinationTreeElement<T>[] partialTopCount = this.children;
        int partialMiddleCount = this.children.length;
        int atLeastPartialMatchCount = 0;
        while (atLeastPartialMatchCount < partialMiddleCount) {
            BundleCombinationTreeElement<T> child = partialTopCount[atLeastPartialMatchCount];
            BundleCombinationTreeElement.BundleResult<T> childResult = child.addBundle(bundle);
            if (childResult.getType() == BundleCombinationTreeElement.ResultType.CONFLICT) {
                return BundleCombinationTreeNode.result(BundleCombinationTreeElement.ResultType.CONFLICT, this);
            }
            childResultsInOrder.add(childResult);
            ++atLeastPartialMatchCount;
        }
        boolean containsMultipleMatches = this.containsMultipleMatches(childResultsInOrder);
        ArrayList<BundleCombinationTreeElement<T>> newChildren = new ArrayList<BundleCombinationTreeElement<T>>();
        boolean hadMatches = false;
        boolean lastEndedWithMatches = false;
        boolean lastCouldHaveEndedWithMatches = false;
        for (BundleCombinationTreeElement.BundleResult bundleResult : childResultsInOrder) {
            switch (bundleResult.getType()) {
                case FULL: {
                    if (!lastEndedWithMatches && hadMatches) {
                        if (lastCouldHaveEndedWithMatches) {
                            this.reverseAndSplitLast(newChildren, bundle);
                        } else {
                            return BundleCombinationTreeNode.result(BundleCombinationTreeElement.ResultType.CONFLICT, this);
                        }
                    }
                    hadMatches = true;
                    lastEndedWithMatches = true;
                    newChildren.add(bundleResult.getTree());
                    break;
                }
                case NONE: {
                    lastEndedWithMatches = false;
                    lastCouldHaveEndedWithMatches = false;
                    newChildren.add(bundleResult.getTree());
                    break;
                }
                case PARTIAL_BOTTOM: {
                    if (lastEndedWithMatches) {
                        newChildren.addAll(bundleResult.getTree().reverse().split(bundle));
                        lastEndedWithMatches = false;
                        lastCouldHaveEndedWithMatches = false;
                        break;
                    }
                    if (hadMatches) {
                        if (lastCouldHaveEndedWithMatches) {
                            this.reverseAndSplitLast(newChildren, bundle);
                            newChildren.addAll(bundleResult.getTree().reverse().split(bundle));
                            lastEndedWithMatches = false;
                            lastCouldHaveEndedWithMatches = false;
                            break;
                        }
                        return BundleCombinationTreeNode.result(BundleCombinationTreeElement.ResultType.CONFLICT, this);
                    }
                    hadMatches = true;
                    lastEndedWithMatches = true;
                    if (containsMultipleMatches) {
                        newChildren.addAll(bundleResult.getTree().split(bundle));
                        break;
                    }
                    newChildren.add(bundleResult.getTree());
                    break;
                }
                case PARTIAL_TOP: {
                    if (hadMatches) {
                        if (!lastEndedWithMatches) {
                            if (lastCouldHaveEndedWithMatches) {
                                this.reverseAndSplitLast(newChildren, bundle);
                            } else {
                                return BundleCombinationTreeNode.result(BundleCombinationTreeElement.ResultType.CONFLICT, this);
                            }
                        }
                        lastCouldHaveEndedWithMatches = false;
                        newChildren.addAll(bundleResult.getTree().split(bundle));
                    } else {
                        hadMatches = true;
                        lastCouldHaveEndedWithMatches = true;
                        newChildren.add(bundleResult.getTree());
                    }
                    lastEndedWithMatches = false;
                    break;
                }
                case PARTIAL_MIDDLE: {
                    if (hadMatches) {
                        return BundleCombinationTreeNode.result(BundleCombinationTreeElement.ResultType.CONFLICT, this);
                    }
                    hadMatches = true;
                    lastEndedWithMatches = false;
                    lastCouldHaveEndedWithMatches = false;
                    newChildren.add(bundleResult.getTree());
                    break;
                }
                case CONFLICT: {
                    throw new AssertionError((Object)"should not happen, has been handled above");
                }
                default: {
                    throw new AssertionError((Object)("should not happen " + (Object)((Object)bundleResult.getType())));
                }
            }
        }
        BundleCombinationTreeElement.ResultType resultType6 = ((BundleCombinationTreeElement)newChildren.get(0)).checkContainment(bundle);
        BundleCombinationTreeElement.ResultType secondChildContainment = ((BundleCombinationTreeElement)newChildren.get(1)).checkContainment(bundle);
        if (resultType6 == BundleCombinationTreeElement.ResultType.PARTIAL_BOTTOM && secondChildContainment == BundleCombinationTreeElement.ResultType.NONE) {
            newChildren.set(0, ((BundleCombinationTreeElement)newChildren.get(0)).reverse());
            BundleCombinationTreeElement.ResultType resultType7 = BundleCombinationTreeElement.ResultType.PARTIAL_TOP;
        }
        boolean bl = startsWithMatches = var8_29 == BundleCombinationTreeElement.ResultType.FULL || var8_29 == BundleCombinationTreeElement.ResultType.PARTIAL_TOP;
        if (!hadMatches) {
            resultType = BundleCombinationTreeElement.ResultType.NONE;
        } else if (startsWithMatches && lastEndedWithMatches) {
            resultType = BundleCombinationTreeElement.ResultType.FULL;
        } else if (startsWithMatches) {
            resultType = BundleCombinationTreeElement.ResultType.PARTIAL_TOP;
        } else if (lastEndedWithMatches) {
            resultType = BundleCombinationTreeElement.ResultType.PARTIAL_BOTTOM;
        } else if (lastCouldHaveEndedWithMatches) {
            int lastIndex = newChildren.size() - 1;
            newChildren.set(lastIndex, ((BundleCombinationTreeElement)newChildren.get(lastIndex)).reverse());
            resultType = BundleCombinationTreeElement.ResultType.PARTIAL_BOTTOM;
        } else {
            resultType = BundleCombinationTreeElement.ResultType.PARTIAL_MIDDLE;
        }
        return BundleCombinationTreeNode.result(resultType, BundleCombinationTreeNode.tf(this.reverseAllowed, newChildren));
    }

    private boolean containsMultipleMatches(List<BundleCombinationTreeElement.BundleResult<T>> results) {
        int cnt = 0;
        for (BundleCombinationTreeElement.BundleResult<T> result : results) {
            if (result.getType() == BundleCombinationTreeElement.ResultType.NONE || ++cnt < 2) continue;
            return true;
        }
        return false;
    }

    private void reverseAndSplitLast(List<BundleCombinationTreeElement<T>> newChildren, SimpleSet<T> bundle) {
        int lastIndex = newChildren.size() - 1;
        BundleCombinationTreeElement<T> element = newChildren.remove(lastIndex);
        newChildren.addAll(element.reverse().split(bundle));
    }

    private List<BundleCombinationTreeElement<T>> empty() {
        return Collections.emptyList();
    }

    private static <S> List<BundleCombinationTreeElement<S>> li(BundleCombinationTreeElement<S> child) {
        return Collections.singletonList(child);
    }

    @SafeVarargs
    private static <S> BundleCombinationTreeElement<S> ta(List<? extends BundleCombinationTreeElement<S>> ... childrenLists) {
        ArrayList<? extends BundleCombinationTreeElement<S>> combined = new ArrayList<BundleCombinationTreeElement<S>>();
        List<? extends BundleCombinationTreeElement<S>>[] listArray = childrenLists;
        int n = childrenLists.length;
        int n2 = 0;
        while (n2 < n) {
            List<? extends BundleCombinationTreeElement<S>> list = listArray[n2];
            combined.addAll(list);
            ++n2;
        }
        return BundleCombinationTreeNode.ta(combined);
    }

    private static <S> BundleCombinationTreeElement<S> ta(List<? extends BundleCombinationTreeElement<S>> children) {
        if (children.size() == 1) {
            return children.get(0);
        }
        BundleCombinationTreeElement[] elements = new BundleCombinationTreeElement[children.size()];
        return new BundleCombinationTreeNode(children.toArray(elements), true, true);
    }

    @SafeVarargs
    private static <S> BundleCombinationTreeElement<S> tf(boolean reverseAllowed, List<? extends BundleCombinationTreeElement<S>> ... childrenLists) {
        ArrayList<? extends BundleCombinationTreeElement<S>> combined = new ArrayList<BundleCombinationTreeElement<S>>();
        List<? extends BundleCombinationTreeElement<S>>[] listArray = childrenLists;
        int n = childrenLists.length;
        int n2 = 0;
        while (n2 < n) {
            List<? extends BundleCombinationTreeElement<S>> list = listArray[n2];
            combined.addAll(list);
            ++n2;
        }
        return BundleCombinationTreeNode.tf(reverseAllowed, combined);
    }

    private static <S> BundleCombinationTreeElement<S> tf(boolean reverseAllowed, List<? extends BundleCombinationTreeElement<S>> children) {
        if (children.size() == 1) {
            return children.get(0);
        }
        BundleCombinationTreeElement[] elements = new BundleCombinationTreeElement[children.size()];
        return new BundleCombinationTreeNode(children.toArray(elements), false, reverseAllowed);
    }

    private static <S> BundleCombinationTreeElement.BundleResult<S> result(BundleCombinationTreeElement.ResultType type, BundleCombinationTreeElement<S> tree) {
        return new BundleCombinationTreeElement.BundleResult<S>(type, tree);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<T> getPossibleOrder(final Comparator<T> tieBreakingComparator) {
        void var4_7;
        ArrayList subItems = new ArrayList();
        BundleCombinationTreeElement<T>[] bundleCombinationTreeElementArray = this.children;
        int n = this.children.length;
        boolean n2 = false;
        while (var4_7 < n) {
            BundleCombinationTreeElement child = bundleCombinationTreeElementArray[var4_7];
            subItems.add(child.getPossibleOrder(tieBreakingComparator));
            ++var4_7;
        }
        if (this.reverseAllowed) {
            if (this.reorderingAllowed) {
                Collections.sort(subItems, new Comparator<List<T>>(){

                    @Override
                    public int compare(List<T> o1, List<T> o2) {
                        return tieBreakingComparator.compare(o1.get(0), o2.get(0));
                    }
                });
            } else {
                int comparisonResult = tieBreakingComparator.compare(((List)subItems.get(0)).get(0), ((List)subItems.get(subItems.size() - 1)).get(0));
                if (comparisonResult > 0) {
                    Collections.reverse(subItems);
                }
            }
        }
        ArrayList ret = new ArrayList();
        for (List list : subItems) {
            ret.addAll(list);
        }
        return ret;
    }

    public String toString() {
        String pref;
        String ts = Arrays.toString(this.children);
        String string = pref = this.reverseAllowed ? "" : "F";
        if (this.reorderingAllowed) {
            return String.valueOf(pref) + '{' + ts.substring(1, ts.length() - 1) + '}';
        }
        return String.valueOf(pref) + ts;
    }

    private static <S> List<? extends BundleCombinationTreeElement<S>> split(List<? extends BundleCombinationTreeElement<S>> list, SimpleSet<S> bundle) {
        assert (list.size() <= 1);
        return list.isEmpty() ? Collections.emptyList() : list.get(0).split(bundle);
    }

    @Override
    protected List<? extends BundleCombinationTreeElement<T>> split(SimpleSet<T> bundle) {
        if (this.reorderingAllowed) {
            ArrayList<BundleCombinationTreeElement<T>> ret = new ArrayList<BundleCombinationTreeElement<T>>();
            ArrayList<BundleCombinationTreeElement<T>> temp = new ArrayList<BundleCombinationTreeElement<T>>();
            BundleCombinationTreeElement.ResultType previousContainment = null;
            BundleCombinationTreeElement<T>[] bundleCombinationTreeElementArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                BundleCombinationTreeElement<T> child = bundleCombinationTreeElementArray[n2];
                BundleCombinationTreeElement.ResultType containment = child.checkContainment(bundle);
                if (!containment.equals((Object)previousContainment)) {
                    if (!temp.isEmpty()) {
                        ret.add(BundleCombinationTreeNode.ta(temp));
                        temp.clear();
                    }
                    previousContainment = containment;
                }
                if (containment.isPartial()) {
                    ret.addAll(child.split(bundle));
                } else {
                    temp.add(child);
                }
                ++n2;
            }
            if (!temp.isEmpty()) {
                ret.add(BundleCombinationTreeNode.ta(temp));
            }
            return ret;
        }
        ArrayList<BundleCombinationTreeElement<T>> ret = new ArrayList<BundleCombinationTreeElement<T>>();
        BundleCombinationTreeElement<T>[] bundleCombinationTreeElementArray = this.children;
        int n = this.children.length;
        int n3 = 0;
        while (n3 < n) {
            BundleCombinationTreeElement<T> child = bundleCombinationTreeElementArray[n3];
            if (child.checkContainment(bundle).isPartial()) {
                ret.addAll(child.split(bundle));
            } else {
                ret.add(child);
            }
            ++n3;
        }
        return ret;
    }

    @Override
    protected BundleCombinationTreeElement.ResultType checkContainment(SimpleSet<T> bundle) {
        boolean startsWithMatch = this.children[0].checkContainment(bundle).hasTopMatch();
        boolean endsWithMatch = this.children[this.children.length - 1].checkContainment(bundle).hasBottomMatch();
        if (startsWithMatch && !endsWithMatch) {
            return BundleCombinationTreeElement.ResultType.PARTIAL_TOP;
        }
        if (endsWithMatch && !startsWithMatch) {
            return BundleCombinationTreeElement.ResultType.PARTIAL_BOTTOM;
        }
        if (startsWithMatch && endsWithMatch) {
            return BundleCombinationTreeElement.ResultType.FULL;
        }
        BundleCombinationTreeElement<T>[] bundleCombinationTreeElementArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            BundleCombinationTreeElement<T> child = bundleCombinationTreeElementArray[n2];
            BundleCombinationTreeElement.ResultType childContainment = child.checkContainment(bundle);
            if (childContainment != BundleCombinationTreeElement.ResultType.NONE) {
                return BundleCombinationTreeElement.ResultType.PARTIAL_MIDDLE;
            }
            ++n2;
        }
        return BundleCombinationTreeElement.ResultType.NONE;
    }

    @Override
    protected BundleCombinationTreeElement<T> reverse() {
        return this.reverse(this.reverseAllowed);
    }

    private BundleCombinationTreeElement<T> reverse(boolean allowFurtherReversal) {
        if (!this.reverseAllowed) {
            throw new ReverseImpossibleException();
        }
        BundleCombinationTreeElement[] copy = new BundleCombinationTreeElement[this.children.length];
        int lastIndex = copy.length - 1;
        int i = 0;
        while (i <= lastIndex) {
            copy[i] = this.children[lastIndex - i].reverse();
            ++i;
        }
        return new BundleCombinationTreeNode<T>(copy, this.reorderingAllowed, allowFurtherReversal);
    }

    @Override
    protected BundleCombinationTreeElement<T> fixOrder(SimpleSet<T> center, SimpleSet<T> rest) {
        int minCenterIdx = Integer.MAX_VALUE;
        int maxCenterIdx = -1;
        int minRestIdx = Integer.MAX_VALUE;
        int maxRestIdx = -1;
        int i = 0;
        while (i < this.children.length) {
            BundleCombinationTreeElement<T> child = this.children[i];
            if (child.checkContainment(center) != BundleCombinationTreeElement.ResultType.NONE) {
                minCenterIdx = Math.min(minCenterIdx, i);
                maxCenterIdx = Math.max(maxCenterIdx, i);
            }
            if (child.checkContainment(rest) != BundleCombinationTreeElement.ResultType.NONE) {
                minRestIdx = Math.min(minRestIdx, i);
                maxRestIdx = Math.max(maxRestIdx, i);
            }
            ++i;
        }
        if (minCenterIdx == maxCenterIdx && minRestIdx == maxRestIdx && minCenterIdx == minRestIdx) {
            BundleCombinationTreeElement<T> newChild = this.children[minCenterIdx].fixOrder(center, rest);
            if (newChild == null) {
                return null;
            }
            BundleCombinationTreeElement<T>[] newChildren = Arrays.copyOf(this.children, this.children.length);
            newChildren[minCenterIdx] = newChild;
            return new BundleCombinationTreeNode<T>(newChildren, this.reorderingAllowed, this.reverseAllowed);
        }
        if (maxCenterIdx < minRestIdx) {
            return new BundleCombinationTreeNode<T>(this.children, this.reorderingAllowed, false);
        }
        if (minCenterIdx > maxRestIdx) {
            if (this.reverseAllowed) {
                try {
                    return this.reverse(false);
                }
                catch (ReverseImpossibleException e) {
                    return null;
                }
            }
            return null;
        }
        return null;
    }
}

