/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.telemetry;

import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.base.ReviewtoolException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public abstract class AbstractTelemetry {
    private String currentSessionId;
    private String currentUser;
    private long lastId;

    public AbstractTelemetry() {
        Logger.debug("create telemetry " + this.toString());
    }

    public void registerSession(String ticketKey, String user, String type, int round) {
        Logger.debug("registerSession " + user + ", " + ticketKey + ", " + type + round + " at " + this);
        if (user == null) {
            throw new AssertionError((Object)("user is null for ticket key " + ticketKey));
        }
        this.currentSessionId = String.valueOf(ticketKey) + "," + type + "," + round + "," + Long.toHexString(this.getSessionUid());
        this.currentUser = user;
    }

    private long getSessionUid() {
        long uid = System.currentTimeMillis();
        if (uid == this.lastId) {
            ++uid;
        }
        this.lastId = uid;
        return uid;
    }

    public void log(String eventType, Map<String, String> params) {
        this.putData(eventType, this.currentSessionId, this.currentUser, params);
    }

    protected static String obfuscate(String data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(data == null ? new byte[]{} : data.getBytes("UTF-8"));
            byte[] mdbytes = md.digest();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < mdbytes.length) {
                int b = 0xFF & mdbytes[i];
                if (b < 16) {
                    sb.append('0').append(Integer.toHexString(b));
                } else {
                    sb.append(Integer.toHexString(b));
                }
                ++i;
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new ReviewtoolException(e);
        }
    }

    protected abstract void putData(String var1, String var2, String var3, Map<String, String> var4);
}

