/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.model.api.IPositionInText;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class PositionLookupTable {
    private final List<Integer> charCountAtEndOfLine = new ArrayList<Integer>();

    private PositionLookupTable() {
    }

    public static PositionLookupTable create(Reader reader) throws IOException {
        int ch;
        PositionLookupTable ret = new PositionLookupTable();
        int charCount = 0;
        ret.charCountAtEndOfLine.add(0);
        while ((ch = reader.read()) >= 0) {
            ++charCount;
            if (ch != 10) continue;
            ret.charCountAtEndOfLine.add(charCount);
        }
        ret.charCountAtEndOfLine.add(charCount);
        return ret;
    }

    public int getCharsSinceFileStart(IPositionInText pos) {
        if (pos.getLine() <= 0) {
            return 0;
        }
        if (pos.getLine() >= this.charCountAtEndOfLine.size()) {
            return this.charCountAtEndOfLine.get(this.charCountAtEndOfLine.size() - 1);
        }
        return this.charCountAtEndOfLine.get(pos.getLine() - 1) + pos.getColumn() - 1;
    }
}

