/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.model.api.IDelta;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.IFragmentList;
import de.setsoftware.reviewtool.model.api.IPositionInText;
import de.setsoftware.reviewtool.model.api.IncompatibleFragmentException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class FragmentList
implements IFragmentList {
    private final List<IFragment> fragments = new LinkedList<IFragment>();

    public FragmentList() {
    }

    public FragmentList(IFragment fragment) {
        this.fragments.add(fragment);
    }

    @Override
    public List<? extends IFragment> getFragments() {
        return Collections.unmodifiableList(this.fragments);
    }

    @Override
    public boolean isEmpty() {
        return this.fragments.isEmpty();
    }

    @Override
    public void addFragment(IFragment fragment) throws IncompatibleFragmentException {
        IPositionInText posTo = fragment.getTo();
        ListIterator<IFragment> it = this.fragments.listIterator();
        while (it.hasNext()) {
            IFragment oldFragment = it.next();
            if (oldFragment.overlaps(fragment)) {
                throw new IncompatibleFragmentException();
            }
            if (posTo.compareTo(oldFragment.getFrom()) > 0) continue;
            it.previous();
            it.add(fragment);
            return;
        }
        this.fragments.add(fragment);
    }

    @Override
    public void coalesce() {
        ListIterator<IFragment> it = this.fragments.listIterator();
        IFragment fragment = null;
        while (it.hasNext()) {
            IFragment oldFragment = it.next();
            if (fragment == null) {
                fragment = oldFragment;
                it.remove();
                continue;
            }
            if (oldFragment.isAdjacentTo(fragment)) {
                it.remove();
                fragment = oldFragment.adjoin(fragment);
                continue;
            }
            it.remove();
            it.add(fragment);
            fragment = oldFragment;
        }
        if (fragment != null) {
            this.fragments.add(fragment);
        }
    }

    @Override
    public void addFragmentList(IFragmentList fragmentList) throws IncompatibleFragmentException {
        for (IFragment iFragment : fragmentList.getFragments()) {
            this.addFragment(iFragment);
        }
    }

    @Override
    public IFragmentList overlayBy(IFragment fragment) {
        FragmentList result = new FragmentList();
        try {
            result.addFragment(fragment);
        }
        catch (IncompatibleFragmentException e) {
            throw new ReviewtoolException(e);
        }
        IPositionInText posTo = fragment.getTo();
        ListIterator<IFragment> it = this.fragments.listIterator();
        while (it.hasNext()) {
            IFragment oldFragment = it.next();
            if (posTo.compareTo(oldFragment.getFrom()) <= 0) break;
            ListIterator<IFragment> fIt = result.fragments.listIterator();
            while (fIt.hasNext()) {
                IFragment f = fIt.next();
                IFragmentList rest = f.subtract(oldFragment);
                fIt.remove();
                for (IFragment iFragment : rest.getFragments()) {
                    fIt.add(iFragment);
                }
            }
        }
        try {
            result.addFragmentList(this);
        }
        catch (IncompatibleFragmentException e) {
            throw new ReviewtoolException(e);
        }
        return result;
    }

    @Override
    public IFragmentList subtract(IFragment fragment) {
        FragmentList result = new FragmentList();
        try {
            for (IFragment oldFragment : this.fragments) {
                if (oldFragment.overlaps(fragment)) {
                    result.addFragmentList(oldFragment.subtract(fragment));
                    continue;
                }
                result.addFragment(oldFragment);
            }
        }
        catch (IncompatibleFragmentException e) {
            throw new ReviewtoolException(e);
        }
        return result;
    }

    @Override
    public IFragmentList subtract(IFragmentList fragmentList) {
        IFragmentList result = this;
        for (IFragment iFragment : fragmentList.getFragments()) {
            result = result.subtract(iFragment);
        }
        return result;
    }

    @Override
    public IFragmentList move(IPositionInText pos, IDelta delta) {
        FragmentList result = new FragmentList();
        for (IFragment fragment : this.fragments) {
            if (fragment.getFrom().compareTo(pos) <= 0) {
                result.fragments.add(fragment);
                continue;
            }
            result.fragments.add(fragment.adjust(delta));
        }
        return result;
    }
}

