/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.Multimap;
import de.setsoftware.reviewtool.base.PartialOrderAlgorithms;
import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.model.api.ILocalRevision;
import de.setsoftware.reviewtool.model.api.IRepoRevision;
import de.setsoftware.reviewtool.model.api.IRepository;
import de.setsoftware.reviewtool.model.api.IRevision;
import de.setsoftware.reviewtool.model.api.IRevisionVisitorE;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.api.IUnknownRevision;
import de.setsoftware.reviewtool.model.api.IWorkingCopy;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;

public class FileInRevision
implements IRevisionedFile {
    private static final long serialVersionUID = 1849848257016731168L;
    private final String path;
    private final IRevision revision;

    FileInRevision(String path, IRevision revision) {
        this.path = path;
        this.revision = revision;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public IRevision getRevision() {
        return this.revision;
    }

    @Override
    public IRepository getRepository() {
        return this.revision.getRepository();
    }

    @Override
    public byte[] getContents() throws Exception {
        return this.revision.accept(new IRevisionVisitorE<byte[], Exception>(){

            @Override
            public byte[] handleLocalRevision(ILocalRevision revision) throws IOException {
                File file = FileInRevision.this.toLocalPath(revision.getWorkingCopy());
                if (!file.exists()) {
                    return new byte[0];
                }
                return Files.readAllBytes(file.toPath());
            }

            @Override
            public byte[] handleRepoRevision(IRepoRevision<?> revision) throws Exception {
                return FileInRevision.this.getRepository().getFileContents(FileInRevision.this.path, revision);
            }

            @Override
            public byte[] handleUnknownRevision(IUnknownRevision revision) throws Exception {
                return new byte[0];
            }
        });
    }

    public String toString() {
        return String.valueOf(this.path) + "@" + this.revision;
    }

    @Override
    public File toLocalPath(IWorkingCopy wc) {
        File absolutePathInWc = wc.toAbsolutePathInWc(this.path);
        if (absolutePathInWc != null) {
            return absolutePathInWc;
        }
        throw new ReviewtoolException("File " + this + " cannot be mapped to working copy at " + wc.getLocalRoot());
    }

    public int hashCode() {
        return this.path.hashCode() ^ this.revision.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileInRevision)) {
            return false;
        }
        FileInRevision f = (FileInRevision)o;
        return this.path.equals(f.path) && this.revision.equals(f.revision);
    }

    @Override
    public boolean le(IRevisionedFile other) {
        IRevision otherRevision = other.getRevision();
        if (this.revision.le(otherRevision)) {
            if (otherRevision.le(this.revision)) {
                return this.path.compareTo(other.getPath()) <= 0;
            }
            return true;
        }
        return false;
    }

    public static List<IRevisionedFile> sortByRevision(Collection<? extends IRevisionedFile> toSort) {
        if (toSort.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<IRevision> remainingRevisions = new LinkedHashSet<IRevision>();
        Multimap<IRevision, IRevisionedFile> filesForRevision = new Multimap<IRevision, IRevisionedFile>();
        for (IRevisionedFile iRevisionedFile : toSort) {
            remainingRevisions.add(iRevisionedFile.getRevision());
            filesForRevision.put(iRevisionedFile.getRevision(), iRevisionedFile);
        }
        ArrayList<IRevisionedFile> arrayList = new ArrayList<IRevisionedFile>();
        while (!remainingRevisions.isEmpty()) {
            IRevision smallest = (IRevision)PartialOrderAlgorithms.getSomeMinimum(remainingRevisions);
            ArrayList revs = new ArrayList(filesForRevision.get(smallest));
            Collections.sort(revs, new Comparator<IRevisionedFile>(){

                @Override
                public int compare(IRevisionedFile o1, IRevisionedFile o2) {
                    return o1.getPath().compareTo(o2.getPath());
                }
            });
            arrayList.addAll(revs);
            remainingRevisions.remove(smallest);
        }
        return arrayList;
    }
}

