/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.model.api.IFileHistoryEdge;
import de.setsoftware.reviewtool.model.api.IFileHistoryNode;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryEdge;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryGraph;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryNodeProxy;
import de.setsoftware.reviewtool.model.changestructure.ProxyableFileHistoryEdge;
import de.setsoftware.reviewtool.model.changestructure.ProxyableFileHistoryNode;
import java.util.LinkedHashSet;
import java.util.Set;

final class FileHistoryNode
extends ProxyableFileHistoryNode {
    private static final long serialVersionUID = 7938054839176372206L;
    private final FileHistoryGraph graph;
    private final IRevisionedFile file;
    private final Set<ProxyableFileHistoryEdge> ancestors;
    private final Set<ProxyableFileHistoryEdge> descendants;
    private IFileHistoryNode.Type type;

    FileHistoryNode(FileHistoryGraph graph, IRevisionedFile file, IFileHistoryNode.Type type) {
        this.graph = graph;
        this.file = file;
        this.ancestors = new LinkedHashSet<ProxyableFileHistoryEdge>();
        this.descendants = new LinkedHashSet<ProxyableFileHistoryEdge>();
        this.type = type;
    }

    FileHistoryNode(FileHistoryGraph graph, IRevisionedFile file, Set<ProxyableFileHistoryEdge> ancestors, Set<ProxyableFileHistoryEdge> descendants, IFileHistoryNode.Type type) {
        this.graph = graph;
        this.file = file;
        this.ancestors = ancestors;
        this.descendants = descendants;
        this.type = type;
    }

    @Override
    public FileHistoryGraph getGraph() {
        return this.graph;
    }

    @Override
    public IRevisionedFile getFile() {
        return this.file;
    }

    @Override
    public boolean isRoot() {
        return this.ancestors.isEmpty();
    }

    public Set<ProxyableFileHistoryEdge> getAncestors() {
        return this.ancestors;
    }

    public Set<ProxyableFileHistoryEdge> getDescendants() {
        return this.descendants;
    }

    @Override
    public IFileHistoryNode.Type getType() {
        return this.type;
    }

    @Override
    public boolean isConfirmed() {
        return !this.type.equals((Object)IFileHistoryNode.Type.UNCONFIRMED);
    }

    @Override
    public boolean isCopyTarget() {
        for (ProxyableFileHistoryEdge ancestorEdge : this.ancestors) {
            if (ancestorEdge.getType().equals((Object)IFileHistoryEdge.Type.COPY)) {
                return true;
            }
            if (!this.type.equals((Object)IFileHistoryNode.Type.DELETED) || !ancestorEdge.getType().equals((Object)IFileHistoryEdge.Type.COPY_DELETED)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof FileHistoryNode) {
            FileHistoryNode other = (FileHistoryNode)o;
            return this.file.equals(other.file) && this.type.equals((Object)other.type);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    void addAncestor(ProxyableFileHistoryEdge ancestor) {
        this.ancestors.add(ancestor);
    }

    @Override
    void removeAncestor(ProxyableFileHistoryEdge ancestor) {
        this.ancestors.remove(ancestor);
    }

    @Override
    void addDescendant(ProxyableFileHistoryNode descendant, IFileHistoryEdge.Type type) {
        FileHistoryEdge edge = new FileHistoryEdge(this.graph, this, descendant, type);
        this.descendants.add(edge);
        descendant.addAncestor(edge);
    }

    @Override
    void makeDeleted() {
        assert (!this.type.equals((Object)IFileHistoryNode.Type.DELETED));
        this.type = IFileHistoryNode.Type.DELETED;
        for (ProxyableFileHistoryEdge ancestorEdge : this.ancestors) {
            if (!ancestorEdge.getType().equals((Object)IFileHistoryEdge.Type.COPY)) continue;
            ancestorEdge.setType(IFileHistoryEdge.Type.COPY_DELETED);
        }
    }

    @Override
    void makeReplaced() {
        assert (this.type.equals((Object)IFileHistoryNode.Type.DELETED));
        this.type = IFileHistoryNode.Type.REPLACED;
    }

    @Override
    void makeConfirmed() {
        assert (this.type.equals((Object)IFileHistoryNode.Type.UNCONFIRMED));
        this.type = IFileHistoryNode.Type.CHANGED;
    }

    @Override
    void makeAdded() {
        assert (this.type.equals((Object)IFileHistoryNode.Type.UNCONFIRMED));
        this.type = IFileHistoryNode.Type.ADDED;
    }

    protected final Object writeReplace() {
        return new FileHistoryNodeProxy(this.graph, this.file, this.ancestors, this.descendants, this.type);
    }
}

