/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.model.api.IClassification;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class Classification
implements IClassification {
    public static final IClassification[] NONE = new IClassification[0];
    private final int number;
    private final String name;
    private final boolean mergeAsAnd;

    public Classification(int number, String name, boolean mergeAsAnd) {
        this.number = number;
        this.name = name;
        this.mergeAsAnd = mergeAsAnd;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public boolean mergeAsAnd() {
        return this.mergeAsAnd;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Classification)) {
            return false;
        }
        Classification c = (Classification)o;
        return this.name.equals(c.name);
    }

    public String toString() {
        return this.name;
    }

    public static IClassification[] merge(IClassification[] s1, IClassification[] s2) {
        IClassification cl;
        LinkedHashSet<IClassification> ret = new LinkedHashSet<IClassification>();
        IClassification[] iClassificationArray = s1;
        int n = s1.length;
        int n2 = 0;
        while (n2 < n) {
            cl = iClassificationArray[n2];
            if (cl.mergeAsAnd()) {
                if (Arrays.asList(s2).contains(cl)) {
                    ret.add(cl);
                }
            } else {
                ret.add(cl);
            }
            ++n2;
        }
        iClassificationArray = s2;
        n = s2.length;
        n2 = 0;
        while (n2 < n) {
            cl = iClassificationArray[n2];
            if (!cl.mergeAsAnd()) {
                ret.add(cl);
            }
            ++n2;
        }
        if (ret.isEmpty()) {
            return NONE;
        }
        return ret.toArray(new IClassification[ret.size()]);
    }
}

