/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.model.api.ChangeSourceException;
import de.setsoftware.reviewtool.model.api.FileChangeType;
import de.setsoftware.reviewtool.model.api.IBinaryChange;
import de.setsoftware.reviewtool.model.api.IChange;
import de.setsoftware.reviewtool.model.api.IChangeSource;
import de.setsoftware.reviewtool.model.api.IFileHistoryEdge;
import de.setsoftware.reviewtool.model.api.IFileHistoryNode;
import de.setsoftware.reviewtool.model.api.IHunk;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.api.IWorkingCopy;
import de.setsoftware.reviewtool.model.changestructure.ChangestructureFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class AbstractChangeSource
implements IChangeSource {
    private static final String KEY_PLACEHOLDER = "${key}";
    private final Map<File, Set<File>> projectsPerWcMap = new LinkedHashMap<File, Set<File>>();
    private final String logMessagePattern;
    private final long maxTextDiffThreshold;

    protected AbstractChangeSource(String logMessagePattern, long maxTextDiffThreshold) {
        this.logMessagePattern = logMessagePattern;
        this.createPatternForKey("TEST-123");
        this.maxTextDiffThreshold = maxTextDiffThreshold;
    }

    protected Pattern createPatternForKey(String key) {
        return Pattern.compile(this.logMessagePattern.replace(KEY_PLACEHOLDER, Pattern.quote(key)), 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addProject(File projectRoot) throws ChangeSourceException {
        File wcRoot = this.determineWorkingCopyRoot(projectRoot);
        if (wcRoot == null) {
            return false;
        }
        boolean wcCreated = false;
        Map<File, Set<File>> map = this.projectsPerWcMap;
        synchronized (map) {
            Set<File> projects = this.projectsPerWcMap.get(wcRoot);
            if (projects == null) {
                projects = new LinkedHashSet<File>();
                this.projectsPerWcMap.put(wcRoot, projects);
                wcCreated = true;
            }
            projects.add(projectRoot);
        }
        if (wcCreated) {
            this.workingCopyAdded(wcRoot);
        }
        return true;
    }

    protected abstract void workingCopyAdded(File var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProject(File projectRoot) throws ChangeSourceException {
        File wcRoot = this.determineWorkingCopyRoot(projectRoot);
        if (wcRoot != null) {
            boolean wcHasProjects = true;
            Map<File, Set<File>> map = this.projectsPerWcMap;
            synchronized (map) {
                Set<File> projects = this.projectsPerWcMap.get(wcRoot);
                if (projects != null) {
                    projects.remove(projectRoot);
                    if (projects.isEmpty()) {
                        this.projectsPerWcMap.remove(wcRoot);
                        wcHasProjects = false;
                    }
                }
            }
            if (!wcHasProjects) {
                this.workingCopyRemoved(wcRoot);
            }
        }
    }

    protected abstract void workingCopyRemoved(File var1);

    protected List<? extends IChange> determineChangesInFile(IWorkingCopy wc, IFileHistoryNode node) throws Exception {
        boolean newFileContentsUseTextualDiff = this.isUseTextualDiff(node.getFile());
        ArrayList<IChange> changes = new ArrayList<IChange>();
        for (IFileHistoryEdge iFileHistoryEdge : node.getAncestors()) {
            IFileHistoryNode ancestor = iFileHistoryEdge.getAncestor();
            boolean oldFileContentsUseTextualDiff = this.isUseTextualDiff(ancestor.getFile());
            if (oldFileContentsUseTextualDiff && newFileContentsUseTextualDiff) {
                List<? extends IHunk> hunks = iFileHistoryEdge.getDiff().getHunks();
                for (IHunk iHunk : hunks) {
                    changes.add(ChangestructureFactory.createTextualChangeHunk(wc, this.mapChangeType(node.getType()), iHunk.getSource(), iHunk.getTarget()));
                }
                continue;
            }
            changes.add(this.createBinaryChange(wc, node, ancestor));
        }
        if (changes.isEmpty()) {
            Logger.debug("no changes found in file " + node);
        }
        return changes;
    }

    private IBinaryChange createBinaryChange(IWorkingCopy wc, IFileHistoryNode node, IFileHistoryNode ancestor) {
        IRevisionedFile oldFileInfo = ChangestructureFactory.createFileInRevision(ancestor.getFile().getPath(), ancestor.getFile().getRevision());
        return ChangestructureFactory.createBinaryChange(wc, this.mapChangeType(node.getType()), oldFileInfo, node.getFile());
    }

    private FileChangeType mapChangeType(IFileHistoryNode.Type type) {
        switch (type) {
            case ADDED: {
                return FileChangeType.ADDED;
            }
            case DELETED: {
                return FileChangeType.DELETED;
            }
        }
        return FileChangeType.OTHER;
    }

    protected final boolean isUseTextualDiff(IRevisionedFile file) throws Exception {
        if (file.getPath().endsWith(".pdf")) {
            return false;
        }
        byte[] newFileContent = file.getContents();
        return !AbstractChangeSource.contentLooksBinary(newFileContent) && (long)newFileContent.length <= this.maxTextDiffThreshold;
    }

    private static boolean contentLooksBinary(byte[] fileContent) {
        if (fileContent.length == 0) {
            return false;
        }
        int max = Math.min(128, fileContent.length);
        int i = 0;
        while (i < max) {
            if (AbstractChangeSource.isStrangeChar(fileContent[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isStrangeChar(byte b) {
        return b != 10 && b != 13 && b != 9 && b < 32 && b >= 0;
    }
}

