/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.diffalgorithms;

class StartLineSuitability
implements Comparable<StartLineSuitability> {
    private final Type type;
    private final int indentation;
    private final int markerGoodness;

    private StartLineSuitability(Type type, int countIndent, int markerGoodness) {
        this.type = type;
        this.indentation = countIndent;
        this.markerGoodness = markerGoodness;
    }

    public static StartLineSuitability determineFor(String line) {
        int markerGoodness;
        Type type;
        String lineTrim = line.trim();
        if (lineTrim.startsWith("/*")) {
            type = Type.LINE_WITH_START_MARKER;
            markerGoodness = 3;
        } else if (lineTrim.startsWith("@")) {
            type = Type.LINE_WITH_START_MARKER;
            markerGoodness = 2;
        } else if (lineTrim.endsWith("{")) {
            type = Type.LINE_WITH_START_MARKER;
            markerGoodness = 1;
        } else if (lineTrim.startsWith("</")) {
            type = Type.LINE_WITH_END_MARKER;
            markerGoodness = 1;
        } else if (lineTrim.startsWith("}")) {
            type = Type.LINE_WITH_END_MARKER;
            markerGoodness = 1;
        } else if (lineTrim.startsWith(")")) {
            type = Type.LINE_WITH_END_MARKER;
            markerGoodness = 2;
        } else if (lineTrim.startsWith("]")) {
            type = Type.LINE_WITH_END_MARKER;
            markerGoodness = 3;
        } else if (lineTrim.isEmpty()) {
            type = Type.EMPTY_LINE;
            markerGoodness = 0;
        } else {
            type = Type.OTHER_LINE;
            markerGoodness = 0;
        }
        return new StartLineSuitability(type, StartLineSuitability.countIndent(line), markerGoodness);
    }

    private static int countIndent(String line) {
        int cnt = 0;
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (ch == ' ') {
                ++cnt;
            } else {
                if (ch != '\t') break;
                cnt += 4;
            }
            ++n2;
        }
        return cnt;
    }

    @Override
    public int compareTo(StartLineSuitability o) {
        int cmp = Integer.compare(this.type.ordinal(), o.type.ordinal());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(o.indentation, this.indentation);
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(this.markerGoodness, o.markerGoodness);
    }

    public boolean equals(Object o) {
        if (!(o instanceof StartLineSuitability)) {
            return false;
        }
        StartLineSuitability s = (StartLineSuitability)o;
        return this.compareTo(s) == 0;
    }

    public int hashCode() {
        return this.type.hashCode() + this.indentation + this.markerGoodness;
    }

    private static enum Type {
        LINE_WITH_END_MARKER,
        EMPTY_LINE,
        OTHER_LINE,
        LINE_WITH_START_MARKER;

    }
}

