/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.diffalgorithms;

import de.setsoftware.reviewtool.diffalgorithms.DiffNode;
import de.setsoftware.reviewtool.diffalgorithms.OneFileView;
import de.setsoftware.reviewtool.diffalgorithms.PathNode;
import de.setsoftware.reviewtool.diffalgorithms.Snake;

public class MyersDiff {
    public PathNode buildPath(OneFileView<String> orig, OneFileView<String> rev) {
        int commonSuffixLength = this.determineCommonSuffixLength(orig, rev);
        int n = orig.getItemCount() - commonSuffixLength;
        int m = rev.getItemCount() - commonSuffixLength;
        int max = n + m + 1;
        int size = 1 + 2 * max;
        int middle = size / 2;
        PathNode[] diagonal = new PathNode[size];
        diagonal[middle + 1] = new Snake(0, -1, null);
        int d = 0;
        while (d < max) {
            int k = -d;
            while (k <= d) {
                int i;
                int kmiddle = middle + k;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                PathNode prev = null;
                if (k == -d || k != d && diagonal[kminus].getPosOld() < diagonal[kplus].getPosOld()) {
                    i = diagonal[kplus].getPosOld();
                    prev = diagonal[kplus];
                } else {
                    i = diagonal[kminus].getPosOld() + 1;
                    prev = diagonal[kminus];
                }
                diagonal[kminus] = null;
                int j = i - k;
                PathNode node = new DiffNode(i, j, prev);
                while (i < n && j < m && orig.getItem(i).equals(rev.getItem(j))) {
                    ++i;
                    ++j;
                }
                if (i > node.getPosOld()) {
                    node = new Snake(i, j, node);
                }
                diagonal[kmiddle] = node;
                if (i >= n && j >= m) {
                    return this.addCommonSuffixSnake(diagonal[kmiddle], commonSuffixLength);
                }
                k += 2;
            }
            diagonal[middle + d - 1] = null;
            ++d;
        }
        throw new Error("could not find a diff path");
    }

    private PathNode addCommonSuffixSnake(PathNode pathNode, int commonSuffixLength) {
        if (pathNode.isSnake()) {
            pathNode.enlargeBy(commonSuffixLength);
            return pathNode;
        }
        return new Snake(pathNode.getPosOld() + commonSuffixLength, pathNode.getPosNew() + commonSuffixLength, pathNode);
    }

    private int determineCommonSuffixLength(OneFileView<String> oldFile, OneFileView<String> newFile) {
        int suffixLength = 0;
        int max = Math.min(oldFile.getItemCount(), newFile.getItemCount());
        while (suffixLength < max) {
            if (!oldFile.getItemFromEnd(suffixLength).equals(newFile.getItemFromEnd(suffixLength))) {
                return suffixLength;
            }
            ++suffixLength;
        }
        return suffixLength;
    }
}

