/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.diffalgorithms;

import de.setsoftware.reviewtool.diffalgorithms.ItemMatching;
import de.setsoftware.reviewtool.diffalgorithms.LongestCommonSubsequence;
import de.setsoftware.reviewtool.diffalgorithms.OneFileView;
import java.util.Collections;
import java.util.List;

final class ContentView<T> {
    private final OneFileView<T> file1;
    private final OneFileView<T> file2;

    ContentView(OneFileView<T> file1, OneFileView<T> file2) {
        this.file1 = file1;
        this.file2 = file2;
    }

    private ContentView<T> stripCommonPrefix(ItemMatching<T> matchingBuffer) {
        int minSize = Math.min(this.file1.getItemCount(), this.file2.getItemCount());
        int commonPrefixLength = 0;
        int i = 0;
        while (i < minSize) {
            if (!this.file1.getItem(i).equals(this.file2.getItem(i))) break;
            matchingBuffer.match(this.file1, i, this.file2, i);
            ++commonPrefixLength;
            ++i;
        }
        return new ContentView<T>(this.file1.stripPrefix(commonPrefixLength), this.file2.stripPrefix(commonPrefixLength));
    }

    private ContentView<T> stripCommonSuffix(ItemMatching<T> matchingBuffer) {
        int minSize = Math.min(this.file1.getItemCount(), this.file2.getItemCount());
        int commonPrefixLength = 0;
        int i = 0;
        while (i < minSize) {
            if (!this.file1.getItemFromEnd(i).equals(this.file2.getItemFromEnd(i))) break;
            matchingBuffer.match(this.file1, this.file1.getItemCount() - i - 1, this.file2, this.file2.getItemCount() - i - 1);
            ++commonPrefixLength;
            ++i;
        }
        return new ContentView<T>(this.file1.stripSuffix(commonPrefixLength), this.file2.stripSuffix(commonPrefixLength));
    }

    private ContentView<T> stripCommonPrefixAndSuffix(ItemMatching<T> matchingBuffer) {
        return super.stripCommonSuffix(matchingBuffer);
    }

    public boolean isEmpty() {
        return this.file1.getItemCount() == 0 && this.file2.getItemCount() == 0;
    }

    OneFileView<T> getFile1() {
        return this.file1;
    }

    OneFileView<T> getFile2() {
        return this.file2;
    }

    List<ContentView<T>> lcsDiff() {
        ItemMatching<T> matching = new ItemMatching<T>(this.file1, this.file2);
        ContentView<T> stripped = this.stripCommonPrefixAndSuffix(matching);
        if (stripped.isEmpty()) {
            return Collections.emptyList();
        }
        LongestCommonSubsequence.determineLcs(stripped.file1, stripped.file2, matching);
        return matching.determineNonIdentifiedFragments();
    }
}

