/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.base.tree;

import de.setsoftware.reviewtool.base.tree.AbstractTreeNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class UnorderedTreeNode<K, V>
extends AbstractTreeNode<K, V, UnorderedTreeNode<K, V>> {
    private static final long serialVersionUID = -1870841040919574919L;
    private final HashMap<K, UnorderedTreeNode<K, V>> children = new HashMap();

    private UnorderedTreeNode(UnorderedTreeNode<K, V> parent, V value) {
        super(parent, value);
    }

    public static <K, V> UnorderedTreeNode<K, V> createRoot(V value) {
        return new UnorderedTreeNode<K, V>(null, value);
    }

    @Override
    public UnorderedTreeNode<K, V> getNode(K key) {
        return this.children.get(key);
    }

    @Override
    public UnorderedTreeNode<K, V> putValue(K key, V value) {
        UnorderedTreeNode<K, V> child = this.children.get(key);
        if (child == null) {
            child = new UnorderedTreeNode<K, V>(this, value);
            this.children.put(key, child);
        } else {
            child.setValue(value);
        }
        return child;
    }

    @Override
    public Set<Map.Entry<K, UnorderedTreeNode<K, V>>> getEntries() {
        return Collections.unmodifiableSet(this.children.entrySet());
    }

    @Override
    public void removeNode(UnorderedTreeNode<K, V> childNode) {
        this.children.values().remove(childNode);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof UnorderedTreeNode) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    protected UnorderedTreeNode<K, V> getSelf() {
        return this;
    }
}

