/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.base;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class WeakListeners<T> {
    private final List<WeakReference<T>> listeners = new ArrayList<WeakReference<T>>();

    public List<T> getListeners() {
        ArrayList ret = new ArrayList();
        Iterator<WeakReference<T>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            Object s = iter.next().get();
            if (s != null) {
                ret.add(s);
                continue;
            }
            iter.remove();
        }
        return ret;
    }

    public void notifyListeners(Consumer<T> consumer) {
        RuntimeException caught = null;
        for (T listener : this.getListeners()) {
            try {
                consumer.accept(listener);
            }
            catch (RuntimeException e) {
                if (caught == null) {
                    caught = e;
                    continue;
                }
                caught.addSuppressed(e);
            }
        }
        if (caught != null) {
            throw caught;
        }
    }

    public void add(T listener) {
        this.listeners.add(new WeakReference<T>(listener));
    }

    public void remove(T toRemove) {
        Iterator<WeakReference<T>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            Object s = iter.next().get();
            if (toRemove != s) continue;
            iter.remove();
        }
    }
}

