/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering;

import de.setsoftware.reviewtool.base.Pair;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.IHunk;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.changestructure.Stop;
import de.setsoftware.reviewtool.ordering.ChangePart;
import de.setsoftware.reviewtool.ordering.HierarchyExplicitness;
import de.setsoftware.reviewtool.ordering.OrderingInfo;
import de.setsoftware.reviewtool.ordering.OrderingInfoImpl;
import de.setsoftware.reviewtool.ordering.RelationMatcher;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.TourCalculator;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.TourCalculatorControl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class TokenSimilarityRelation
implements RelationMatcher {
    private static final double JACCARD_THRESHOLD = 0.7;

    @Override
    public Collection<? extends OrderingInfo> determineMatches(List<ChangePart> changeParts, TourCalculatorControl control) throws InterruptedException {
        ArrayList<Pair> tokenSets = new ArrayList<Pair>(changeParts.size());
        for (ChangePart c : changeParts) {
            Set<String> tokens;
            if (c.isFullyIrrelevantForReview() || (tokens = this.determineTokenSet(c)).isEmpty()) continue;
            tokenSets.add(Pair.create((Object)c, tokens));
        }
        TourCalculator.checkInterruption((TourCalculatorControl)control);
        ArrayList<Pair> similarities = new ArrayList<Pair>();
        int i = 0;
        while (i < tokenSets.size()) {
            int j = i + 1;
            while (j < tokenSets.size()) {
                double sim = this.jaccardSimilarity((Set)((Pair)tokenSets.get(i)).getSecond(), (Set)((Pair)tokenSets.get(j)).getSecond());
                if (sim > 0.7) {
                    similarities.add(Pair.create((Object)sim, (Object)OrderingInfoImpl.unordered(HierarchyExplicitness.NONE, null, Arrays.asList((ChangePart)((Pair)tokenSets.get(i)).getFirst(), (ChangePart)((Pair)tokenSets.get(j)).getFirst()))));
                }
                ++j;
            }
            ++i;
        }
        TourCalculator.checkInterruption((TourCalculatorControl)control);
        Collections.sort(similarities, new Comparator<Pair<Double, OrderingInfo>>(){

            @Override
            public int compare(Pair<Double, OrderingInfo> o1, Pair<Double, OrderingInfo> o2) {
                return Double.compare((Double)o2.getFirst(), (Double)o1.getFirst());
            }
        });
        ArrayList<OrderingInfo> ret = new ArrayList<OrderingInfo>();
        for (Pair p : similarities) {
            ret.add((OrderingInfo)p.getSecond());
        }
        return ret;
    }

    private Set<String> determineTokenSet(ChangePart changePart) {
        HashSet<String> tokens = new HashSet<String>();
        for (Stop s : changePart.getStops()) {
            IFragment fragment = s.getOriginalMostRecentFragment();
            if (fragment == null) continue;
            this.parseTokens(tokens, fragment.getContent());
            IRevisionedFile oldestFile = this.determineOldestFile(s);
            if (oldestFile == null) continue;
            for (IHunk hunk : s.getContentFor(oldestFile)) {
                this.parseTokens(tokens, hunk.getSource().getContent());
            }
        }
        return tokens;
    }

    private IRevisionedFile determineOldestFile(Stop s) {
        LinkedHashSet toSet = new LinkedHashSet(s.getHistory().values());
        for (IRevisionedFile candidate : s.getHistory().keySet()) {
            if (toSet.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    private void parseTokens(Set<String> tokens, String content) {
        StringBuilder curToken = new StringBuilder();
        char[] cArray = content.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isJavaIdentifierPart(ch)) {
                curToken.append(ch);
            } else if (curToken.length() > 0) {
                tokens.add(curToken.toString());
                curToken.setLength(0);
            }
            ++n2;
        }
        if (curToken.length() > 0) {
            tokens.add(curToken.toString());
        }
    }

    private double jaccardSimilarity(Set<String> s1, Set<String> s2) {
        if (s2.size() < s1.size()) {
            return this.jaccardSimilarity(s2, s1);
        }
        int intersectionSize = 0;
        int unionSize = s1.size() + s2.size();
        for (String s : s1) {
            if (!s2.contains(s)) continue;
            ++intersectionSize;
            --unionSize;
        }
        return (double)intersectionSize / (double)unionSize;
    }
}

