/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering;

import de.setsoftware.reviewtool.ordering.ChangePart;
import de.setsoftware.reviewtool.ordering.HierarchyExplicitness;
import de.setsoftware.reviewtool.ordering.OrderingInfo;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.MatchSet;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.StarMatchSet;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.UnorderedMatchSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OrderingInfoImpl
implements OrderingInfo {
    private final HierarchyExplicitness explicit;
    private final String description;
    private final MatchSet<ChangePart> matchSet;

    private OrderingInfoImpl(HierarchyExplicitness explicit, String description, MatchSet<ChangePart> matchSet) {
        this.explicit = explicit;
        this.description = description;
        this.matchSet = matchSet;
    }

    public static OrderingInfo unordered(HierarchyExplicitness explicit, String description, Collection<ChangePart> changeParts) {
        return new OrderingInfoImpl(explicit, description, (MatchSet<ChangePart>)new UnorderedMatchSet(changeParts));
    }

    public static OrderingInfo star(HierarchyExplicitness explicit, String description, ChangePart center, Collection<ChangePart> otherChangeParts) {
        HashSet<ChangePart> combined = new HashSet<ChangePart>(otherChangeParts);
        combined.add(center);
        return new OrderingInfoImpl(explicit, description, (MatchSet<ChangePart>)new StarMatchSet((Object)center, combined));
    }

    public static OrderingInfo bigStar(HierarchyExplicitness explicit, String description, Set<ChangePart> center, Collection<ChangePart> otherChangeParts) {
        HashSet<ChangePart> combined = new HashSet<ChangePart>(otherChangeParts);
        combined.addAll(center);
        return new OrderingInfoImpl(explicit, description, (MatchSet<ChangePart>)new StarMatchSet(center, combined));
    }

    @Override
    public MatchSet<ChangePart> getMatchSet() {
        return this.matchSet;
    }

    @Override
    public HierarchyExplicitness getExplicitness() {
        return this.explicit;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return this.matchSet.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OrderingInfoImpl)) {
            return false;
        }
        OrderingInfoImpl m = (OrderingInfoImpl)o;
        if (this.explicit != m.explicit) {
            return false;
        }
        if (this.explicit != HierarchyExplicitness.NONE && !this.description.equals(m.description)) {
            return false;
        }
        return this.matchSet.equals(m.matchSet);
    }

    public String toString() {
        return (Object)((Object)this.explicit) + "," + this.description + "," + this.matchSet;
    }
}

