/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.irrelevancestrategies.pathfilters;

import de.setsoftware.reviewtool.model.api.IChange;
import de.setsoftware.reviewtool.model.api.ICommit;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.changestructure.IIrrelevanceDetermination;
import java.util.HashSet;

public class FileCountInCommitFilter
extends IIrrelevanceDetermination {
    private final String description;
    private final int threshold;
    private ICommit curCommit;
    private int fileCountInCurCommit;

    public FileCountInCommitFilter(int number, String description, int threshold) {
        super(number);
        this.description = description;
        this.threshold = threshold;
    }

    public String getDescription() {
        return this.description;
    }

    public void clearCaches() {
        this.curCommit = null;
        this.fileCountInCurCommit = -1;
    }

    public boolean isIrrelevant(ICommit commit, IChange change) {
        if (this.curCommit != commit) {
            this.curCommit = commit;
            this.fileCountInCurCommit = this.countFilesIn(commit);
        }
        return this.fileCountInCurCommit >= this.threshold;
    }

    private int countFilesIn(ICommit commit) {
        HashSet<IRevisionedFile> files = new HashSet<IRevisionedFile>();
        for (IChange c : commit.getChanges()) {
            files.add(c.getTo());
        }
        return files.size();
    }
}

