/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.irrelevancestrategies.basicfilters;

import de.setsoftware.reviewtool.model.api.IChange;
import de.setsoftware.reviewtool.model.api.ICommit;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.ITextualChange;
import de.setsoftware.reviewtool.model.changestructure.IIrrelevanceDetermination;
import de.setsoftware.reviewtool.model.changestructure.TextualChangeHunk;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class ImportChangeFilter
extends IIrrelevanceDetermination {
    public ImportChangeFilter(int number) {
        super(number);
    }

    public String getDescription() {
        return "ignore changes in imports";
    }

    public boolean isIrrelevant(ICommit commit, IChange change) {
        if (change instanceof TextualChangeHunk) {
            ITextualChange hunk = (ITextualChange)change;
            return this.isOnlyImports(hunk.getFromFragment()) && this.isOnlyImports(hunk.getToFragment()) && (!this.isOnlyWhitespace(hunk.getFromFragment()) || !this.isOnlyWhitespace(hunk.getToFragment()));
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isOnlyImports(IFragment fragment) {
        BufferedReader r = new BufferedReader(new StringReader(fragment.getContentFullLines()));
        try {
            String line;
            String trimmed;
            do {
                if ((line = r.readLine()) != null) continue;
                return true;
            } while ((trimmed = line.trim()).isEmpty() || trimmed.startsWith("import "));
            return false;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private boolean isOnlyWhitespace(IFragment fragment) {
        return fragment.getContentFullLines().trim().isEmpty();
    }
}

