/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.remarks;

import de.setsoftware.reviewtool.model.remarks.FileLinePosition;
import de.setsoftware.reviewtool.model.remarks.GlobalPosition;
import de.setsoftware.reviewtool.model.remarks.IReviewMarker;
import de.setsoftware.reviewtool.model.remarks.IReviewResource;
import de.setsoftware.reviewtool.model.remarks.Position;
import de.setsoftware.reviewtool.model.remarks.RemarkType;
import de.setsoftware.reviewtool.model.remarks.ResolutionType;
import de.setsoftware.reviewtool.model.remarks.ReviewRemarkComment;
import de.setsoftware.reviewtool.model.remarks.ReviewRemarkException;
import java.util.ArrayList;
import java.util.List;

public class ReviewRemark {
    public static final String RESOLUTION_MARKER_FIXED = "(/)";
    public static final String RESOLUTION_MARKER_WONTFIX = "(x)";
    public static final String RESOLUTION_MARKER_QUESTION = "(?)";
    public static final String REMARK_TYPE = "de.setsoftware.reviewtool.markerattributes.remarktype";
    public static final String REMARK_RESOLUTION = "de.setsoftware.reviewtool.markerattributes.resolution";
    public static final String REMARK_POSITION = "de.setsoftware.reviewtool.markerattributes.position";
    private final IReviewMarker marker;

    private ReviewRemark(IReviewMarker marker) {
        this.marker = marker;
    }

    public static ReviewRemark create(IReviewResource resource, String user, String text, int line, RemarkType type) throws ReviewRemarkException {
        IReviewMarker marker = resource.createReviewMarker();
        Position pos = resource.createPosition(line);
        return ReviewRemark.create(marker, user, pos, text, type);
    }

    public static ReviewRemark create(IReviewMarker marker, String user, Position position, String text, RemarkType type) throws ReviewRemarkException {
        marker.setMessage(ReviewRemark.formatComment(user, text));
        ReviewRemark.setSeverity(marker, ResolutionType.OPEN, type);
        marker.setAttribute(REMARK_TYPE, type.name());
        marker.setAttribute(REMARK_RESOLUTION, type == RemarkType.ALREADY_FIXED ? ResolutionType.FIXED.name() : ResolutionType.OPEN.name());
        marker.setAttribute(REMARK_POSITION, position.serialize());
        if (position instanceof FileLinePosition) {
            marker.setLineNumber(((FileLinePosition)position).getLine());
        }
        return ReviewRemark.getFor(marker);
    }

    public String getPositionString() throws ReviewRemarkException {
        return this.marker.getAttribute(REMARK_POSITION, new GlobalPosition().serialize());
    }

    public static ReviewRemark getFor(IReviewMarker marker) {
        return new ReviewRemark(marker);
    }

    public ResolutionType getResolution() throws ReviewRemarkException {
        return ResolutionType.valueOf(this.marker.getAttribute(REMARK_RESOLUTION, ResolutionType.OPEN.toString()));
    }

    public RemarkType getRemarkType() throws ReviewRemarkException {
        return RemarkType.valueOf(this.marker.getAttribute(REMARK_TYPE, RemarkType.MUST_FIX.toString()));
    }

    public boolean needsFixing() throws ReviewRemarkException {
        return this.getResolution() == ResolutionType.OPEN && (this.getRemarkType() == RemarkType.CAN_FIX || this.getRemarkType() == RemarkType.MUST_FIX);
    }

    public void setResolution(ResolutionType value) throws ReviewRemarkException {
        ReviewRemark.setSeverity(this.marker, value, this.getRemarkType());
        this.marker.setAttribute(REMARK_RESOLUTION, value.name());
    }

    private static void setSeverity(IReviewMarker marker, ResolutionType resolution, RemarkType type) {
        if (resolution == ResolutionType.FIXED || resolution == ResolutionType.WONT_FIX) {
            marker.setSeverityInfo();
        } else if (type == RemarkType.ALREADY_FIXED || type == RemarkType.POSITIVE || type == RemarkType.TEMPORARY || type == RemarkType.OTHER) {
            marker.setSeverityInfo();
        } else {
            marker.setSeverityWarning();
        }
    }

    public void addComment(String user, String reply) throws ReviewRemarkException {
        String oldText = this.marker.getMessage();
        String newText = String.valueOf(oldText) + "\n\n" + ReviewRemark.formatComment(user, reply);
        this.marker.setMessage(newText);
    }

    private static String formatComment(String user, String comment) {
        return (String.valueOf(user) + ": " + comment).replaceAll("\n+", "\n").trim();
    }

    public List<ReviewRemarkComment> getComments() throws ReviewRemarkException {
        String text = this.marker.getMessage();
        String[] parts = text.split("\n\n");
        ArrayList<ReviewRemarkComment> ret = new ArrayList<ReviewRemarkComment>();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            String[] userAndText = part.split(": ", 2);
            if (userAndText.length != 2) {
                ret.add(new ReviewRemarkComment("", part));
            } else {
                ret.add(new ReviewRemarkComment(userAndText[0], userAndText[1]));
            }
            ++n2;
        }
        return ret;
    }

    public List<ReviewRemarkComment> getFollowUpComments() throws ReviewRemarkException {
        List<ReviewRemarkComment> l = this.getComments();
        return l.subList(1, l.size());
    }

    public String serialize() throws ReviewRemarkException {
        StringBuilder ret = new StringBuilder();
        List<ReviewRemarkComment> comments = this.getComments();
        ret.append("*#").append(ReviewRemark.spacePrefixIfNonempty(this.getPositionString())).append(" ");
        ret.append(comments.get(0).getText()).append(ReviewRemark.spacePrefixIfNonempty(this.resolutionMarker(0, comments))).append("\n");
        int i = 1;
        for (ReviewRemarkComment comment : comments.subList(1, comments.size())) {
            ret.append("*#*").append(ReviewRemark.spacePrefixIfNonempty(this.resolutionMarker(i, comments))).append(" ");
            ret.append(comment.getUser()).append(": ").append(comment.getText()).append("\n");
            ++i;
        }
        return ret.toString();
    }

    private static String spacePrefixIfNonempty(String s) {
        return s.isEmpty() ? s : " " + s;
    }

    private String resolutionMarker(int currentPos, List<ReviewRemarkComment> comments) throws ReviewRemarkException {
        if (currentPos + 1 != comments.size()) {
            return "";
        }
        switch (this.getResolution()) {
            case FIXED: {
                return RESOLUTION_MARKER_FIXED;
            }
            case QUESTION: {
                return RESOLUTION_MARKER_QUESTION;
            }
            case WONT_FIX: {
                return RESOLUTION_MARKER_WONTFIX;
            }
        }
        return "";
    }

    public boolean hasSameTextAndPositionAs(ReviewRemark reviewRemark) throws ReviewRemarkException {
        return this.getPositionString().equals(reviewRemark.getPositionString()) && this.getComments().get(0).getText().equals(reviewRemark.getComments().get(0).getText());
    }

    public void deleteMarker() {
        this.marker.delete();
    }

    private Position getPosition() {
        return Position.parse(this.getPositionString());
    }

    public boolean hasLargerPositionThan(ReviewRemark r2) {
        Position p1 = this.getPosition();
        Position p2 = r2.getPosition();
        String f1 = p1.getShortFileName();
        if (f1 == null) {
            return false;
        }
        String f2 = p2.getShortFileName();
        if (f2 == null) {
            return true;
        }
        if (f1.compareTo(f2) < 0) {
            return false;
        }
        if (f1.compareTo(f2) > 0) {
            return true;
        }
        return p1.getLine() > p2.getLine();
    }

    public String getText() {
        return this.getComments().get(0).getText();
    }
}

