/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.git;

import de.setsoftware.reviewtool.base.IPartiallyComparable;
import de.setsoftware.reviewtool.changesources.git.GitWorkingCopy;
import de.setsoftware.reviewtool.changesources.git.RevisionId;
import de.setsoftware.reviewtool.model.api.IMutableFileHistoryGraph;
import de.setsoftware.reviewtool.model.api.IRepository;
import de.setsoftware.reviewtool.model.api.IRevision;
import de.setsoftware.reviewtool.model.changestructure.ChangestructureFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.io.NullOutputStream;

class GitRevision {
    private final GitWorkingCopy wc;
    private final RevCommit commit;

    GitRevision(GitWorkingCopy wc, RevCommit commit) {
        this.wc = wc;
        this.commit = commit;
    }

    public String getRevisionString() {
        return this.commit.getId().name();
    }

    public IRevision toRevision() {
        return ChangestructureFactory.createRepoRevision((IPartiallyComparable)new RevisionId(this.commit), (IRepository)this.wc.getRepository());
    }

    public Date getDate() {
        return this.commit.getAuthorIdent().getWhen();
    }

    public String getAuthor() {
        return this.commit.getAuthorIdent().getName();
    }

    public String getMessage() {
        return this.commit.getFullMessage();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<String> getChangedPaths() throws IncorrectObjectTypeException, IOException {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        Repository repository = this.wc.getRepository().getRepository();
        RevCommit[] parents = this.commit.getParents();
        if (parents.length > 1) {
            return Collections.emptySet();
        }
        if (parents.length == 1) {
            if (parents[0].getTree() == null) {
                RevTree revTree = repository.parseCommit((AnyObjectId)parents[0]).getTree();
            } else {
                ObjectId objectId = parents[0].getTree().getId();
            }
        } else {
            ObjectId objectId = ObjectId.fromString((String)"4b825dc642cb6eb9a060e54bf8d69288fbee4904");
        }
        Throwable throwable = null;
        Object var6_10 = null;
        try {
            ObjectReader objectReader = repository.newObjectReader();
            try {
                try (DiffFormatter diff = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);){
                    void var4_7;
                    CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
                    oldTreeIter.reset(objectReader, (AnyObjectId)var4_7);
                    CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
                    newTreeIter.reset(objectReader, (AnyObjectId)this.commit.getTree());
                    diff.setRepository(repository);
                    diff.setDetectRenames(true);
                    for (DiffEntry entry : diff.scan((AbstractTreeIterator)oldTreeIter, (AbstractTreeIterator)newTreeIter)) {
                        if (entry.getNewPath().equals("/dev/null")) {
                            ret.add(entry.getOldPath());
                            continue;
                        }
                        ret.add(entry.getNewPath());
                    }
                }
                if (objectReader == null) return ret;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (objectReader == null) throw throwable;
                objectReader.close();
                throw throwable;
            }
            objectReader.close();
            return ret;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void analyzeRevision(IMutableFileHistoryGraph graph) throws IOException {
        ObjectId parentTree;
        RevCommit parentId;
        Repository repository = this.wc.getRepository().getRepository();
        RevCommit[] parents = this.commit.getParents();
        if (parents.length > 1) {
            return;
        }
        if (parents.length == 1) {
            if (parents[0].getTree() == null) {
                parentId = repository.parseCommit((AnyObjectId)parents[0]);
                parentTree = parentId.getTree();
            } else {
                parentId = parents[0];
                parentTree = parents[0].getTree().getId();
            }
        } else {
            parentTree = ObjectId.fromString((String)"4b825dc642cb6eb9a060e54bf8d69288fbee4904");
            parentId = this.commit;
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            ObjectReader objectReader = repository.newObjectReader();
            try {
                try (DiffFormatter diff = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);){
                    CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
                    oldTreeIter.reset(objectReader, (AnyObjectId)parentTree);
                    CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
                    newTreeIter.reset(objectReader, (AnyObjectId)this.commit.getTree());
                    diff.setRepository(repository);
                    diff.setDetectRenames(true);
                    Map<ObjectId, String> contentToPathMap = null;
                    IRevision iRev = this.toRevision();
                    for (DiffEntry entry : diff.scan((AbstractTreeIterator)oldTreeIter, (AbstractTreeIterator)newTreeIter)) {
                        switch (entry.getChangeType()) {
                            case ADD: {
                                String copyFromPath;
                                if (contentToPathMap == null) {
                                    contentToPathMap = this.determineContentToPathMap(repository, parentTree);
                                }
                                if ((copyFromPath = contentToPathMap.get(entry.getNewId().toObjectId())) != null) {
                                    graph.addCopy(copyFromPath, this.toIRevision(parentId), entry.getNewPath(), iRev);
                                    break;
                                }
                                graph.addAddition(entry.getNewPath(), iRev);
                                break;
                            }
                            case DELETE: {
                                graph.addChange(entry.getOldPath(), iRev, Collections.singleton(this.toIRevision(parentId)));
                                graph.addDeletion(entry.getOldPath(), iRev);
                                break;
                            }
                            case COPY: {
                                graph.addCopy(entry.getOldPath(), this.toIRevision(parentId), entry.getNewPath(), iRev);
                                break;
                            }
                            case RENAME: {
                                graph.addDeletion(entry.getOldPath(), iRev);
                                graph.addCopy(entry.getOldPath(), this.toIRevision(parentId), entry.getNewPath(), iRev);
                                break;
                            }
                            case MODIFY: {
                                graph.addChange(entry.getNewPath(), iRev, Collections.singleton(this.toIRevision(parentId)));
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("unexpected: " + entry.getChangeType()));
                            }
                        }
                    }
                }
                if (objectReader == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (objectReader == null) throw throwable;
                objectReader.close();
                throw throwable;
            }
            objectReader.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private Map<ObjectId, String> determineContentToPathMap(Repository repo, ObjectId tree) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TreeWalk treeWalk = new TreeWalk(repo);){
            treeWalk.addTree((AnyObjectId)tree);
            treeWalk.setRecursive(true);
            HashMap<ObjectId, String> ret = new HashMap<ObjectId, String>();
            while (treeWalk.next()) {
                ret.put(treeWalk.getObjectId(0), treeWalk.getPathString());
            }
            return ret;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private IRevision toIRevision(RevCommit parentId) {
        return ChangestructureFactory.createRepoRevision((IPartiallyComparable)new RevisionId(parentId.getName(), parentId.getCommitTime()), (IRepository)this.wc.getRepository());
    }

    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        String message = this.getMessage();
        if (!message.isEmpty()) {
            sb.append(message);
            sb.append(" ");
        }
        sb.append(String.format("(%tF %<tR, %s, %s)", this.getDate(), this.getAuthor(), this.getRevisionString()));
        return sb.toString();
    }

    public GitWorkingCopy getWorkingCopy() {
        return this.wc;
    }
}

