/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.core.ui.intellij.views.toolWindowPanels.fixing;

import com.intellij.openapi.project.Project;
import de.setsoftware.reviewtool.core.ui.intellij.plugin.ReviewPlugin;
import de.setsoftware.reviewtool.core.ui.intellij.views.dialogs.FixingReplyDialog;
import de.setsoftware.reviewtool.model.remarks.ResolutionType;
import de.setsoftware.reviewtool.model.remarks.ReviewRemark;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/views/toolWindowPanels/fixing/MarkRemarkAction;", "Ljava/awt/event/ActionListener;", "withComment", "", "resolutionType", "Lde/setsoftware/reviewtool/model/remarks/ResolutionType;", "reviewRemark", "Lde/setsoftware/reviewtool/model/remarks/ReviewRemark;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(ZLde/setsoftware/reviewtool/model/remarks/ResolutionType;Lde/setsoftware/reviewtool/model/remarks/ReviewRemark;Lcom/intellij/openapi/project/Project;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "mark", "remark", "saveResolution", "IntelliJ-CoRT"})
public abstract class MarkRemarkAction
implements ActionListener {
    private final boolean withComment;
    @NotNull
    private final ResolutionType resolutionType;
    @NotNull
    private final ReviewRemark reviewRemark;
    @NotNull
    private final Project project;

    public MarkRemarkAction(boolean withComment, @NotNull ResolutionType resolutionType, @NotNull ReviewRemark reviewRemark, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)resolutionType, (String)"resolutionType");
        Intrinsics.checkNotNullParameter((Object)reviewRemark, (String)"reviewRemark");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.withComment = withComment;
        this.resolutionType = resolutionType;
        this.reviewRemark = reviewRemark;
        this.project = project;
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.mark(this.reviewRemark);
    }

    private final void mark(ReviewRemark remark) {
        if (this.withComment) {
            FixingReplyDialog dialog = new FixingReplyDialog(remark, this.project);
            if (dialog.showAndGet()) {
                remark.addComment(ReviewPlugin.Companion.getInstance(this.project).getUserId(), dialog.getReplyText());
                this.saveResolution(remark);
            }
        } else {
            this.saveResolution(remark);
        }
    }

    private final void saveResolution(ReviewRemark remark) {
        remark.setResolution(this.resolutionType);
        ReviewPlugin.Companion.getInstance(this.project).getPersistence().saveRemark(remark);
    }
}

