/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.core.ui.intellij;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import de.setsoftware.reviewtool.core.ui.intellij.plugin.ReviewPlugin;
import de.setsoftware.reviewtool.core.ui.intellij.views.dialogs.CreateRemarkDialog;
import de.setsoftware.reviewtool.model.api.PositionReference;
import java.io.File;
import java.nio.file.Path;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/AddReviewCommentAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "anActionEvent", "Companion", "IntelliJ-CoRT"})
@SourceDebugExtension(value={"SMAP\nAddReviewCommentAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddReviewCommentAction.kt\nde/setsoftware/reviewtool/core/ui/intellij/AddReviewCommentAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class AddReviewCommentAction
extends AnAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public AddReviewCommentAction() {
        super(IconLoader.getIcon((String)"/icons/comment_add.png", AddReviewCommentAction.class));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Project project = e.getProject();
        boolean isNotReviewing = project == null || !ReviewPlugin.Companion.getInstance(project).isCurrentlyReviewing();
        e.getPresentation().setEnabledAndVisible(!isNotReviewing);
    }

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        String string;
        Object possibleReferences;
        Pair fileWithLine;
        Project project;
        Editor editor;
        block10: {
            Object object;
            block9: {
                File file;
                VirtualFile virtualFile;
                Intrinsics.checkNotNullParameter((Object)anActionEvent, (String)"anActionEvent");
                Editor editor2 = editor = (Editor)anActionEvent.getData(CommonDataKeys.EDITOR);
                Document document = editor2 != null ? editor2.getDocument() : null;
                FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
                FileDocumentManager fileDocumentManager2 = fileDocumentManager;
                Document document2 = document;
                if (document2 != null) {
                    Document it = document2;
                    boolean bl = false;
                    virtualFile = fileDocumentManager2.getFile(it);
                } else {
                    virtualFile = null;
                }
                VirtualFile currentFile = virtualFile;
                project = anActionEvent.getProject();
                if (project == null || currentFile == null) {
                    LOG.error("Project or current file is unexpectedly undefined. Cannot create review remark.");
                    return;
                }
                Path path = currentFile.getFileSystem().getNioPath(currentFile);
                File file2 = file = path != null ? path.toFile() : null;
                if (file2 != null) {
                    File it = file2;
                    boolean bl = false;
                    int currentLineNumber = editor.getCaretModel().getLogicalPosition().line;
                    v6 = TuplesKt.to((Object)file, (Object)(currentLineNumber + 1));
                } else {
                    v6 = fileWithLine = null;
                }
                if ((object = file) == null) break block9;
                File it = object;
                boolean bl = false;
                Object[] objectArray = new PositionReference[]{PositionReference.LINE, PositionReference.FILE, PositionReference.GLOBAL};
                Set set = SetsKt.setOf((Object[])objectArray);
                object = set;
                if (set != null) break block10;
            }
            object = possibleReferences = SetsKt.setOf((Object)PositionReference.GLOBAL);
        }
        if ((string = editor.getSelectionModel().getSelectedText()) == null) {
            string = "";
        }
        CreateRemarkDialog.Companion.get((Set<? extends PositionReference>)possibleReferences, string, (Pair<? extends File, Integer>)fileWithLine, project);
    }

    static {
        Logger logger = Logger.getInstance(AddReviewCommentAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lde/setsoftware/reviewtool/core/ui/intellij/AddReviewCommentAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "IntelliJ-CoRT"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

