/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.viewtracking;

import de.setsoftware.reviewtool.model.viewtracking.ViewStatDataForStop;
import java.util.HashMap;
import java.util.Map;

public class ViewStatisticsForFile {
    private int unspecificCount;
    private final Map<Integer, Integer> countsPerLine = new HashMap<Integer, Integer>();

    public void mark(int fromLine, int toLine) {
        if (toLine < fromLine) {
            this.increaseCount(fromLine);
            return;
        }
        int line = fromLine;
        while (line <= toLine) {
            this.increaseCount(line);
            ++line;
        }
    }

    private void increaseCount(int line) {
        Integer oldCount = this.countsPerLine.get(line);
        if (oldCount == null) {
            this.countsPerLine.put(line, 1);
        } else if (oldCount < Integer.MAX_VALUE) {
            this.countsPerLine.put(line, oldCount + 1);
        }
    }

    public void markUnknownPosition() {
        if (this.unspecificCount < Integer.MAX_VALUE) {
            ++this.unspecificCount;
        }
    }

    public ViewStatDataForStop determineViewRatioWithoutPosition(int longEnoughCount) {
        double ratio = this.determineRatio(this.unspecificCount, longEnoughCount);
        return new ViewStatDataForStop(ratio, ratio, ratio);
    }

    private double determineRatio(int actualCount, int longEnoughCount) {
        int boundedActual = Math.min(actualCount, longEnoughCount);
        return (double)boundedActual / (double)longEnoughCount;
    }

    public ViewStatDataForStop determineViewRatio(int lineFrom, int lineTo, int longEnoughCount) {
        if (this.countsPerLine.isEmpty()) {
            return this.determineViewRatioWithoutPosition(longEnoughCount);
        }
        if (lineTo < lineFrom) {
            return this.determineViewRatio(lineFrom, lineFrom, longEnoughCount);
        }
        double sum = 0.0;
        int count = 0;
        double max = 0.0;
        double min = Double.MAX_VALUE;
        int line = lineFrom;
        while (line <= lineTo) {
            Integer countForLine = this.countsPerLine.get(line);
            double lineRatio = this.determineRatio(countForLine == null ? 0 : countForLine, longEnoughCount);
            sum += lineRatio;
            ++count;
            max = Math.max(max, lineRatio);
            min = Math.min(min, lineRatio);
            ++line;
        }
        double avg = sum / (double)count;
        return new ViewStatDataForStop(Math.max(Math.min(avg, max), min), max, min);
    }
}

