/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.model.api.IFileDiff;
import de.setsoftware.reviewtool.model.api.IFileHistoryEdge;
import de.setsoftware.reviewtool.model.api.IFileHistoryNode;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.IHunk;
import de.setsoftware.reviewtool.model.api.ILocalRevision;
import de.setsoftware.reviewtool.model.api.IRepoRevision;
import de.setsoftware.reviewtool.model.api.IRevisionVisitor;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.api.IUnknownRevision;
import de.setsoftware.reviewtool.model.api.IncompatibleFragmentException;
import de.setsoftware.reviewtool.model.changestructure.AbstractFileHistoryNode;
import de.setsoftware.reviewtool.model.changestructure.FileDiff;
import de.setsoftware.reviewtool.model.changestructure.VirtualFileHistoryEdge;
import de.setsoftware.reviewtool.model.changestructure.VirtualFileHistoryGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

final class VirtualFileHistoryNode
extends AbstractFileHistoryNode {
    private final VirtualFileHistoryGraph graph;
    private final IRevisionedFile file;
    private final List<IFileHistoryNode> nodes;
    private final List<IFileHistoryEdge> ancestors;
    private final List<IFileHistoryEdge> descendants;
    private final IFileHistoryNode.Type type;

    VirtualFileHistoryNode(VirtualFileHistoryGraph graph, IRevisionedFile file, List<IFileHistoryNode> nodes) {
        assert (!nodes.isEmpty());
        this.graph = graph;
        this.file = file;
        this.nodes = nodes;
        this.ancestors = new ArrayList<IFileHistoryEdge>();
        this.descendants = new ArrayList<IFileHistoryEdge>();
        this.type = this.determineNodeType();
    }

    private IFileHistoryNode.Type determineNodeType() {
        IFileHistoryNode.Type resultingType = IFileHistoryNode.Type.UNCONFIRMED;
        for (IFileHistoryNode node : this.nodes) {
            IFileHistoryNode.Type nodeType = node.getType();
            if (resultingType.equals((Object)IFileHistoryNode.Type.UNCONFIRMED)) {
                resultingType = nodeType;
                continue;
            }
            if (nodeType.equals((Object)IFileHistoryNode.Type.UNCONFIRMED) || nodeType.equals((Object)resultingType)) continue;
            throw new ReviewtoolException("Incompatible types for " + this.file + ": " + (Object)((Object)resultingType) + " # " + (Object)((Object)nodeType));
        }
        return resultingType;
    }

    @Override
    public VirtualFileHistoryGraph getGraph() {
        return this.graph;
    }

    @Override
    public IRevisionedFile getFile() {
        return this.file;
    }

    @Override
    public boolean isRoot() {
        return this.getAncestors().isEmpty();
    }

    @Override
    public IFileHistoryNode.Type getType() {
        return this.type;
    }

    @Override
    public boolean isConfirmed() {
        return !this.type.equals((Object)IFileHistoryNode.Type.UNCONFIRMED);
    }

    @Override
    public boolean isCopyTarget() {
        for (IFileHistoryNode node : this.nodes) {
            if (!node.isCopyTarget()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<? extends IFileHistoryEdge> getAncestors() {
        final LinkedHashSet<IFileHistoryEdge> edges = new LinkedHashSet<IFileHistoryEdge>(this.ancestors);
        final LinkedHashSet alphaEdges = new LinkedHashSet();
        for (IFileHistoryNode node : this.nodes) {
            for (final IFileHistoryEdge iFileHistoryEdge : node.getAncestors()) {
                IRevisionedFile ancestorFile = iFileHistoryEdge.getAncestor().getFile();
                final VirtualFileHistoryEdge edge = new VirtualFileHistoryEdge(this.graph, this.graph.getNodeFor(ancestorFile), this.graph.getNodeFor(iFileHistoryEdge.getDescendant().getFile()), iFileHistoryEdge.getType(), new IFileDiff(){
                    private static final long serialVersionUID = -4532395651797869193L;

                    @Override
                    public List<? extends IHunk> getHunks() {
                        return iFileHistoryEdge.getDiff().getHunks();
                    }

                    @Override
                    public IRevisionedFile getFrom() {
                        return iFileHistoryEdge.getDiff().getFrom();
                    }

                    @Override
                    public IRevisionedFile getTo() {
                        return iFileHistoryEdge.getDiff().getTo();
                    }

                    @Override
                    public IFileDiff setTo(IRevisionedFile newTo) {
                        return iFileHistoryEdge.getDiff().setTo(newTo);
                    }

                    @Override
                    public IFragment traceFragment(IFragment source) {
                        return iFileHistoryEdge.getDiff().traceFragment(source);
                    }

                    @Override
                    public List<? extends IHunk> getHunksWithTargetChangesInOneOf(Collection<? extends IFragment> fragments) {
                        return iFileHistoryEdge.getDiff().getHunksWithTargetChangesInOneOf(fragments);
                    }

                    @Override
                    public IFileDiff merge(IHunk hunkToMerge) throws IncompatibleFragmentException {
                        return iFileHistoryEdge.getDiff().merge(hunkToMerge);
                    }

                    @Override
                    public IFileDiff merge(Collection<? extends IHunk> hunksToMerge) throws IncompatibleFragmentException {
                        return iFileHistoryEdge.getDiff().merge(hunksToMerge);
                    }

                    @Override
                    public IFileDiff merge(IFileDiff diff) throws IncompatibleFragmentException {
                        return iFileHistoryEdge.getDiff().merge(diff);
                    }
                });
                ancestorFile.getRevision().accept(new IRevisionVisitor<Void>(){

                    @Override
                    public Void handleLocalRevision(ILocalRevision revision) {
                        edges.add(edge);
                        return null;
                    }

                    @Override
                    public Void handleRepoRevision(IRepoRevision<?> revision) {
                        edges.add(edge);
                        return null;
                    }

                    @Override
                    public Void handleUnknownRevision(IUnknownRevision revision) {
                        alphaEdges.add(edge);
                        return null;
                    }
                });
            }
        }
        return edges.isEmpty() ? alphaEdges : edges;
    }

    @Override
    public Set<? extends IFileHistoryEdge> getDescendants() {
        LinkedHashSet<IFileHistoryEdge> edges = new LinkedHashSet<IFileHistoryEdge>(this.descendants);
        for (IFileHistoryNode node : this.nodes) {
            for (IFileHistoryEdge iFileHistoryEdge : node.getDescendants()) {
                edges.add(new VirtualFileHistoryEdge(this.graph, this.graph.getNodeFor(iFileHistoryEdge.getAncestor().getFile()), this.graph.getNodeFor(iFileHistoryEdge.getDescendant().getFile()), iFileHistoryEdge.getType(), iFileHistoryEdge.getDiff()));
            }
        }
        return edges;
    }

    void addAncestor(IFileHistoryNode ancestor) {
        this.ancestors.add(new VirtualFileHistoryEdge(this.graph, ancestor, this, IFileHistoryEdge.Type.NORMAL, new FileDiff(ancestor.getFile(), this.getFile())));
    }

    void addDescendant(IFileHistoryNode descendant) {
        this.descendants.add(new VirtualFileHistoryEdge(this.graph, this, descendant, IFileHistoryEdge.Type.NORMAL, new FileDiff(this.getFile(), descendant.getFile())));
    }

    public boolean equals(Object o) {
        if (o instanceof VirtualFileHistoryNode) {
            VirtualFileHistoryNode other = (VirtualFileHistoryNode)o;
            return this.file.equals(other.getFile());
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

