/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.base.Multiset;
import de.setsoftware.reviewtool.base.Pair;
import de.setsoftware.reviewtool.base.WeakListeners;
import de.setsoftware.reviewtool.model.api.BackgroundJobExecutor;
import de.setsoftware.reviewtool.model.api.IBinaryChange;
import de.setsoftware.reviewtool.model.api.IChange;
import de.setsoftware.reviewtool.model.api.IChangeData;
import de.setsoftware.reviewtool.model.api.IChangeSourceUi;
import de.setsoftware.reviewtool.model.api.IChangeVisitor;
import de.setsoftware.reviewtool.model.api.IClassification;
import de.setsoftware.reviewtool.model.api.ICommit;
import de.setsoftware.reviewtool.model.api.ICortProgressMonitor;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.IFragmentTracer;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.api.ITextualChange;
import de.setsoftware.reviewtool.model.api.IWorkingCopy;
import de.setsoftware.reviewtool.model.changestructure.CommitsInReview;
import de.setsoftware.reviewtool.model.changestructure.FragmentTracer;
import de.setsoftware.reviewtool.model.changestructure.IChangeClassifier;
import de.setsoftware.reviewtool.model.changestructure.IStopMarker;
import de.setsoftware.reviewtool.model.changestructure.IStopMarkerFactory;
import de.setsoftware.reviewtool.model.changestructure.IStopOrdering;
import de.setsoftware.reviewtool.model.changestructure.ITourRestructuring;
import de.setsoftware.reviewtool.model.changestructure.Stop;
import de.setsoftware.reviewtool.model.changestructure.Tour;
import de.setsoftware.reviewtool.model.changestructure.TourElement;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.TourCalculatorControl;
import de.setsoftware.reviewtool.telemetry.Telemetry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ToursInReview {
    private final List<Tour> topmostTours;
    private int currentTourIndex;
    private final WeakListeners<IToursInReviewChangeListener> listeners = new WeakListeners();
    private final Set<? extends IClassification> irrelevantCategories;

    private ToursInReview(List<? extends Tour> topmostTours, Set<? extends IClassification> irrelevantCategories) {
        this.topmostTours = new ArrayList<Tour>(topmostTours);
        this.currentTourIndex = 0;
        this.irrelevantCategories = irrelevantCategories;
        this.updateMostRecentFragmentsWithLocalChanges();
    }

    private ToursInReview(List<? extends Tour> topmostTours) {
        this.topmostTours = new ArrayList<Tour>(topmostTours);
        this.currentTourIndex = 0;
        this.irrelevantCategories = Collections.emptySet();
    }

    public static ToursInReview create(List<Tour> tours) {
        return new ToursInReview(tours);
    }

    public static ToursInReview create(final IChangeSourceUi changeSourceUi, List<? extends IChangeClassifier> changeClassificationStrategies, List<? extends ITourRestructuring> tourRestructuringStrategies, IStopOrdering orderingAlgorithm, ICreateToursUi createUi, IChangeData changes, List<ReviewRoundInfo> reviewRounds) {
        changeSourceUi.subTask("Filtering changes...");
        UserSelectedReductions filteredChanges = ToursInReview.filterChanges(changeClassificationStrategies, changes.getMatchedCommits(), createUi, changeSourceUi, reviewRounds);
        if (filteredChanges == null) {
            return null;
        }
        changeSourceUi.subTask("Creating tours from changes...");
        List<Tour> tours = ToursInReview.toTours(filteredChanges.commitSubset, new FragmentTracer(), changeSourceUi);
        Logger.info("initial tours=" + ToursInReview.formatSizes(tours));
        List<? extends Tour> userSelection = ToursInReview.determinePossibleRestructurings(tourRestructuringStrategies, tours, createUi, changeSourceUi, filteredChanges.toMakeIrrelevant);
        if (userSelection == null) {
            return null;
        }
        Logger.info("userSelection tours=" + ToursInReview.formatSizes(userSelection));
        changeSourceUi.subTask("Ordering stops...");
        List<? extends Tour> toursToShow = ToursInReview.groupAndSort(userSelection, filteredChanges.toMakeIrrelevant, orderingAlgorithm, new TourCalculatorControl(){
            private static final long FAST_MODE_THRESHOLD = 20000L;
            private final long startTime = System.currentTimeMillis();

            public synchronized boolean isCanceled() {
                return changeSourceUi.isCanceled();
            }

            public boolean isFastModeNeeded() {
                return System.currentTimeMillis() - this.startTime > 20000L;
            }
        });
        Logger.info("after ordering tours=" + ToursInReview.formatSizes(toursToShow));
        return new ToursInReview(toursToShow, filteredChanges.toMakeIrrelevant);
    }

    private static String formatSizes(List<? extends Tour> tours) {
        int stopCount = 0;
        for (Tour tour : tours) {
            stopCount += tour.getStops().size();
        }
        return String.valueOf(tours.size()) + " tours, " + stopCount + " stops";
    }

    private static List<? extends Tour> groupAndSort(List<? extends Tour> userSelection, Set<? extends IClassification> irrelevantCategories, IStopOrdering orderingAlgorithm, TourCalculatorControl isCanceled) {
        try {
            ArrayList<Tour> ret = new ArrayList<Tour>();
            for (Tour tour : userSelection) {
                ret.add(new Tour(tour.getDescription(), orderingAlgorithm.groupAndSort(tour.getStops(), isCanceled, irrelevantCategories)));
            }
            return ret;
        }
        catch (InterruptedException e) {
            throw BackgroundJobExecutor.createOperationCanceledException();
        }
    }

    public synchronized void updateMostRecentFragmentsWithLocalChanges() {
        FragmentTracer tracer = new FragmentTracer();
        for (Tour tour : this.topmostTours) {
            for (Stop stop : tour.getStops()) {
                stop.updateMostRecentData(tracer);
            }
        }
    }

    private static UserSelectedReductions filterChanges(List<? extends IChangeClassifier> changeClassificationStrategies, List<? extends ICommit> changes, ICreateToursUi createUi, ICortProgressMonitor progressMonitor, List<ReviewRoundInfo> reviewRounds) {
        Telemetry.event("originalChanges").param("count", ToursInReview.countChanges(changes)).log();
        for (IChangeClassifier iChangeClassifier : changeClassificationStrategies) {
            iChangeClassifier.clearCaches();
        }
        ArrayList<ICommit> arrayList = new ArrayList<ICommit>();
        for (ICommit iCommit : changes) {
            arrayList.add(iCommit.transformChanges(c -> ToursInReview.addClassifications(commit, c, changeClassificationStrategies, progressMonitor)));
        }
        for (IChangeClassifier iChangeClassifier : changeClassificationStrategies) {
            iChangeClassifier.clearCaches();
        }
        Multiset<IClassification> multiset = new Multiset<IClassification>();
        for (ICommit commit : arrayList) {
            for (IChange iChange : commit.getChanges()) {
                IClassification[] iClassificationArray = iChange.getClassification();
                int n = iClassificationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClassification classification = iClassificationArray[n2];
                    multiset.add(classification);
                    ++n2;
                }
            }
        }
        for (IClassification classification : multiset.keySet()) {
            Telemetry.event("classificationResult").param("description", classification.getName()).param("size", multiset.get(classification)).log();
        }
        UserSelectedReductions selected = createUi.selectIrrelevant(arrayList, multiset, reviewRounds);
        if (selected == null) {
            return null;
        }
        Telemetry.event("selectedRelevanceFilter").param("descriptions", selected.toMakeIrrelevant).log();
        LinkedHashSet<String> selectedCommits = new LinkedHashSet<String>();
        for (ICommit iCommit : selected.commitSubset) {
            selectedCommits.add(iCommit.getRevision().toString());
        }
        Telemetry.event("selectedCommitSubset").param("commits", selectedCommits).log();
        CommitsInReview.setCommits(new ArrayList<ICommit>(selected.commitSubset));
        return selected;
    }

    private static IChange addClassifications(ICommit commit, IChange change, List<? extends IChangeClassifier> changeClassificationStrategies, ICortProgressMonitor progressMonitor) {
        IChange ret = change;
        for (IChangeClassifier iChangeClassifier : changeClassificationStrategies) {
            if (progressMonitor.isCanceled()) {
                throw BackgroundJobExecutor.createOperationCanceledException();
            }
            try {
                IClassification cl = iChangeClassifier.classify(commit, ret);
                if (cl == null) continue;
                ret = ret.addClassification(cl);
            }
            catch (Exception e) {
                Logger.error("exception in classification", e);
            }
        }
        return ret;
    }

    private static int countChanges(List<? extends ICommit> changes) {
        int ret = 0;
        for (ICommit iCommit : changes) {
            ret += iCommit.getChanges().size();
        }
        return ret;
    }

    private static List<? extends Tour> determinePossibleRestructurings(List<? extends ITourRestructuring> tourRestructuringStrategies, List<Tour> originalTours, ICreateToursUi createUi, ICortProgressMonitor progressMonitor, Set<? extends IClassification> irrelevantCategories) {
        ArrayList<Pair<String, List<? extends Tour>>> possibleRestructurings = new ArrayList<Pair<String, List<? extends Tour>>>();
        possibleRestructurings.add(Pair.create("one tour per commit", originalTours));
        Telemetry.event("originalTourStructure").params(Tour.determineSize(originalTours, irrelevantCategories)).log();
        for (ITourRestructuring iTourRestructuring : tourRestructuringStrategies) {
            if (progressMonitor.isCanceled()) {
                throw BackgroundJobExecutor.createOperationCanceledException();
            }
            try {
                List<? extends Tour> restructuredTour = iTourRestructuring.restructure(new ArrayList<Tour>(originalTours));
                Telemetry.event("possibleTourStructure").param("strategy", iTourRestructuring.getClass()).params(Tour.determineSize(restructuredTour, irrelevantCategories)).log();
                if (restructuredTour == null) continue;
                possibleRestructurings.add(Pair.create(iTourRestructuring.getDescription(), restructuredTour));
            }
            catch (Exception e) {
                Logger.error("exception in restructuring", e);
            }
        }
        return createUi.selectInitialTours(possibleRestructurings);
    }

    private static List<Tour> toTours(List<? extends ICommit> changes, IFragmentTracer tracer, ICortProgressMonitor progressMonitor) {
        ArrayList<Tour> ret = new ArrayList<Tour>();
        for (ICommit iCommit : changes) {
            if (progressMonitor.isCanceled()) {
                throw BackgroundJobExecutor.createOperationCanceledException();
            }
            ret.add(new Tour(iCommit.getMessage(), ToursInReview.toSliceFragments(iCommit.getChanges(), tracer)));
        }
        return ret;
    }

    private static List<Stop> toSliceFragments(List<? extends IChange> changes, IFragmentTracer tracer) {
        ArrayList<Stop> ret = new ArrayList<Stop>();
        for (IChange iChange : changes) {
            ret.addAll(ToursInReview.toSliceFragment(iChange, tracer));
        }
        return ret;
    }

    private static List<Stop> toSliceFragment(final IChange c, final IFragmentTracer tracer) {
        final ArrayList<Stop> ret = new ArrayList<Stop>();
        c.accept(new IChangeVisitor(){

            @Override
            public void handle(ITextualChange visitee) {
                IWorkingCopy wc = c.getWorkingCopy();
                List<? extends IFragment> mostRecentFragments = tracer.traceFragment(wc.getRepository().getFileHistoryGraph(), visitee.getToFragment(), false);
                for (IFragment iFragment : mostRecentFragments) {
                    if (wc.toAbsolutePathInWc(iFragment.getFile().getPath()) == null) continue;
                    ret.add(new Stop(visitee, iFragment));
                }
            }

            @Override
            public void handle(IBinaryChange visitee) {
                IWorkingCopy wc = c.getWorkingCopy();
                for (IRevisionedFile fileInRevision : tracer.traceFile(wc.getRepository().getFileHistoryGraph(), visitee.getFrom(), false)) {
                    if (wc.toAbsolutePathInWc(fileInRevision.getPath()) == null) continue;
                    ret.add(new Stop(visitee, fileInRevision));
                }
            }
        });
        return ret;
    }

    public void createMarkers(IStopMarkerFactory markerFactory, ICortProgressMonitor progressMonitor) {
        int i = 0;
        while (i < this.topmostTours.size()) {
            Tour s = this.topmostTours.get(i);
            for (Stop f : s.getStops()) {
                if (progressMonitor.isCanceled()) {
                    throw BackgroundJobExecutor.createOperationCanceledException();
                }
                this.createMarkerFor(markerFactory, s, f, i == this.currentTourIndex);
            }
            ++i;
        }
    }

    private IStopMarker createMarkerFor(IStopMarkerFactory markerFactory, Tour topmostTour, Stop f, boolean tourActive) {
        IStopMarker marker;
        String message = String.valueOf(f.getClassificationFormatted()) + topmostTour.getDescription();
        if (f.isDetailedFragmentKnown()) {
            IFragment pos = f.getMostRecentFragment();
            marker = markerFactory.createStopMarker(f.getMostRecentFile(), tourActive, message, pos);
        } else {
            marker = markerFactory.createStopMarker(f.getMostRecentFile(), tourActive, message);
        }
        return marker;
    }

    public IStopMarker createMarkerFor(IStopMarkerFactory markerFactory, Tour topmostTour, Stop f) {
        return this.createMarkerFor(markerFactory, topmostTour, f, true);
    }

    public List<Tour> getTopmostTours() {
        return this.topmostTours;
    }

    public void ensureTourActive(Tour topmostTour, IStopMarkerFactory markerFactory) {
        this.ensureTourActive(topmostTour, markerFactory, true);
    }

    public void ensureTourActive(Tour t, IStopMarkerFactory markerFactory, boolean notify) {
        int index = this.topmostTours.indexOf(t);
        if (index != this.currentTourIndex) {
            Tour oldActive = this.getActiveTour();
            this.currentTourIndex = index;
            BackgroundJobExecutor.execute("Review marker update", progressMonitor -> {
                try {
                    markerFactory.clearStopMarkers();
                    this.createMarkers(markerFactory, (ICortProgressMonitor)progressMonitor);
                    return null;
                }
                catch (Exception e) {
                    return e;
                }
            });
            if (notify) {
                this.listeners.notifyListeners(l -> l.activeTourChanged(oldActive, this.getActiveTour()));
            }
            Telemetry.event("tourActivated").param("tourIndex", index).log();
        }
    }

    public Tour getActiveTour() {
        return this.currentTourIndex >= this.topmostTours.size() || this.currentTourIndex < 0 ? null : this.topmostTours.get(this.currentTourIndex);
    }

    public void registerListener(IToursInReviewChangeListener listener) {
        this.listeners.add(listener);
    }

    public List<Stop> getStopsFor(File absolutePath) {
        ArrayList<Stop> ret = new ArrayList<Stop>();
        for (Tour t : this.topmostTours) {
            ret.addAll(t.getStopsFor(absolutePath));
        }
        return ret;
    }

    public int findTourIndexWithStop(Stop currentStop) {
        int i = 0;
        while (i < this.topmostTours.size()) {
            for (Stop s : this.topmostTours.get(i).getStops()) {
                if (s != currentStop) continue;
                return i;
            }
            ++i;
        }
        return 0;
    }

    public Pair<Tour, Stop> findNearestStop(File absoluteResourcePath, int line) {
        if (this.topmostTours.isEmpty()) {
            return null;
        }
        Tour bestTour = null;
        Stop bestStop = null;
        int bestDist = Integer.MAX_VALUE;
        for (Tour t : this.topmostTours) {
            for (Stop stop : t.getStops()) {
                int candidateDist = this.calculateDistance(stop, absoluteResourcePath, line);
                if (candidateDist >= bestDist) continue;
                bestTour = t;
                bestStop = stop;
                bestDist = candidateDist;
            }
        }
        return Pair.create(bestTour, bestStop);
    }

    private int calculateDistance(Stop stop, File resource, int line) {
        if (!stop.getMostRecentFile().toLocalPath(stop.getWorkingCopy()).equals(resource)) {
            return Integer.MAX_VALUE;
        }
        IFragment fragment = stop.getMostRecentFragment();
        if (fragment == null) {
            return 0x7FFFFFFE;
        }
        if (line < fragment.getFrom().getLine()) {
            return (fragment.getFrom().getLine() - line) * 4;
        }
        if (line > fragment.getTo().getLine()) {
            return line - fragment.getTo().getLine();
        }
        return 0;
    }

    public Tour getParentFor(TourElement element) {
        for (Tour t : this.topmostTours) {
            Tour parent = t.findParentFor(element);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public Tour getTopmostTourWith(TourElement element) {
        for (Tour t : this.topmostTours) {
            Tour parent = t.findParentFor(element);
            if (parent == null) continue;
            return t;
        }
        return null;
    }

    public Set<? extends IClassification> getIrrelevantCategories() {
        return this.irrelevantCategories;
    }

    public static interface ICreateToursUi {
        public List<? extends Tour> selectInitialTours(List<? extends Pair<String, List<? extends Tour>>> var1);

        public UserSelectedReductions selectIrrelevant(List<? extends ICommit> var1, Multiset<IClassification> var2, List<ReviewRoundInfo> var3);
    }

    public static interface IToursInReviewChangeListener {
        public void toursChanged();

        public void activeTourChanged(Tour var1, Tour var2);
    }

    public static final class ReviewRoundInfo
    implements Comparable<ReviewRoundInfo> {
        private final int number;
        private final Date date;
        private final String user;

        public ReviewRoundInfo(int number, Date date, String user) {
            this.number = number;
            this.date = date;
            this.user = user;
        }

        @Override
        public int compareTo(ReviewRoundInfo o) {
            return Integer.compare(this.number, o.number);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ReviewRoundInfo)) {
                return false;
            }
            return this.compareTo((ReviewRoundInfo)o) == 0;
        }

        public int hashCode() {
            return this.number;
        }

        public Date getTime() {
            return this.date;
        }

        public String getReviewer() {
            return this.user;
        }

        public int getNumber() {
            return this.number;
        }
    }

    public static final class UserSelectedReductions {
        private final List<? extends ICommit> commitSubset;
        private final Set<? extends IClassification> toMakeIrrelevant;

        public UserSelectedReductions(List<? extends ICommit> chosenCommitSubset, Set<? extends IClassification> chosenFilterSubset) {
            this.commitSubset = chosenCommitSubset;
            this.toMakeIrrelevant = chosenFilterSubset;
        }
    }
}

